/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.driver.xdja;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.cryptodev.CryptoDevInfo;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.devapi.CryptoInstance;
import com.xdja.cryptodev.driver.IDevDriver;
import com.xdja.cryptodev.driver.xdja.XdjaKey;
import java.util.Iterator;

public class XdjaDevDriver
extends IDevDriver {
    private Context context = null;
    private JNIAPI jniapi = new JNIAPI();
    private static final String THIS_FILE = "XdjaDevDriver";
    private BroadcastReceiver sdcardReceiver;
    public static final String DRIVER_NAME = "XDJA-key";
    static byte[][][] xdja_fid_array = new byte[][][]{new byte[][]{{41, 42, 43}, {44, 45, 46}}, new byte[][]{{48, 49, 50}, {51, 52, 53}}, new byte[][]{{55, 56, 57}, {58, 59, 60}}, new byte[][]{{62, 63, 64}, {65, 66, 67}}, new byte[][]{{69, 70, 71}, {72, 73, 74}}, new byte[][]{{76, 77, 78}, {79, 80, 81}}, new byte[][]{{83, 84, 85}, {86, 87, 88}}, new byte[][]{{90, 91, 92}, {93, 94, 95}}, new byte[][]{{97, 98, 99}, {100, 101, 102}}, new byte[][]{{104, 105, 106}, {107, 108, 109}}};

    public static byte[] getSignCertFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][1][0]};
        return fid;
    }

    public static byte[] getSignPubkeyFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][1][1]};
        return fid;
    }

    public static byte[] getSignPrikeyFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][1][2]};
        return fid;
    }

    public static byte[] getExchCertFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][0][0]};
        return fid;
    }

    public static byte[] getExchPubkeyFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][0][1]};
        return fid;
    }

    public static byte[] getExchPrikeyFidOfContainer(int containerId) {
        byte[] fid = new byte[]{0, xdja_fid_array[containerId][0][2]};
        return fid;
    }

    @Override
    public String getDriverName() {
        return DRIVER_NAME;
    }

    @Override
    public int init() {
        this.context = CryptoDevManager.getInstance().getContext();
        this.sdcardReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action;
                switch (action = intent.getAction()) {
                    case "android.intent.action.MEDIA_EJECT": {
                        Log.d((String)XdjaDevDriver.THIS_FILE, (String)"Media disk eject");
                        Iterator devIterator = XdjaDevDriver.this.cryptoDevs.iterator();
                        while (devIterator.hasNext()) {
                            CryptoInstance dev = (CryptoInstance)devIterator.next();
                            if (dev.getDevInfo().getType() != CryptoDevType.DEV_TYPE_SdCard) continue;
                            int ret = dev.open();
                            if (ret == 0) {
                                dev.close();
                                continue;
                            }
                            dev.close();
                            dev.onError(1005);
                            devIterator.remove();
                        }
                        XdjaDevDriver.this.refresh();
                        break;
                    }
                    case "android.intent.action.MEDIA_MOUNTED": {
                        Log.d((String)XdjaDevDriver.THIS_FILE, (String)"Media disk mounted. Need to rescan tf device");
                        XdjaDevDriver.this.refresh();
                    }
                }
            }
        };
        IntentFilter sdcardFilter = new IntentFilter();
        sdcardFilter.addAction("android.intent.action.MEDIA_EJECT");
        sdcardFilter.addAction("android.intent.action.MEDIA_MOUNTED");
        sdcardFilter.addDataScheme("file");
        this.context.registerReceiver(this.sdcardReceiver, sdcardFilter);
        this.refresh();
        return 0;
    }

    @Override
    public int refresh() {
        int[] devCnt = new int[1];
        String packageName = this.context.getPackageName();
        int[] devNum = new int[1];
        long[] handle = new long[1];
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();
        this.devInfos.clear();
        int ret = this.jniapi.OpenDevByNameEx(packageName.getBytes(), handle);
        if (ret != 0) {
            Log.d((String)THIS_FILE, (String)("OpenDevByNameEx failed. return " + ret));
        } else {
            ret = this.jniapi.GetDevInfo(handle[0], xdja_devinfo);
            if (ret == 0) {
                String cardId = new String(xdja_devinfo.cardid, 0, 32);
                CryptoDevInfo devInfo = new CryptoDevInfo();
                devInfo.setType(this.typeConvert(xdja_devinfo.cardtype));
                devInfo.setDriver(DRIVER_NAME);
                devInfo.setCardId(cardId);
                this.devInfos.add(devInfo);
            }
            this.jniapi.CloseDev(handle[0]);
        }
        ret = this.jniapi.EnumDev(0, devCnt);
        if (ret != 0) {
            Log.d((String)THIS_FILE, (String)("EnumDev faild. return " + ret));
            return 0;
        }
        for (int i = 0; i < devCnt[0]; ++i) {
            ret = this.jniapi.OpenDev(i, handle);
            if (ret != 0) {
                Log.e((String)THIS_FILE, (String)("OpenDev failed. index " + i + " return " + ret));
                continue;
            }
            ret = this.jniapi.GetDevInfo(handle[0], xdja_devinfo);
            if (ret != 0) continue;
            String cardId = new String(xdja_devinfo.cardid, 0, 32);
            if (CryptoDevManager.inDevList(this.devInfos, cardId)) {
                Log.d((String)THIS_FILE, (String)"Device already in dev list");
                this.jniapi.CloseDev(handle[0]);
                continue;
            }
            CryptoDevInfo devInfo = new CryptoDevInfo();
            devInfo.setType(this.typeConvert(xdja_devinfo.cardtype));
            devInfo.setDriver(DRIVER_NAME);
            devInfo.setCardId(cardId);
            this.devInfos.add(devInfo);
            this.jniapi.CloseDev(handle[0]);
        }
        return super.refresh();
    }

    private CryptoDevType typeConvert(int xdjaType) {
        switch (xdjaType) {
            case 531: 
            case 533: 
            case 535: {
                return CryptoDevType.DEV_TYPE_Chip;
            }
            case 512: 
            case 528: {
                return CryptoDevType.DEV_TYPE_SdCard;
            }
            case 256: {
                return CryptoDevType.DEV_TYPE_UsbKey;
            }
        }
        return CryptoDevType.DEV_TYPE_Chip;
    }

    @Override
    public CryptoInstance createInstance(CryptoDevInfo devInfo) {
        XdjaKey dev = new XdjaKey(this, devInfo);
        this.cryptoDevs.add(dev);
        return dev;
    }

    @Override
    public void destroy() {
        this.context.unregisterReceiver(this.sdcardReceiver);
        super.destroy();
    }
}

