/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cryptodev.error;

import android.content.Context;
import android.util.Log;
import com.xdja.cryptodev.R;
import com.xdja.cryptodev.error.ErrorCallback;
import java.util.ArrayList;

public class SysError {
    public static final int SUCCESS = 0;
    private static final int E_COMMON_BEGIN = 1000;
    public static final int E_UNKOWN = 1000;
    public static final int E_EXISTS = 1001;
    public static final int E_TOOMANEY = 1002;
    public static final int E_INVALID_ARG = 1003;
    public static final int E_TOOLONG = 1004;
    public static final int E_SDEJECT = 1005;
    public static final int E_NOT_EXISTS = 1006;
    private static final int E_COMMON_END = 2000;
    private Context context = null;
    private ArrayList<ErrorCallback> errorCallbacks = new ArrayList();
    private static final String THIS_FILE = "SysError";

    public static boolean inRange(int code, int begin, int end) {
        return code >= begin && code < end;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public int registerError(ErrorCallback errorCallback) {
        if (this.errorCallbacks.contains(errorCallback)) {
            Log.d((String)THIS_FILE, (String)"Error callback already registered");
            return 0;
        }
        int begin = errorCallback.getErrorBegin();
        int end = errorCallback.getErrorEnd();
        for (ErrorCallback cb : this.errorCallbacks) {
            if (!SysError.inRange(begin, cb.getErrorBegin(), cb.getErrorEnd()) && !SysError.inRange(end - 1, cb.getErrorBegin(), cb.getErrorEnd())) continue;
            Log.d((String)THIS_FILE, (String)"Error cannot registered, has conclusion");
            return 1001;
        }
        this.errorCallbacks.add(errorCallback);
        return 0;
    }

    public String getErrorText(int errCode) {
        if (errCode == 0) {
            return this.context.getString(R.string.e_success);
        }
        if (SysError.inRange(errCode, 1000, 2000)) {
            return this.getCommonErrorText(errCode);
        }
        for (ErrorCallback cb : this.errorCallbacks) {
            if (!SysError.inRange(errCode, cb.getErrorBegin(), cb.getErrorEnd())) continue;
            return cb.getComment(errCode);
        }
        Log.d((String)THIS_FILE, (String)"Handler not found.");
        return this.context.getString(R.string.e_unkown);
    }

    public void clearErrors() {
        this.errorCallbacks.clear();
    }

    private String getCommonErrorText(int errCode) {
        switch (errCode) {
            case 1001: {
                return this.context.getString(R.string.e_exists);
            }
            case 1003: {
                return this.context.getString(R.string.e_invaid_arg);
            }
            case 1005: {
                return this.context.getString(R.string.e_sdeject);
            }
            case 1004: {
                return this.context.getString(R.string.e_toolong);
            }
            case 1002: {
                return this.context.getString(R.string.e_toomany);
            }
            case 1006: {
                return this.context.getString(R.string.e_not_exists);
            }
        }
        return this.context.getString(R.string.e_unkown);
    }
}

