/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.AnimationDrawable;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.callback.FaceInfoCallback;
import cn.cloudwalk.callback.LivessCallBack;
import cn.cloudwalk.jni.FaceInfo;
import cn.cloudwalk.libproject.Bulider;
import cn.cloudwalk.libproject.LiveResultActivity;
import cn.cloudwalk.libproject.R;
import cn.cloudwalk.libproject.camera.CameraPreview;
import cn.cloudwalk.libproject.progressHUD.CwProgressHUD;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.CameraUtil;
import cn.cloudwalk.libproject.util.DisplayUtil;
import cn.cloudwalk.libproject.util.LogUtils;
import cn.cloudwalk.libproject.util.UIUtils;
import cn.cloudwalk.libproject.util.Util;
import cn.cloudwalk.libproject.view.CustomViewPager;
import cn.cloudwalk.libproject.view.RoundProgressBarWidthNumber;
import com.aircert.BusProvider;
import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.SPermission;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.event.LiveResult;
import com.aircert.listener.OnPermissionListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LiveActivity
extends ToolBarActivity
implements LivessCallBack,
FaceInfoCallback,
View.OnClickListener {
    private final String TAG = LogUtils.makeLogTag("LiveActivity");
    static final int NEXT_STEP = 101;
    static final int UPDATE_STEP_PROCRESS = 106;
    static final int SET_RESULT = 122;
    static final int UPDATESTEPLAYOUT = 124;
    static final int PLAYMAIN_END = 125;
    static final int DETECT_READY = 126;
    static final int PREPARE_RESET_INFO = 127;
    boolean isStop;
    boolean isLivePass;
    boolean isSetResult = false;
    volatile boolean isStartDetectFace;
    int orientation;
    public SoundPool sndPool;
    public Map<String, Integer> poolMap;
    int currentStreamID;
    boolean isLoadmain;
    boolean isPlayMain = false;
    CameraPreview mPreview;
    int caremaId;
    ImageView mIv_top;
    RelativeLayout mRl_bottom;
    CustomViewPager mViewPager;
    ViewPagerAdapter viewPagerAdapter;
    RoundProgressBarWidthNumber mPb_step;
    ImageView mIv_step;
    TextView mTv_step;
    TimerRunnable faceTimerRunnable;
    private AnimationDrawable animationDrawable;
    int totalStep;
    int currentStep;
    ArrayList<View> viewList;
    MainHandler mMainHandler;
    public CloudwalkSDK cloudwalkSDK;
    public int initRet;
    public static List<Integer> execLiveList;
    public CwProgressHUD processDialog;
    long mLastPrepareInfoTime = 0L;
    static final int DURATION_PREPARE_INFO = 3000;
    private SPermission sPermission;
    byte[] clipedBestFaceData;
    private SinglePermissionDialog baseErrorDialog;

    private void initcloudwalkSDK() {
        this.cloudwalkSDK = CloudwalkSDK.getInstance();
        int op = 4070;
        this.cloudwalkSDK.setOperator(op);
        String license = this.getIntent().getStringExtra("license");
        if (license == null || license.length() <= 0) {
            this.initRet = this.cloudwalkSDK.cwInit(Bulider.licence);
        } else {
            Bulider.licence = license;
            this.initRet = this.cloudwalkSDK.cwInit(license);
        }
    }

    protected boolean hasActionBar() {
        this.orientation = this.getResources().getConfiguration().orientation;
        return true;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.MTransparentAnim);
        BusProvider.register((Object)((Object)this));
        this.setContentView(R.layout.cloudwalk_activity_facedect);
        this.setRightImage(R.drawable.btn_switch, this);
        this.mMainHandler = new MainHandler(this);
        this.sPermission = new SPermission(this.getApplicationContext());
        this.initSoundPool((Context)this);
        if (Bulider.totalLiveList.size() == 0) {
            this.finish();
            return;
        }
        this.initView();
        this.initStepViews();
        this.initcloudwalkSDK();
        this.initCallBack();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.title_right_btn) {
            this.caremaId = this.mPreview.switchCarema();
            this.stopTimerRunnable();
            this.resetLive();
        }
    }

    protected int getTitleRes() {
        return R.string.live_title;
    }

    private void playMain() {
        if (this.isPlayMain && this.isLoadmain) {
            this.isPlayMain = false;
            this.currentStreamID = 1;
            this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
            this.mMainHandler.sendEmptyMessageDelayed(125, 3000L);
        }
    }

    public void initSoundPool(Context ctx) {
        this.poolMap = new HashMap<String, Integer>();
        this.sndPool = new SoundPool(1, 3, 100);
        this.sndPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                if (1 == sampleId) {
                    LiveActivity.this.isLoadmain = true;
                    LiveActivity.this.playMain();
                }
            }
        });
        this.poolMap.put("main", this.sndPool.load(ctx, R.raw.cloudwalk_main, 1));
        this.poolMap.put("mouth_open", this.sndPool.load(ctx, R.raw.cloudwalk_live_mouth, 1));
        this.poolMap.put("head_up", this.sndPool.load(ctx, R.raw.cloudwalk_live_top, 1));
        this.poolMap.put("head_down", this.sndPool.load(ctx, R.raw.cloudwalk_live_down, 1));
        this.poolMap.put("head_left", this.sndPool.load(ctx, R.raw.cloudwalk_live_left, 1));
        this.poolMap.put("head_right", this.sndPool.load(ctx, R.raw.cloudwalk_live_right, 1));
        this.poolMap.put("eye_blink", this.sndPool.load(ctx, R.raw.cloudwalk_live_eye, 1));
        this.poolMap.put("good", this.sndPool.load(ctx, R.raw.cloudwalk_good, 1));
    }

    public void releaseSoundPool() {
        if (this.sndPool != null) {
            this.sndPool.setOnLoadCompleteListener(null);
            this.sndPool.release();
            this.sndPool = null;
        }
    }

    private void initCallBack() {
        this.cloudwalkSDK.cwFaceInfoCallback((FaceInfoCallback)this);
        this.cloudwalkSDK.cwLivessInfoCallback((LivessCallBack)this);
    }

    private void initView() {
        DisplayMetrics dm = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        this.mViewPager = (CustomViewPager)this.findViewById(R.id.aircert_viewpager);
        this.mPreview = (CameraPreview)this.findViewById(R.id.aircert_preview);
        this.mPreview.setScreenOrientation(this.orientation);
        if (CameraUtil.isHasCamera(1)) {
            this.caremaId = 1;
            this.mPreview.setCaremaId(this.caremaId);
        } else {
            this.caremaId = 0;
            this.mPreview.setCaremaId(this.caremaId);
        }
        this.mIv_top = (ImageView)this.findViewById(R.id.aircert_top_iv);
        this.mRl_bottom = (RelativeLayout)this.findViewById(R.id.aircert_bottom_rl);
        this.mPb_step = (RoundProgressBarWidthNumber)this.findViewById(R.id.aircert_face_step_procress);
        int previewW = 0;
        int previewH = 0;
        int flTopW = 0;
        int flTopH = 0;
        int bottomW = 0;
        int bottomH = 0;
        if (this.getResources().getConfiguration().orientation == 1) {
            int navigationBarnH = 0;
            if (UIUtils.checkDeviceHasNavigationBar((Context)this)) {
                navigationBarnH = UIUtils.getNavigationBarHeight((Activity)this);
            }
            int height = dm.heightPixels - DisplayUtil.dip2px((Context)this, 45.0f) - Util.getStatusBarHeight((Context)this) - navigationBarnH;
            previewW = width;
            previewH = (int)((double)width * 1.0 * 640.0 / 480.0);
            flTopW = width;
            flTopH = width;
            bottomW = width;
            bottomH = height - width < DisplayUtil.dip2px((Context)this, 185.0f) ? DisplayUtil.dip2px((Context)this, 185.0f) : height - width;
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(previewW, previewH);
            this.mPreview.setLayoutParams((ViewGroup.LayoutParams)params);
            params = new RelativeLayout.LayoutParams(flTopW, flTopH);
            params.addRule(10);
            this.mIv_top.setLayoutParams((ViewGroup.LayoutParams)params);
            this.mIv_top.setImageResource(R.drawable.face_main_camera_mask);
            params = new RelativeLayout.LayoutParams(bottomW, bottomH);
            params.addRule(12);
            this.mRl_bottom.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    private void initStepViews() {
        this.getExecLive();
        LayoutInflater lf = LayoutInflater.from((Context)this);
        this.viewList = new ArrayList();
        View view = lf.inflate(R.layout.cloudwalk_layout_facedect_step_start, null);
        this.addView(view);
        int size = execLiveList.size();
        for (int i = 0; i < size; ++i) {
            view = lf.inflate(R.layout.cloudwalk_layout_facedect_step, null);
            this.addView(view);
        }
        this.viewPagerAdapter = new ViewPagerAdapter(this.viewList);
        this.mViewPager.setAdapter(this.viewPagerAdapter);
    }

    private void getExecLive() {
        if (1 < Bulider.execLiveCount && Bulider.execLiveCount <= 4) {
            boolean isTotalHasME;
            boolean isTotalHasLR = Bulider.totalLiveList.contains(1000) || Bulider.totalLiveList.contains(1001);
            boolean bl = isTotalHasME = Bulider.totalLiveList.contains(1005) || Bulider.totalLiveList.contains(1004);
            if (isTotalHasLR && isTotalHasME) {
                boolean isSubHasLRME = false;
                while (!isSubHasLRME) {
                    Collections.shuffle(Bulider.totalLiveList);
                    execLiveList = Bulider.totalLiveList.subList(0, Bulider.execLiveCount);
                    isSubHasLRME = !(!execLiveList.contains(1000) && !execLiveList.contains(1001) || !execLiveList.contains(1005) && !execLiveList.contains(1004));
                }
            } else if (isTotalHasLR) {
                boolean isSubHasLR = false;
                while (!isSubHasLR) {
                    Collections.shuffle(Bulider.totalLiveList);
                    execLiveList = Bulider.totalLiveList.subList(0, Bulider.execLiveCount);
                    isSubHasLR = execLiveList.contains(1000) || execLiveList.contains(1001);
                }
            } else if (isTotalHasME) {
                boolean isSubHasME = false;
                while (!isSubHasME) {
                    Collections.shuffle(Bulider.totalLiveList);
                    execLiveList = Bulider.totalLiveList.subList(0, Bulider.execLiveCount);
                    isSubHasME = execLiveList.contains(1005) || execLiveList.contains(1004);
                }
            } else {
                Collections.shuffle(Bulider.totalLiveList);
                execLiveList = Bulider.totalLiveList.subList(0, Bulider.execLiveCount);
            }
        } else {
            Collections.shuffle(Bulider.totalLiveList);
            execLiveList = Bulider.totalLiveList.subList(0, Bulider.execLiveCount);
        }
    }

    private void addView(View view) {
        this.viewList.add(view);
        ++this.totalStep;
    }

    private void getBestFace() {
        this.clipedBestFaceData = this.cloudwalkSDK.cwGetClipedBestFace();
    }

    private void clearBestFace() {
        this.cloudwalkSDK.cwClearBestFace();
    }

    private void doNextStep() {
        int nextDelayTime = 10;
        if (this.currentStep == 1) {
            nextDelayTime = 500;
            this.mMainHandler.sendEmptyMessageDelayed(124, nextDelayTime / 2);
        } else if (this.totalStep == this.currentStep) {
            this.isLivePass = true;
            this.currentStreamID = this.poolMap.get("good");
            if (this.sndPool != null) {
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
            }
            nextDelayTime = 500;
        } else {
            this.currentStreamID = this.poolMap.get("good");
            if (this.sndPool != null) {
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
            }
            nextDelayTime = 1000;
            this.mMainHandler.sendEmptyMessageDelayed(124, nextDelayTime / 2);
        }
        this.mMainHandler.sendEmptyMessageDelayed(101, nextDelayTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetLive() {
        this.mMainHandler.removeCallbacksAndMessages(null);
        this.isPlayMain = true;
        Bulider.bestFaceData = null;
        this.isLivePass = false;
        this.playMain();
        this.isSetResult = false;
        Class<LiveActivity> clazz = LiveActivity.class;
        synchronized (LiveActivity.class) {
            this.currentStep = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.mViewPager.setCurrentItem(this.currentStep);
            this.mPb_step.setVisibility(8);
            this.isStartDetectFace = false;
            if (this.initRet == 0) {
                this.cloudwalkSDK.setWorkType(CloudwalkSDK.DetectType.LIVE_DETECT);
                this.cloudwalkSDK.setTotalStep(execLiveList.size());
                this.cloudwalkSDK.setStageflag(1);
                this.mPreview.setPushFrame(true);
            } else {
                this.mMainHandler.obtainMessage(122, 720).sendToTarget();
            }
            return;
        }
    }

    protected void onResume() {
        super.onResume();
        this.isStop = false;
        this.requestCameraPermission();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mMainHandler.removeCallbacksAndMessages(null);
        if (this.cloudwalkSDK != null) {
            this.cloudwalkSDK.cwDestory();
        }
        this.releaseSoundPool();
        if (this.processDialog != null && this.processDialog.isShowing()) {
            this.processDialog.dismiss();
        }
    }

    protected void onStop() {
        super.onStop();
        this.sPermission.activeSPermission();
        this.mPreview.cwStopCamera();
        this.stopTimerRunnable();
        this.isStop = true;
        this.mMainHandler.removeCallbacksAndMessages(null);
        this.sndPool.stop(this.currentStreamID);
    }

    private void startLivessDetect(final int livessType) {
        switch (livessType) {
            case 1000: {
                this.currentStreamID = this.poolMap.get("head_left");
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
                this.mMainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LiveActivity.this.startTimerRunnable(Bulider.timerCount);
                        LiveActivity.this.cloudwalkSDK.cwStartLivess(livessType);
                    }
                }, 100L);
                break;
            }
            case 1001: {
                this.currentStreamID = this.poolMap.get("head_right");
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
                this.mMainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LiveActivity.this.startTimerRunnable(Bulider.timerCount);
                        LiveActivity.this.cloudwalkSDK.cwStartLivess(livessType);
                    }
                }, 100L);
                break;
            }
            case 1005: {
                this.currentStreamID = this.poolMap.get("mouth_open");
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
                this.mMainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LiveActivity.this.startTimerRunnable(Bulider.timerCount);
                        LiveActivity.this.cloudwalkSDK.cwStartLivess(livessType);
                    }
                }, 100L);
                break;
            }
            case 1004: {
                this.currentStreamID = this.poolMap.get("eye_blink");
                this.sndPool.play(this.currentStreamID, 1.0f, 1.0f, 0, 0, 1.0f);
                this.mMainHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LiveActivity.this.startTimerRunnable(Bulider.timerCount);
                        LiveActivity.this.cloudwalkSDK.cwStartLivess(livessType);
                    }
                }, 100L);
                break;
            }
        }
    }

    private void updateStepLayout(int livessType) {
        View view = this.viewList.get(this.currentStep);
        this.mTv_step = (TextView)view.findViewById(R.id.aircert_face_step_tv);
        this.mIv_step = (ImageView)view.findViewById(R.id.aircert_face_step_img);
        this.mPb_step.setVisibility(0);
        this.mPb_step.setMax(Bulider.timerCount);
        this.mPb_step.setProgress(Bulider.timerCount);
        switch (livessType) {
            case 1000: {
                this.mIv_step.setImageResource(R.drawable.cloudwalk_left_anim);
                this.mTv_step.setText(R.string.live_headleft);
                this.animationDrawable = (AnimationDrawable)this.mIv_step.getDrawable();
                this.animationDrawable.start();
                break;
            }
            case 1001: {
                this.mIv_step.setImageResource(R.drawable.cloudwalk_right_anim);
                this.mTv_step.setText(R.string.live_headright);
                this.animationDrawable = (AnimationDrawable)this.mIv_step.getDrawable();
                this.animationDrawable.start();
                break;
            }
            case 1005: {
                this.mIv_step.setImageResource(R.drawable.cloudwalk_mouth_anim);
                this.mTv_step.setText(R.string.live_mouth);
                this.animationDrawable = (AnimationDrawable)this.mIv_step.getDrawable();
                this.animationDrawable.start();
                break;
            }
            case 1004: {
                this.mIv_step.setImageResource(R.drawable.cloudwalk_eye_anim);
                this.mTv_step.setText(R.string.live_eye);
                this.animationDrawable = (AnimationDrawable)this.mIv_step.getDrawable();
                this.animationDrawable.start();
                break;
            }
        }
        this.mViewPager.setCurrentItem(this.currentStep, true);
    }

    public void detectFaceInfo(FaceInfo[] faceInfos, int faceNum) {
        if (faceNum > 0 && this.orientation != 2) {
            boolean isX = (double)faceInfos[0].x > 72.0;
            boolean isY = (double)faceInfos[0].y > 24.0;
            boolean isW = (double)(faceInfos[0].x + faceInfos[0].width) < 408.0;
            boolean bl = (double)(faceInfos[0].y + faceInfos[0].height) < 556.8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void detectLivess(int livessType, byte[] imageData) {
        this.cloudwalkSDK.cwStopLivess();
        this.stopTimerRunnable();
        if (this.isSetResult || this.isStop) {
            return;
        }
        switch (livessType) {
            case 604: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
            case 605: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
            case 601: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_5] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
            case 600: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_6] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
            case 602: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_7] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
            case 603: {
                Class<LiveActivity> clazz = LiveActivity.class;
                synchronized (LiveActivity.class) {
                    ++this.currentStep;
                    // ** MonitorExit[var3_8] (shouldn't be in output)
                    this.doNextStep();
                    return;
                }
            }
        }
    }

    public void detectInfo(final int info) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                long currentInfoTime = System.currentTimeMillis();
                if (currentInfoTime - LiveActivity.this.mLastPrepareInfoTime > 3000L) {
                    LiveActivity.this.mLastPrepareInfoTime = currentInfoTime;
                    if (LiveActivity.this.currentStep == 0 && LiveActivity.this.viewList != null && LiveActivity.this.viewList.get(0) != null) {
                        TextView tv_Info = (TextView)LiveActivity.this.viewList.get(0).findViewById(R.id.aircert_face_info_txt);
                        if (tv_Info != null) {
                            switch (info) {
                                case 2: {
                                    tv_Info.setText(R.string.cloudwalk_tip_too_far);
                                    break;
                                }
                                case 3: {
                                    tv_Info.setText(R.string.cloudwalk_tip_too_close);
                                    break;
                                }
                                case 4: {
                                    tv_Info.setText(R.string.cloudwalk_tip_not_frontal);
                                    break;
                                }
                                case 5: {
                                    tv_Info.setText(R.string.cloudwalk_tip_not_stable);
                                    break;
                                }
                                case 6: {
                                    tv_Info.setText(R.string.cloudwalk_tip_too_dark);
                                    break;
                                }
                                case 7: {
                                    tv_Info.setText(R.string.cloudwalk_tip_too_bright);
                                    break;
                                }
                                case 8: {
                                    tv_Info.setText(R.string.cloudwalk_tip_not_center);
                                    break;
                                }
                                case 20002: {
                                    tv_Info.setText(R.string.cloudwalk_tip_no_face);
                                    break;
                                }
                                case 20007: {
                                    tv_Info.setText(R.string.facedectfail_appid);
                                    break;
                                }
                            }
                        }
                        LiveActivity.this.mMainHandler.sendEmptyMessageDelayed(127, 1500L);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detectReady() {
        Class<LiveActivity> clazz = LiveActivity.class;
        synchronized (LiveActivity.class) {
            ++this.currentStep;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.cloudwalkSDK.cwStopLivess();
            this.mMainHandler.removeMessages(127);
            if (this.isStartDetectFace) {
                this.doNextStep();
            } else {
                this.mMainHandler.sendEmptyMessageDelayed(126, 400L);
            }
            return;
        }
    }

    public void detectFinished() {
    }

    public void OnActionNotStandard(int notStandardType) {
        if (this.currentStep != 0 && !this.isLivePass) {
            if (this.cloudwalkSDK != null) {
                this.cloudwalkSDK.cwStopLivess();
                this.cloudwalkSDK.cwResetLivenessTarget();
            }
            this.mMainHandler.obtainMessage(122, notStandardType).sendToTarget();
        }
    }

    private void setFaceErrorResult(int resultType) {
        this.mMainHandler.removeCallbacksAndMessages(null);
        if (this.isSetResult || this.isStop) {
            return;
        }
        this.isSetResult = true;
        Intent mIntent = new Intent((Context)this, LiveResultActivity.class);
        mIntent.putExtra("facedect_result_type", resultType);
        this.startActivity(mIntent);
        this.finish();
    }

    private void retryStartLive(int type) {
        this.cloudwalkSDK.cwStartLivess(type);
    }

    private void startTimerRunnable(int count) {
        this.faceTimerRunnable = new TimerRunnable(count, this);
        this.mMainHandler.postDelayed(this.faceTimerRunnable, 0L);
    }

    void stopTimerRunnable() {
        if (this.faceTimerRunnable != null) {
            this.faceTimerRunnable.setFlag(false);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        this.sPermission.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    private void requestCameraPermission() {
        this.sPermission.setMOUDLE(2).setmRequestCode(1).setPermissions(new String[]{"android.permission.CAMERA"}).setmOnPermissionListener(new OnPermissionListener(){

            public void onPermissionGranted() {
                LiveActivity.this.mPreview.cwStopCamera();
                LiveActivity.this.mPreview.cwStartCamera();
                LiveActivity.this.resetLive();
            }

            public void onPermissionDenied(String[] strings) {
                LiveActivity.this.initNoPermissionDialog();
            }

            public void onPermissionDeniedAlways(String[] strings) {
                LiveActivity.this.initNoPermissionDialog();
            }
        }).requestPermissions();
    }

    public void initNoPermissionDialog() {
        this.baseErrorDialog = new SinglePermissionDialog();
        this.baseErrorDialog.build(this.getApplicationContext(), 2);
    }

    static class TimerRunnable
    implements Runnable {
        private final WeakReference<LiveActivity> mActivity;
        int djsCount;
        boolean flag = true;

        public boolean isFlag() {
            return this.flag;
        }

        public void setFlag(boolean flag) {
            this.flag = flag;
        }

        public TimerRunnable(int djsCount, LiveActivity activity) {
            this.djsCount = djsCount;
            this.mActivity = new WeakReference<LiveActivity>(activity);
        }

        @Override
        public void run() {
            LiveActivity act = (LiveActivity)((Object)this.mActivity.get());
            if (!this.flag || act == null) {
                return;
            }
            act.mMainHandler.obtainMessage(106, this.djsCount).sendToTarget();
            --this.djsCount;
            if (this.djsCount >= 0) {
                act.mMainHandler.postDelayed(act.faceTimerRunnable, 1000L);
            } else {
                if (act.cloudwalkSDK != null) {
                    act.cloudwalkSDK.cwStopLivess();
                    act.cloudwalkSDK.cwResetLivenessTarget();
                }
                act.mMainHandler.obtainMessage(122, 703).sendToTarget();
            }
        }
    }

    public static class MainHandler
    extends Handler {
        private final WeakReference<LiveActivity> mActivity;

        public MainHandler(LiveActivity activity) {
            this.mActivity = new WeakReference<LiveActivity>(activity);
        }

        public void handleMessage(Message msg) {
            LiveActivity activity = (LiveActivity)((Object)this.mActivity.get());
            if (activity == null) {
                return;
            }
            switch (msg.what) {
                case 122: {
                    Integer resultCode = (Integer)msg.obj;
                    if (resultCode == 703 || resultCode == 700 || resultCode == 720) {
                        activity.setFaceErrorResult(resultCode);
                        activity.finish();
                        break;
                    }
                    activity.retryStartLive(execLiveList.get(activity.currentStep - 1));
                    break;
                }
                case 106: {
                    Integer progress = (Integer)msg.obj;
                    activity.mPb_step.setProgress(progress);
                    break;
                }
                case 124: {
                    activity.updateStepLayout(execLiveList.get(activity.currentStep - 1));
                    break;
                }
                case 125: {
                    activity.isStartDetectFace = true;
                    break;
                }
                case 101: {
                    if (activity.totalStep == activity.currentStep) {
                        activity.getBestFace();
                        if (activity.mPreview != null) {
                            activity.mPreview.setPushFrame(false);
                        }
                        if (activity.cloudwalkSDK != null) {
                            activity.cloudwalkSDK.cwResetLivenessTarget();
                        }
                        if (activity.clipedBestFaceData == null || activity.clipedBestFaceData.length == 0) {
                            activity.setFaceErrorResult(8);
                        } else {
                            LiveResult liveResult = new LiveResult();
                            liveResult.setImg(Base64Util.encode(activity.clipedBestFaceData));
                            BusProvider.post((Object)liveResult);
                        }
                        activity.finish();
                        break;
                    }
                    if (activity.currentStep == 1) {
                        activity.clearBestFace();
                    }
                    activity.startLivessDetect(execLiveList.get(activity.currentStep - 1));
                    break;
                }
                case 126: {
                    this.removeMessages(126);
                    if (activity.isStartDetectFace) {
                        activity.doNextStep();
                        break;
                    }
                    this.sendEmptyMessageDelayed(126, 400L);
                    break;
                }
                case 127: {
                    TextView tv_Info;
                    this.removeMessages(127);
                    if (activity.currentStep != 0 || activity.viewList == null || activity.viewList.get(0) == null || (tv_Info = (TextView)activity.viewList.get(0).findViewById(R.id.aircert_face_info_txt)) == null) break;
                    tv_Info.setText(R.string.cloudwalk_tip_not_center);
                    break;
                }
            }
            super.handleMessage(msg);
        }
    }

    private class ViewPagerAdapter
    extends PagerAdapter {
        private List<View> mListViews;

        public ViewPagerAdapter(List<View> mListViews) {
            this.mListViews = mListViews;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView(this.mListViews.get(position));
        }

        public Object instantiateItem(ViewGroup container, int position) {
            container.addView(this.mListViews.get(position), 0);
            return this.mListViews.get(position);
        }

        public int getCount() {
            return this.mListViews.size();
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }
    }
}

