/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject;

import android.content.Context;
import android.content.Intent;
import android.media.SoundPool;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import cn.cloudwalk.libproject.Bulider;
import cn.cloudwalk.libproject.R;
import com.aircert.BusProvider;
import com.aircert.CommonActivity.ToolBarActivity;
import com.aircert.event.YuncongAuth;
import com.aircert.util.ModuleToast;

public class LiveResultActivity
extends ToolBarActivity {
    public static final String FACEDECT_RESULT_TYPE = "facedect_result_type";
    int type;
    Button retry;
    TextView abnormal_prompt;
    SoundPool sndPool;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.abnormal_prompt);
        this.getIntentData();
        this.initView();
        this.changeUI(this.type);
        BusProvider.register((Object)((Object)this));
    }

    private void initView() {
        this.retry = (Button)this.findViewById(R.id.retry);
        this.retry.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LiveResultActivity.this.type == 720) {
                    BusProvider.post((Object)new YuncongAuth());
                    LiveResultActivity.this.finish();
                } else {
                    LiveResultActivity.this.startActivity(new Intent((Context)LiveResultActivity.this, Bulider.startCls));
                    LiveResultActivity.this.finish();
                }
            }
        });
        this.abnormal_prompt = (TextView)this.findViewById(R.id.abnormal_prompt);
    }

    private void getIntentData() {
        this.type = this.getIntent().getIntExtra(FACEDECT_RESULT_TYPE, 618);
    }

    private void changeUI(int type) {
        this.sndPool = new SoundPool(1, 3, 100);
        this.setTitleRes(R.string.facedect_fail);
        switch (type) {
            case 700: {
                this.abnormal_prompt.setText(R.string.cloudwalk_tip_no_face);
                break;
            }
            case 703: {
                this.abnormal_prompt.setText(R.string.facedectfail_timeout);
                break;
            }
            case 8: {
                this.abnormal_prompt.setText(R.string.bestface_fail);
                break;
            }
            case 720: {
                this.abnormal_prompt.setText(R.string.facedectfail_appid);
                break;
            }
            default: {
                ModuleToast.show((Context)this, (String)(this.getString(R.string.facedect_fail) + type));
            }
        }
        this.sndPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

            public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                int playId = LiveResultActivity.this.sndPool.play(sampleId, 1.0f, 1.0f, 0, 0, 1.0f);
            }
        });
    }

    protected void onStop() {
        this.sndPool.stop(1);
        super.onStop();
    }

    protected void onDestroy() {
        this.sndPool.release();
        super.onDestroy();
    }
}

