/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.progressHUD;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import cn.cloudwalk.libproject.R;
import cn.cloudwalk.libproject.progressHUD.AnnularView;
import cn.cloudwalk.libproject.progressHUD.BackgroundLayout;
import cn.cloudwalk.libproject.progressHUD.BarView;
import cn.cloudwalk.libproject.progressHUD.Determinate;
import cn.cloudwalk.libproject.progressHUD.Helper;
import cn.cloudwalk.libproject.progressHUD.Indeterminate;
import cn.cloudwalk.libproject.progressHUD.PieView;
import cn.cloudwalk.libproject.progressHUD.SpinView;

public class CwProgressHUD {
    private ProgressDialog mProgressDialog;
    private float mDimAmount;
    private int mWindowColor;
    private float mCornerRadius;
    private Context mContext;
    private int mAnimateSpeed;
    private int mMaxProgress;
    private boolean mIsAutoDismiss;

    public CwProgressHUD(Context context) {
        this.mContext = context;
        this.mProgressDialog = new ProgressDialog(context);
        this.mDimAmount = 0.0f;
        this.mWindowColor = context.getResources().getColor(R.color.kprogresshud_default_color);
        this.mAnimateSpeed = 1;
        this.mCornerRadius = 10.0f;
        this.mIsAutoDismiss = true;
        this.setStyle(Style.SPIN_INDETERMINATE);
    }

    public static CwProgressHUD create(Context context) {
        return new CwProgressHUD(context);
    }

    public static CwProgressHUD create(Context context, Style style2) {
        return new CwProgressHUD(context).setStyle(style2);
    }

    public CwProgressHUD setStyle(Style style2) {
        Object view = null;
        switch (style2) {
            case SPIN_INDETERMINATE: {
                view = new SpinView(this.mContext);
                break;
            }
            case PIE_DETERMINATE: {
                view = new PieView(this.mContext);
                break;
            }
            case ANNULAR_DETERMINATE: {
                view = new AnnularView(this.mContext);
                break;
            }
            case BAR_DETERMINATE: {
                view = new BarView(this.mContext);
            }
        }
        this.mProgressDialog.setView((View)view);
        return this;
    }

    public CwProgressHUD setDimAmount(float dimAmount) {
        if (dimAmount >= 0.0f && dimAmount <= 1.0f) {
            this.mDimAmount = dimAmount;
        }
        return this;
    }

    public CwProgressHUD setSize(int width, int height) {
        this.mProgressDialog.setSize(width, height);
        return this;
    }

    public CwProgressHUD setWindowColor(int color2) {
        this.mWindowColor = color2;
        return this;
    }

    public CwProgressHUD setCornerRadius(float radius) {
        this.mCornerRadius = radius;
        return this;
    }

    public CwProgressHUD setAnimationSpeed(int scale) {
        this.mAnimateSpeed = scale;
        return this;
    }

    public CwProgressHUD setLabel(String label) {
        this.mProgressDialog.setLabel(label);
        return this;
    }

    public CwProgressHUD setDetailsLabel(String detailsLabel) {
        this.mProgressDialog.setDetailsLabel(detailsLabel);
        return this;
    }

    public CwProgressHUD setMaxProgress(int maxProgress) {
        this.mMaxProgress = maxProgress;
        return this;
    }

    public void setProgress(int progress) {
        this.mProgressDialog.setProgress(progress);
    }

    public CwProgressHUD setCustomView(View view) {
        if (view == null) {
            throw new RuntimeException("Custom view must not be null!");
        }
        this.mProgressDialog.setView(view);
        return this;
    }

    public CwProgressHUD setCancellable(boolean isCancellable) {
        this.mProgressDialog.setCancelable(isCancellable);
        return this;
    }

    public CwProgressHUD setAutoDismiss(boolean isAutoDismiss) {
        this.mIsAutoDismiss = isAutoDismiss;
        return this;
    }

    public CwProgressHUD show() {
        if (!this.isShowing()) {
            this.mProgressDialog.show();
        }
        return this;
    }

    public boolean isShowing() {
        return this.mProgressDialog != null && this.mProgressDialog.isShowing();
    }

    public void dismiss() {
        if (this.mProgressDialog != null && this.mProgressDialog.isShowing()) {
            this.mProgressDialog.dismiss();
        }
    }

    private class ProgressDialog
    extends Dialog {
        private Determinate mDeterminateView;
        private Indeterminate mIndeterminateView;
        private View mView;
        private TextView mLabelText;
        private TextView mDetailsText;
        private String mLabel;
        private String mDetailsLabel;
        private FrameLayout mCustomViewContainer;
        private BackgroundLayout mBackgroundLayout;
        private int mWidth;
        private int mHeight;

        public ProgressDialog(Context context) {
            super(context);
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.requestWindowFeature(1);
            this.setContentView(R.layout.cloudwalk_progresshud_hud);
            Window window = this.getWindow();
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            window.addFlags(2);
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            layoutParams.dimAmount = CwProgressHUD.this.mDimAmount;
            layoutParams.gravity = 17;
            window.setAttributes(layoutParams);
            this.setCanceledOnTouchOutside(false);
            this.initViews();
        }

        private void initViews() {
            this.mBackgroundLayout = (BackgroundLayout)this.findViewById(R.id.background);
            this.mBackgroundLayout.setBaseColor(CwProgressHUD.this.mWindowColor);
            this.mBackgroundLayout.setCornerRadius(CwProgressHUD.this.mCornerRadius);
            if (this.mWidth != 0) {
                this.updateBackgroundSize();
            }
            this.mCustomViewContainer = (FrameLayout)this.findViewById(R.id.aircert_container);
            this.addViewToFrame(this.mView);
            if (this.mDeterminateView != null) {
                this.mDeterminateView.setMax(CwProgressHUD.this.mMaxProgress);
            }
            if (this.mIndeterminateView != null) {
                this.mIndeterminateView.setAnimationSpeed(CwProgressHUD.this.mAnimateSpeed);
            }
            this.mLabelText = (TextView)this.findViewById(R.id.aircert_label);
            if (this.mLabel != null) {
                this.mLabelText.setText((CharSequence)this.mLabel);
                this.mLabelText.setVisibility(0);
            } else {
                this.mLabelText.setVisibility(8);
            }
            this.mDetailsText = (TextView)this.findViewById(R.id.aircert_details_label);
            if (this.mDetailsLabel != null) {
                this.mDetailsText.setText((CharSequence)this.mDetailsLabel);
                this.mDetailsText.setVisibility(0);
            } else {
                this.mDetailsText.setVisibility(8);
            }
        }

        private void addViewToFrame(View view) {
            if (view == null) {
                return;
            }
            int wrapParam = -2;
            ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(wrapParam, wrapParam);
            this.mCustomViewContainer.addView(view, params);
        }

        private void updateBackgroundSize() {
            ViewGroup.LayoutParams params = this.mBackgroundLayout.getLayoutParams();
            params.width = Helper.dpToPixel(this.mWidth, this.getContext());
            params.height = Helper.dpToPixel(this.mHeight, this.getContext());
            this.mBackgroundLayout.setLayoutParams(params);
        }

        public void setProgress(int progress) {
            if (this.mDeterminateView != null) {
                this.mDeterminateView.setProgress(progress);
                if (CwProgressHUD.this.mIsAutoDismiss && progress >= CwProgressHUD.this.mMaxProgress) {
                    this.dismiss();
                }
            }
        }

        public void setView(View view) {
            if (view != null) {
                if (view instanceof Determinate) {
                    this.mDeterminateView = (Determinate)view;
                }
                if (view instanceof Indeterminate) {
                    this.mIndeterminateView = (Indeterminate)view;
                }
                this.mView = view;
                if (this.isShowing()) {
                    this.mCustomViewContainer.removeAllViews();
                    this.addViewToFrame(view);
                }
            }
        }

        public void setLabel(String label) {
            this.mLabel = label;
            if (this.mLabelText != null) {
                if (label != null) {
                    this.mLabelText.setText((CharSequence)label);
                    this.mLabelText.setVisibility(0);
                } else {
                    this.mLabelText.setVisibility(8);
                }
            }
        }

        public void setDetailsLabel(String detailsLabel) {
            this.mDetailsLabel = detailsLabel;
            if (this.mDetailsText != null) {
                if (detailsLabel != null) {
                    this.mDetailsText.setText((CharSequence)detailsLabel);
                    this.mDetailsText.setVisibility(0);
                } else {
                    this.mDetailsText.setVisibility(8);
                }
            }
        }

        public void setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
            if (this.mBackgroundLayout != null) {
                this.updateBackgroundSize();
            }
        }
    }

    public static enum Style {
        SPIN_INDETERMINATE,
        PIE_DETERMINATE,
        ANNULAR_DETERMINATE,
        BAR_DETERMINATE;

    }
}

