/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;

public class OcrMaskView
extends View {
    private static final int FOCUSING = 1;
    private static final int FOCUSED = 2;
    private static final int NOFOCUS = 0;
    Context mContext;
    int mClrCircleBigOuter = Color.argb((int)136, (int)0, (int)0, (int)0);
    int mClrCircleBigInter = Color.argb((int)136, (int)153, (int)153, (int)153);
    int mClrCircleSmall = Color.argb((int)136, (int)221, (int)221, (int)221);
    private Paint mLinePaint;
    private Paint mRectPoint;
    private Paint mBankPaint;
    private Paint mPaint;
    private Paint mPaintText;
    int width;
    int height;
    float focusX;
    float focusY;
    int focusType;
    int ocrRectH;
    int ocrRectW;
    int ocrRectLeft;
    int ocrRectTop;
    volatile int left = 0;
    volatile int top = 0;
    volatile int right = 0;
    volatile int bottom = 0;
    volatile boolean isDrawProgress = false;
    int flag = -1;
    final int TIME_OUT_DRAW_LINE = 2000;
    volatile long drawLineTime = 0L;
    Bitmap mBitmapFocus;
    Bitmap mBitmapFocused;
    Bitmap mBitmapScan = null;
    int scanLineTop = 0;
    final int SCAN_VELOCITY = 8;
    int mDetAngle = 0;
    private boolean mAttached;
    String mBankCardTitle = "";
    private final Runnable mDrawLine = new Runnable(){

        @Override
        public void run() {
            OcrMaskView.this.left = 0;
            OcrMaskView.this.top = 0;
            OcrMaskView.this.right = 0;
            OcrMaskView.this.bottom = 0;
            OcrMaskView.this.postInvalidate();
            OcrMaskView.this.getHandler().postDelayed(OcrMaskView.this.mDrawLine, 2000L);
        }
    };

    public OcrMaskView(Context context) {
        this(context, null);
    }

    public OcrMaskView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initPaint();
    }

    public void desotry() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            this.mDrawLine.run();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.getHandler().removeCallbacks(this.mDrawLine);
            this.mAttached = false;
        }
    }

    private void drawScanAnimation(Canvas canvas, Bitmap bitmap, Rect rect) {
        if (this.scanLineTop <= 0 || this.scanLineTop >= rect.bottom) {
            this.scanLineTop = rect.top;
        }
        this.scanLineTop += 8;
        if (this.scanLineTop + 2 < rect.bottom) {
            Rect scanRect = new Rect(rect.left, this.scanLineTop, rect.right, this.scanLineTop + 2);
            canvas.drawBitmap(bitmap, null, scanRect, null);
        }
    }

    public void setFocus(float x, float y) {
        this.focusX = x;
        this.focusY = y;
        this.focusType = 1;
        this.invalidate();
    }

    public void setLine(int left, int top, int right, int bottom) {
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.drawLineTime = System.currentTimeMillis();
        if (0 == left || 0 == top || 0 == right || 0 == bottom) {
            this.isDrawProgress = false;
        }
        this.invalidate();
    }

    public void setDrawProgress() {
        this.isDrawProgress = true;
        this.invalidate();
    }

    public void setFocused() {
        this.focusType = 2;
        this.invalidate();
    }

    public void setOcr(int width, int height, int ocrRectW, int ocrRectH, int flag, Bitmap bitmapScan, Bitmap bitmapFocus, Bitmap bitmapFocused) {
        this.flag = flag;
        this.width = width;
        this.height = height;
        this.ocrRectW = ocrRectW;
        this.ocrRectH = ocrRectH;
        this.mBitmapScan = bitmapScan;
        this.mBitmapFocus = bitmapFocus;
        this.mBitmapFocused = bitmapFocused;
        this.ocrRectLeft = (width - ocrRectW) / 2;
        this.ocrRectTop = (height - ocrRectH) / 2;
        this.postInvalidate();
    }

    public void clearFocus() {
        this.focusType = 0;
        this.invalidate();
    }

    private void initPaint() {
        this.mLinePaint = new Paint(1);
        this.mLinePaint.setTextSize((float)OcrMaskView.dip2px(this.mContext, 18.0f));
        this.mLinePaint.setColor(-1);
        this.mLinePaint.setTextAlign(Paint.Align.CENTER);
        this.mRectPoint = new Paint(1);
        this.mRectPoint.setColor(-1437445550);
        this.mBankPaint = new Paint(1);
        this.mBankPaint.setColor(-16711936);
        this.mPaint = new Paint();
        this.mPaint.setFlags(1);
        this.mPaintText = new TextPaint();
        this.mPaintText.setFlags(1);
        this.mPaintText.setTextAlign(Paint.Align.CENTER);
        this.mPaintText.setColor(-1);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (2 == this.flag) {
            this.mBankCardTitle = this.getResources().getConfiguration().orientation == 2 ? "\u6a2a\u7248\u94f6\u884c\u5361\u68c0\u6d4b" : "\u7ad6\u7248\u94f6\u884c\u5361\u68c0\u6d4b";
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    protected void onDraw(Canvas canvas) {
        this.drawMask(canvas);
        this.drawAct(canvas, this.mBankPaint);
        this.drawCardLine(canvas);
        if (null != this.mBitmapScan) {
            this.drawScanAnimation(canvas, this.mBitmapScan, new Rect(this.ocrRectLeft, this.ocrRectTop, this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + this.ocrRectH));
        }
        if (null != this.mBitmapFocus && null != this.mBitmapFocused) {
            if (this.focusType == 1) {
                canvas.drawBitmap(this.mBitmapFocus, this.focusX - (float)(this.mBitmapFocus.getWidth() / 2), this.focusY - (float)(this.mBitmapFocus.getHeight() / 2), null);
            } else if (this.focusType == 2) {
                canvas.drawBitmap(this.mBitmapFocused, this.focusX - (float)(this.mBitmapFocused.getWidth() / 2), this.focusY - (float)(this.mBitmapFocused.getHeight() / 2), null);
            }
        }
        if (2 == this.flag) {
            if (!TextUtils.isEmpty((CharSequence)this.mBankCardTitle)) {
                canvas.drawText(this.mBankCardTitle, (float)(this.width / 2), (float)(this.ocrRectTop - OcrMaskView.dip2px(this.mContext, 10.0f)), this.mLinePaint);
            }
            canvas.drawText("\u8bf7\u5c06\u94f6\u884c\u5361\u4e0e\u6a21\u677f\u6846\u5bf9\u9f50", (float)(this.width / 2), (float)(this.ocrRectTop + this.ocrRectH + OcrMaskView.dip2px(this.mContext, 20.0f)), this.mLinePaint);
        } else if (1 == this.flag) {
            canvas.drawText("\u8bf7\u5c06\u8eab\u4efd\u8bc1\u6b63\u9762\u4e0e\u6a21\u677f\u6846\u5bf9\u9f50", (float)(this.width / 2), (float)(this.ocrRectTop + this.ocrRectH + OcrMaskView.dip2px(this.mContext, 20.0f)), this.mLinePaint);
        } else {
            canvas.drawText("\u8bf7\u5c06\u8eab\u4efd\u8bc1\u53cd\u9762\u4e0e\u6a21\u677f\u6846\u5bf9\u9f50", (float)(this.width / 2), (float)(this.ocrRectTop + this.ocrRectH + OcrMaskView.dip2px(this.mContext, 20.0f)), this.mLinePaint);
        }
        if (this.isDrawProgress) {
            this.drawProgress(canvas);
        }
    }

    private void drawCardLine(Canvas canvas) {
        if (this.left == 1) {
            Rect leftLine = new Rect(this.ocrRectLeft, this.ocrRectTop, this.ocrRectLeft + OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop + this.ocrRectH);
            canvas.drawRect(leftLine, this.mBankPaint);
        }
        if (this.right == 1) {
            Rect rightLine = new Rect(this.ocrRectLeft + this.ocrRectW - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop, this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + this.ocrRectH);
            canvas.drawRect(rightLine, this.mBankPaint);
        }
        if (this.top == 1) {
            Rect topLine = new Rect(this.ocrRectLeft, this.ocrRectTop, this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + OcrMaskView.dip2px(this.mContext, 4.0f));
            canvas.drawRect(topLine, this.mBankPaint);
        }
        if (this.bottom == 1) {
            Rect bottomLine = new Rect(this.ocrRectLeft, this.ocrRectTop + this.ocrRectH - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + this.ocrRectH);
            canvas.drawRect(bottomLine, this.mBankPaint);
        }
        this.invalidate();
    }

    private void drawAct(Canvas canvas, Paint mPaint) {
        Rect lTHorizontal = new Rect(this.ocrRectLeft, this.ocrRectTop, this.ocrRectLeft + OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectTop + OcrMaskView.dip2px(this.mContext, 4.0f));
        canvas.drawRect(lTHorizontal, mPaint);
        Rect lTVertical = new Rect(this.ocrRectLeft, this.ocrRectTop, this.ocrRectLeft + OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop + OcrMaskView.dip2px(this.mContext, 30.0f));
        canvas.drawRect(lTVertical, mPaint);
        Rect lBHorizontal = new Rect(this.ocrRectLeft, this.ocrRectTop + this.ocrRectH - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectLeft + OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(lBHorizontal, mPaint);
        Rect lBVertical = new Rect(this.ocrRectLeft, this.ocrRectTop + this.ocrRectH - OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectLeft + OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(lBVertical, mPaint);
        Rect rTHorizontal = new Rect(this.ocrRectLeft + this.ocrRectW - OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectTop, this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + OcrMaskView.dip2px(this.mContext, 4.0f));
        canvas.drawRect(rTHorizontal, mPaint);
        Rect rTVertical = new Rect(this.ocrRectLeft + this.ocrRectW - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop, this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + OcrMaskView.dip2px(this.mContext, 30.0f));
        canvas.drawRect(rTVertical, mPaint);
        Rect rBHorizontal = new Rect(this.ocrRectLeft + this.ocrRectW - OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectTop + this.ocrRectH - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(rBHorizontal, mPaint);
        Rect rBVertical = new Rect(this.ocrRectLeft + this.ocrRectW - OcrMaskView.dip2px(this.mContext, 4.0f), this.ocrRectTop + this.ocrRectH - OcrMaskView.dip2px(this.mContext, 30.0f), this.ocrRectLeft + this.ocrRectW, this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(rBVertical, mPaint);
    }

    private void drawMask(Canvas canvas) {
        Rect frameTop = new Rect(0, 0, this.width, this.ocrRectTop);
        canvas.drawRect(frameTop, this.mRectPoint);
        Rect frameLeft = new Rect(0, this.ocrRectTop, this.ocrRectLeft, this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(frameLeft, this.mRectPoint);
        Rect frameRight = new Rect(this.ocrRectLeft + this.ocrRectW, this.ocrRectTop, this.width, this.ocrRectTop + this.ocrRectH);
        canvas.drawRect(frameRight, this.mRectPoint);
        Rect frameBottom = new Rect(0, this.ocrRectTop + this.ocrRectH, this.width, this.height);
        canvas.drawRect(frameBottom, this.mRectPoint);
    }

    public static int dip2px(Context context, float dp) {
        float scale = context.getResources().getDisplayMetrics().density;
        int px = (int)(dp * scale + 0.5f);
        return px;
    }

    public static float px2dip(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().density;
        float dp = ((float)px - 0.5f) / scale;
        return dp;
    }

    public float AngleToRadian(float angle) {
        return (float)Math.PI / 180 * angle;
    }

    public void drawProgress(Canvas canvas) {
        Rect rect1 = new Rect(0, 0, this.width, this.height);
        Rect rect2 = new Rect(this.ocrRectLeft + this.ocrRectW / 8, this.ocrRectTop + this.ocrRectH / 8, this.ocrRectLeft + this.ocrRectW / 8 + this.ocrRectW * 6 / 8, this.ocrRectTop + this.ocrRectH / 8 + this.ocrRectH * 6 / 8);
        int padding = OcrMaskView.dip2px(this.mContext, 10.0f);
        float hwRounds = (float)rect2.height() * 0.85f;
        PointF ptCenter = new PointF((float)(rect1.width() / 2), (float)(rect1.height() / 2));
        float rOuter = (Math.min((float)Math.min(rect2.height(), rect2.width()), hwRounds) - (float)padding) / 10.0f;
        float rInter = rOuter * 4.0f;
        this.mPaint.setColor(this.mClrCircleBigOuter);
        canvas.drawCircle(ptCenter.x, ptCenter.y, rInter, this.mPaint);
        this.mPaint.setColor(this.mClrCircleBigInter);
        canvas.drawCircle(ptCenter.x, ptCenter.y, rInter - (float)OcrMaskView.dip2px(this.mContext, 2.0f), this.mPaint);
        this.mDetAngle += 10;
        int count = 3;
        int dist = 360 / count;
        for (int i = 0; i < count; ++i) {
            float angle = (i * dist - this.mDetAngle) % 360;
            float radian = this.AngleToRadian(angle);
            float x = ptCenter.x + (float)Math.sin(radian) * rInter;
            float y = ptCenter.y + (float)Math.cos(radian) * rInter;
            this.mPaint.setColor(this.mClrCircleSmall);
            canvas.drawCircle(x, y, rOuter, this.mPaint);
        }
        this.mPaintText.setTextSize(OcrMaskView.px2dip(this.mContext, rect2.height() / 5));
        canvas.drawText("\u6b63\u5728\u8bc6\u522b\u4e2d...", ptCenter.x, ptCenter.y, this.mPaintText);
    }
}

