/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.camera;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.media.ToneGenerator;
import android.view.Display;
import android.view.WindowManager;
import cn.cloudwalk.libproject.callback.OnCaptureCallback;
import cn.cloudwalk.libproject.util.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final String TAG = "CameraConfigurationManager";
    private final Context mContext;
    private Point mScreenResolution;
    private Point cameraResolution;
    Camera.Size pictureSize;
    private ToneGenerator tone;

    public CameraConfigurationManager(Context context) {
        this.mContext = context;
    }

    public void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        this.mScreenResolution = new Point(display.getWidth(), display.getHeight());
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.mScreenResolution.x;
        screenResolutionForCamera.y = this.mScreenResolution.y;
        if (this.mScreenResolution.x < this.mScreenResolution.y) {
            screenResolutionForCamera.x = this.mScreenResolution.y;
            screenResolutionForCamera.y = this.mScreenResolution.x;
        }
        this.cameraResolution = CameraConfigurationManager.getCameraResolution(parameters, screenResolutionForCamera);
    }

    public void setDesiredCameraParameters(Camera camera, int caremaId, boolean isModeAuto) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPreviewFormat(17);
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        this.setZoom(parameters);
        if (!isModeAuto) {
            String md_old = parameters.getFocusMode();
            List focusModes = parameters.getSupportedFocusModes();
            for (String it : focusModes) {
                LogUtils.LOGE("mode", "" + it);
                if (!it.equals("infinity")) continue;
                parameters.setFocusMode(it);
                LogUtils.LOGE("mode", "set = " + it);
            }
            String string2 = parameters.getFocusMode();
        }
        camera.setDisplayOrientation(this.getDisplayOrientation(caremaId));
        if (this.pictureSize == null) {
            WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
            Display display = manager.getDefaultDisplay();
            List pictureSizes = parameters.getSupportedPictureSizes();
            this.setPicutreSize(pictureSizes, display.getWidth(), display.getHeight());
        }
        try {
            parameters.setPictureSize(this.pictureSize.width, this.pictureSize.height);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        camera.setParameters(parameters);
    }

    public int setCameraParametersForPreviewCallBack(Camera camera, int caremaId, int previewW, int previewH) {
        Camera.Parameters parameters = camera.getParameters();
        String old = parameters.getFocusMode();
        List focusModes = parameters.getSupportedFocusModes();
        if (focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-picture");
        }
        List range = parameters.getSupportedPreviewFpsRange();
        for (int j = 0; j < range.size(); ++j) {
            int[] r = (int[])range.get(j);
            for (int k = 0; k < r.length; ++k) {
            }
        }
        Camera.Size localSize = this.getOptimalPreviewSize(parameters.getSupportedPreviewSizes(), previewW, previewH);
        if (localSize != null) {
            parameters.setPreviewSize(localSize.width, localSize.height);
        } else {
            LogUtils.LOGE(TAG, "\u8bbe\u7f6e\u9884\u89c8\u5931\u8d25");
        }
        parameters.setPreviewFormat(17);
        this.setZoom(parameters);
        int degree = this.getDisplayOrientation(caremaId);
        camera.setDisplayOrientation(degree);
        camera.setParameters(parameters);
        return degree;
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> localList, int w, int h) {
        Camera.Size optimalSize = null;
        try {
            ArrayList<Camera.Size> localArrayList = new ArrayList<Camera.Size>();
            for (Camera.Size localSize : localList) {
                if (localSize.width <= localSize.height) continue;
                localArrayList.add(localSize);
            }
            Collections.sort(localArrayList, new PreviewComparator(w, h));
            optimalSize = (Camera.Size)localArrayList.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return optimalSize;
    }

    public void openFlashlight(Camera camera) {
        this.doSetTorch(camera, true);
    }

    public void closeFlashlight(Camera camera) {
        this.doSetTorch(camera, false);
    }

    private void doSetTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        String flashMode = newSetting ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "torch", "on") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "off");
        if (flashMode != null) {
            parameters.setFlashMode(flashMode);
        }
        camera.setParameters(parameters);
    }

    private static String findSettableValue(Collection<String> supportedValues, String ... desiredValues) {
        String result = null;
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                result = desiredValue;
                break;
            }
        }
        return result;
    }

    public int getDisplayOrientation(int caremaId) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)caremaId, (Camera.CameraInfo)info);
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int rotation = display.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private static Point getCameraResolution(Camera.Parameters parameters, Point screenResolution) {
        String previewSizeValueString = parameters.get("preview-size-values");
        if (previewSizeValueString == null) {
            previewSizeValueString = parameters.get("preview-size-value");
        }
        Point cameraResolution = null;
        if (previewSizeValueString != null) {
            cameraResolution = CameraConfigurationManager.findBestPreviewSizeValue(previewSizeValueString, screenResolution);
        }
        if (cameraResolution == null) {
            cameraResolution = new Point(screenResolution.x >> 3 << 3, screenResolution.y >> 3 << 3);
        }
        return cameraResolution;
    }

    private static Point findBestPreviewSizeValue(CharSequence previewSizeValueString, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        for (String previewSize : COMMA_PATTERN.split(previewSizeValueString)) {
            int newY;
            int newX;
            int dimPosition = (previewSize = previewSize.trim()).indexOf(120);
            if (dimPosition < 0) continue;
            try {
                newX = Integer.parseInt(previewSize.substring(0, dimPosition));
                newY = Integer.parseInt(previewSize.substring(dimPosition + 1));
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
            if (newDiff == 0) {
                bestX = newX;
                bestY = newY;
                break;
            }
            if (newDiff >= diff) continue;
            bestX = newX;
            bestY = newY;
            diff = newDiff;
        }
        if (bestX > 0 && bestY > 0) {
            return new Point(bestX, bestY);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringValues, int tenDesiredZoom) {
        int tenBestValue = 0;
        for (String stringValue : COMMA_PATTERN.split(stringValues)) {
            double value;
            stringValue = stringValue.trim();
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException nfe) {
                return tenDesiredZoom;
            }
            int tenValue = (int)(10.0 * value);
            if (!(Math.abs((double)tenDesiredZoom - value) < (double)Math.abs(tenDesiredZoom - tenBestValue))) continue;
            tenBestValue = tenValue;
        }
        return tenBestValue;
    }

    private void setZoom(Camera.Parameters parameters) {
        String motZoomStepString;
        String motZoomValuesString;
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 27;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        if ((motZoomValuesString = parameters.get("mot-zoom-values")) != null) {
            tenDesiredZoom = CameraConfigurationManager.findBestMotZoomValue(motZoomValuesString, tenDesiredZoom);
        }
        if ((motZoomStepString = parameters.get("mot-zoom-step")) != null) {
            try {
                double motZoomStep = Double.parseDouble(motZoomStepString.trim());
                int tenZoomStep = (int)(10.0 * motZoomStep);
                if (tenZoomStep > 1) {
                    tenDesiredZoom -= tenDesiredZoom % tenZoomStep;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxZoomString != null || motZoomValuesString != null) {
            parameters.set("zoom", String.valueOf((double)tenDesiredZoom / 10.0));
        }
        if (takingPictureZoomMaxString != null) {
            parameters.set("taking-picture-zoom", tenDesiredZoom);
        }
    }

    private void setPicutreSize(List<Camera.Size> list, int width, int height) {
        int approach = Integer.MAX_VALUE;
        for (Camera.Size size : list) {
            int temp = Math.abs(size.width - width + size.height - height);
            if (approach <= temp) continue;
            approach = temp;
            this.pictureSize = size;
        }
    }

    public void tackPicture(Camera camera, final OnCaptureCallback callback) throws Exception {
        camera.cancelAutoFocus();
        camera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean flag, Camera camera) {
                camera.takePicture(new Camera.ShutterCallback(){

                    public void onShutter() {
                        if (CameraConfigurationManager.this.tone == null) {
                            CameraConfigurationManager.this.tone = new ToneGenerator(3, 100);
                        }
                        CameraConfigurationManager.this.tone.startTone(24);
                    }
                }, null, new Camera.PictureCallback(){

                    public void onPictureTaken(byte[] data, Camera camera) {
                        Camera.Size size = camera.getParameters().getPreviewSize();
                        int width = size.width;
                        int height = size.height;
                        callback.onCapture(data, width, height);
                    }
                });
            }
        });
    }

    class PreviewComparator
    implements Comparator<Camera.Size> {
        int w;
        int h;

        public PreviewComparator(int w, int h) {
            this.w = w;
            this.h = h;
        }

        @Override
        public int compare(Camera.Size paramSize1, Camera.Size paramSize2) {
            return Math.abs(paramSize1.width * paramSize1.height - this.w * this.h) - Math.abs(paramSize2.width * paramSize2.height - this.w * this.h);
        }
    }
}

