/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.camera;

import android.content.Context;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.cloudwalk.libproject.camera.CameraConfigurationManager;
import cn.cloudwalk.libproject.camera.Delegate;
import cn.cloudwalk.libproject.util.LogUtils;

public class OneShotCameraPreview
extends SurfaceView
implements SurfaceHolder.Callback,
Camera.PreviewCallback {
    private static final String TAG = LogUtils.makeLogTag("OneShotCameraPreview");
    private Camera mCamera;
    int caremaId = 0;
    private boolean mPreviewing = true;
    private boolean mAutoFocus = true;
    private boolean mSurfaceCreated = false;
    private CameraConfigurationManager mCameraConfigurationManager;
    private boolean mIsAutoMode = true;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            if (OneShotCameraPreview.this.mCamera != null && OneShotCameraPreview.this.mPreviewing && OneShotCameraPreview.this.mAutoFocus && OneShotCameraPreview.this.mSurfaceCreated) {
                LogUtils.LOGE(TAG, "doAutoFocus");
                OneShotCameraPreview.this.mCamera.autoFocus(OneShotCameraPreview.this.autoFocusCB);
            }
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            OneShotCameraPreview.this.openOneShotPreview();
            OneShotCameraPreview.this.postDelayed(OneShotCameraPreview.this.doAutoFocus, 2000L);
        }
    };
    Delegate mDelegate;

    public OneShotCameraPreview(Context context) {
        super(context);
    }

    public OneShotCameraPreview(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public OneShotCameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mCameraConfigurationManager = new CameraConfigurationManager(this.getContext());
            this.mCameraConfigurationManager.initFromCameraParameters(this.mCamera);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = true;
                this.mCamera.setPreviewDisplay(this.getHolder());
                this.mCameraConfigurationManager.setDesiredCameraParameters(this.mCamera, this.caremaId, this.mIsAutoMode);
                this.mCamera.startPreview();
                if (this.mAutoFocus) {
                    this.mCamera.autoFocus(this.autoFocusCB);
                }
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.removeCallbacks(this.doAutoFocus);
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.closeOneShotPreview();
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                LogUtils.LOGE(TAG, e.toString());
            }
        }
    }

    public void openFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.openFlashlight(this.mCamera);
        }
    }

    public void closeFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.closeFlashlight(this.mCamera);
        }
    }

    private boolean flashLightAvaliable() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated && this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public void openOneShotPreview() {
        if (this.mCamera != null) {
            this.mCamera.setOneShotPreviewCallback((Camera.PreviewCallback)this);
        }
    }

    public void closeOneShotPreview() {
        if (this.mCamera != null) {
            this.mCamera.setOneShotPreviewCallback(null);
        }
    }

    public Camera.Size getPreviewSize() {
        Camera.Parameters parameters = this.mCamera.getParameters();
        return parameters.getPreviewSize();
    }

    public void setDelegate(Delegate mDelegate) {
        this.mDelegate = mDelegate;
    }

    public void cwStartCamera() {
        block3: {
            if (this.mCamera != null) {
                return;
            }
            try {
                this.mCamera = Camera.open((int)this.caremaId);
            }
            catch (Exception e) {
                if (this.mDelegate == null) break block3;
                this.mDelegate.onOpenCameraError();
            }
        }
        this.setCamera(this.mCamera);
    }

    public void cwStopCamera() {
        if (this.mCamera != null) {
            this.stopCameraPreview();
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
    }
}

