/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.progressHUD;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import cn.cloudwalk.libproject.progressHUD.Determinate;
import cn.cloudwalk.libproject.progressHUD.Helper;

class BarView
extends View
implements Determinate {
    private Paint mOuterPaint;
    private Paint mInnerPaint;
    private RectF mBound;
    private RectF mInBound;
    private int mMax = 100;
    private int mProgress = 0;
    private float mBoundGap;

    public BarView(Context context) {
        super(context);
        this.init();
    }

    public BarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mOuterPaint = new Paint(1);
        this.mOuterPaint.setStyle(Paint.Style.STROKE);
        this.mOuterPaint.setStrokeWidth((float)Helper.dpToPixel(2.0f, this.getContext()));
        this.mOuterPaint.setColor(-1);
        this.mInnerPaint = new Paint(1);
        this.mInnerPaint.setStyle(Paint.Style.FILL);
        this.mInnerPaint.setColor(-1);
        this.mBoundGap = Helper.dpToPixel(5.0f, this.getContext());
        this.mInBound = new RectF(this.mBoundGap, this.mBoundGap, ((float)this.getWidth() - this.mBoundGap) * (float)this.mProgress / (float)this.mMax, (float)this.getHeight() - this.mBoundGap);
        this.mBound = new RectF();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int padding = Helper.dpToPixel(2.0f, this.getContext());
        this.mBound.set((float)padding, (float)padding, (float)(w - padding), (float)(h - padding));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRoundRect(this.mBound, this.mBound.height() / 2.0f, this.mBound.height() / 2.0f, this.mOuterPaint);
        canvas.drawRoundRect(this.mInBound, this.mInBound.height() / 2.0f, this.mInBound.height() / 2.0f, this.mInnerPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthDimension = Helper.dpToPixel(100.0f, this.getContext());
        int heightDimension = Helper.dpToPixel(20.0f, this.getContext());
        this.setMeasuredDimension(widthDimension, heightDimension);
    }

    @Override
    public void setMax(int max) {
        this.mMax = max;
    }

    @Override
    public void setProgress(int progress) {
        this.mProgress = progress;
        this.mInBound.set(this.mBoundGap, this.mBoundGap, ((float)this.getWidth() - this.mBoundGap) * (float)this.mProgress / (float)this.mMax, (float)this.getHeight() - this.mBoundGap);
        this.invalidate();
    }
}

