/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.progressHUD;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import cn.cloudwalk.libproject.progressHUD.Determinate;
import cn.cloudwalk.libproject.progressHUD.Helper;

class PieView
extends View
implements Determinate {
    private Paint mWhitePaint;
    private Paint mGreyPaint;
    private RectF mBound;
    private int mMax = 100;
    private int mProgress = 0;

    public PieView(Context context) {
        super(context);
        this.init();
    }

    public PieView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PieView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mWhitePaint = new Paint(1);
        this.mWhitePaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mWhitePaint.setStrokeWidth((float)Helper.dpToPixel(0.1f, this.getContext()));
        this.mWhitePaint.setColor(-1);
        this.mGreyPaint = new Paint(1);
        this.mGreyPaint.setStyle(Paint.Style.STROKE);
        this.mGreyPaint.setStrokeWidth((float)Helper.dpToPixel(2.0f, this.getContext()));
        this.mGreyPaint.setColor(-1);
        this.mBound = new RectF();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int padding = Helper.dpToPixel(4.0f, this.getContext());
        this.mBound.set((float)padding, (float)padding, (float)(w - padding), (float)(h - padding));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float mAngle = (float)this.mProgress * 360.0f / (float)this.mMax;
        canvas.drawArc(this.mBound, 270.0f, mAngle, true, this.mWhitePaint);
        int padding = Helper.dpToPixel(4.0f, this.getContext());
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2 - padding), this.mGreyPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int dimension = Helper.dpToPixel(40.0f, this.getContext());
        this.setMeasuredDimension(dimension, dimension);
    }

    @Override
    public void setMax(int max) {
        this.mMax = max;
    }

    @Override
    public void setProgress(int progress) {
        this.mProgress = progress;
        this.invalidate();
    }
}

