/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.hardware.Camera;
import cn.cloudwalk.libproject.util.UIUtils;

public class CameraUtil {
    public static boolean isHasCamera(int facing) {
        if (UIUtils.getSdkVersion() < 9) {
            return false;
        }
        int cameraCount = Camera.getNumberOfCameras();
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < cameraCount; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (facing != info.facing) continue;
            return true;
        }
        return false;
    }

    public static void setCameraDisplayOrientation(int rotation, int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
    }
}

