/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.os.Environment;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class FileUtil {
    public static final String TAG = "FileUtil";
    public static final File parentPath = Environment.getExternalStorageDirectory();
    public static String storagePath = "";
    public static final String DST_FOLDER_NAME = "FaceRecog";

    public static void copyFile(String oldPath, String newPath) {
        try {
            int bytesum = 0;
            int byteread = 0;
            File oldfile = new File(oldPath);
            if (oldfile.exists()) {
                FileInputStream inStream = new FileInputStream(oldPath);
                FileOutputStream fs = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                    System.out.println(bytesum += byteread);
                    fs.write(buffer, 0, byteread);
                }
                fs.flush();
                fs.close();
                ((InputStream)inStream).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] file2byte(File file) throws IOException {
        byte[] bytes = null;
        if (file != null) {
            int offset;
            FileInputStream is = new FileInputStream(file);
            int length = (int)file.length();
            if (length > Integer.MAX_VALUE) {
                System.out.println("this file is max ");
                ((InputStream)is).close();
                return null;
            }
            bytes = new byte[length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            ((InputStream)is).close();
            if (offset < bytes.length) {
                System.out.println("file length is error");
                return null;
            }
        }
        return bytes;
    }

    public static void mkParentDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static void mkDir(String dirPath) {
        String[] dirArray = dirPath.split("/");
        String pathTemp = "";
        for (int i = 1; i < dirArray.length; ++i) {
            pathTemp = pathTemp + "/" + dirArray[i];
            File newF = new File(dirArray[0] + pathTemp);
            if (newF.exists()) continue;
            newF.mkdir();
        }
    }

    public static void createModelFile(String modelDirPath, String modelFileName, AssetManager assetManager) {
        String content = null;
        String parentDir = "model";
        List<String> fileNameList = null;
        String[] files = null;
        String fileAbsPath = "";
        fileAbsPath = modelDirPath.endsWith("/") ? modelDirPath + modelFileName : modelDirPath + "/" + modelFileName;
        File modelFile = new File(fileAbsPath);
        if (modelFile.exists()) {
            return;
        }
        FileUtil.mkDir(modelDirPath);
        try {
            files = assetManager.list(parentDir);
            fileNameList = Arrays.asList(files);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        for (String fileName : fileNameList) {
            Log.e((String)TAG, (String)fileName);
            content = FileUtil.readRawFileToString(parentDir + File.separator + fileName, assetManager);
            FileUtil.writeStringToFile(content, fileAbsPath);
        }
    }

    public static void createModelFileAll(String modelDirPath, AssetManager assetManager) {
        String parentDir = "model";
        List<String> fileNameList = null;
        String[] files = null;
        String fileAbsPath = "";
        fileAbsPath = modelDirPath.endsWith("/") ? modelDirPath : modelDirPath + "/";
        FileUtil.mkDir(modelDirPath);
        try {
            files = assetManager.list(parentDir);
            fileNameList = Arrays.asList(files);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
        for (String fileName : fileNameList) {
            Log.e((String)TAG, (String)fileName);
            File modelFile = new File(fileAbsPath + fileName);
            if (modelFile.exists()) continue;
            FileUtil.copyRawFileToSdcard(parentDir + File.separator + fileName, assetManager, fileAbsPath + fileName);
        }
    }

    public static String readRawFileToString(String rawFileName, AssetManager assetManager) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            return FileUtil.inputStreamToString(inputStream);
        }
        return null;
    }

    public static byte[] readRawFileToByteArray(String rawFileName, AssetManager assetManager) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            return FileUtil.inputStreamToByteArray(inputStream);
        }
        return null;
    }

    public static void copyRawFileToSdcard(String rawFileName, AssetManager assetManager, String outPutFileAbs) {
        InputStream inputStream = null;
        try {
            inputStream = assetManager.open(rawFileName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)e.getMessage());
        }
        if (inputStream != null) {
            FileUtil.inputStreamToFile(inputStream, outPutFileAbs);
        }
    }

    public static String inputStreamToString(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toString();
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return outputStream.toByteArray();
    }

    public static void inputStreamToFile(InputStream inputStream, String absPath) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int len = 0;
        try {
            while ((len = inputStream.read(buf)) != -1) {
                outputStream.write(buf, 0, len);
            }
            outputStream.close();
            inputStream.close();
            byte[] imgBytes = outputStream.toByteArray();
            FileOutputStream fos = new FileOutputStream(absPath, false);
            fos.write(imgBytes);
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeStringToFile(String content, String file_name) {
        try {
            File file = new File(file_name);
            FileOutputStream fileW = new FileOutputStream(file.getCanonicalPath());
            fileW.write(content.getBytes());
            fileW.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeByteArrayToFile(byte[] content, String file_name) {
        try {
            File file = new File(file_name);
            FileOutputStream fileW = new FileOutputStream(file.getCanonicalPath());
            fileW.write(content);
            fileW.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeByteArrayToSD(byte[] content, String file_name) {
        try {
            File parentPath = Environment.getExternalStorageDirectory();
            String file_path = parentPath.getAbsolutePath() + "/" + DST_FOLDER_NAME + "/" + file_name;
            File file = new File(file_path);
            FileOutputStream fileW = new FileOutputStream(file.getCanonicalPath());
            fileW.write(content);
            fileW.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    FileUtil.deleteFile(files[i]);
                }
            }
            file.delete();
        }
    }

    public static void assetsDataToDest(Context context, String origin, String destination) throws IOException {
        InputStream input = context.getAssets().open(origin);
        FileOutputStream output = new FileOutputStream(destination);
        byte[] buffer = new byte[1024];
        int length = input.read(buffer);
        while (length > 0) {
            ((OutputStream)output).write(buffer, 0, length);
            length = input.read(buffer);
        }
        output.flush();
        input.close();
        ((OutputStream)output).close();
    }

    public static void unZipFolder(String zipFileString, String outPathString) throws Exception {
        ZipEntry zipEntry;
        ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFileString));
        String szName = "";
        while ((zipEntry = inZip.getNextEntry()) != null) {
            int len;
            szName = zipEntry.getName();
            if (zipEntry.isDirectory()) {
                szName = szName.substring(0, szName.length() - 1);
                File folder = new File(outPathString + File.separator + szName);
                folder.mkdirs();
                continue;
            }
            File file = new File(outPathString + File.separator + szName);
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((len = inZip.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                out.flush();
            }
            out.close();
        }
        inZip.close();
    }
}

