/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.provider.MediaStore;
import cn.cloudwalk.libproject.util.LogUtils;
import java.io.IOException;

public class ThumbnailUtil {
    static final String TAG = "ThumbnailUtil";

    public static Bitmap getDicmThumbnail(Uri uri, Context ctx) {
        String[] imageInfo = ThumbnailUtil.getRealPathFromURI(uri, ctx);
        if (imageInfo == null || imageInfo.length < 2) {
            return null;
        }
        return ThumbnailUtil.getThumbnail(ctx.getContentResolver(), Long.parseLong(imageInfo[1]));
    }

    public static String[] getRealPathFromURI(Uri contentUri, Context ctx) {
        String[] proj = new String[]{"_data", "_id"};
        String[] resStrs = null;
        Cursor cursor = null;
        try {
            cursor = ctx.getContentResolver().query(contentUri, proj, null, null, null);
            int path_index = cursor.getColumnIndexOrThrow(proj[0]);
            int id_index = cursor.getColumnIndexOrThrow(proj[1]);
            cursor.moveToFirst();
            resStrs = new String[]{cursor.getString(path_index), cursor.getLong(id_index) + ""};
            cursor.close();
        }
        catch (Exception e) {
            if (cursor != null) {
                cursor.close();
            }
            e.printStackTrace();
        }
        return resStrs;
    }

    public static Bitmap getThumbnail(ContentResolver contentResolver, long id2) {
        Cursor cursor = contentResolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data"}, "_id=?", new String[]{String.valueOf(id2)}, null);
        if (cursor != null && cursor.getCount() > 0) {
            cursor.moveToFirst();
            String filePath = cursor.getString(0);
            cursor.close();
            int rotation = 0;
            try {
                ExifInterface exifInterface = new ExifInterface(filePath);
                int exifRotation = exifInterface.getAttributeInt("Orientation", 0);
                if (exifRotation != 0) {
                    switch (exifRotation) {
                        case 3: {
                            rotation = 180;
                            break;
                        }
                        case 8: {
                            rotation = 270;
                            break;
                        }
                        case 6: {
                            rotation = 90;
                        }
                    }
                }
            }
            catch (IOException e) {
                LogUtils.LOGE(TAG, e.toString());
            }
            Bitmap bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)contentResolver, (long)id2, (int)1, null);
            int width = bitmap.getWidth();
            int hight = bitmap.getHeight();
            if (rotation != 0) {
                Matrix matrix = new Matrix();
                matrix.setRotate((float)rotation);
                bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)hight, (Matrix)matrix, (boolean)true);
            }
            LogUtils.LOGE(TAG, "\u7f29\u7565\u56fe\u957f\u5bbd:" + width + "" + hight);
            return bitmap;
        }
        return null;
    }
}

