/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk.libproject.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;

public class RoundProgressBar
extends View {
    private Paint paint = new Paint();
    private int roundColor = -65536;
    private int roundProgressColor = -16711936;
    private int textColor = -16711936;
    private float textSize = 15.0f;
    private float roundWidth = 5.0f;
    private int max = 90;
    private int progress;
    private int style = 0;
    private boolean isCircle = false;
    private boolean isText = false;
    public static final int STROKE = 0;
    public static final int FILL = 1;

    public RoundProgressBar(Context context) {
        this(context, null);
    }

    public RoundProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int centre = this.getWidth() / 2;
        int radius = (int)((float)centre - this.roundWidth / 2.0f);
        if (this.isCircle) {
            this.paint.setColor(this.roundColor);
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(this.roundWidth);
            this.paint.setAntiAlias(true);
            canvas.drawCircle((float)centre, (float)centre, (float)radius, this.paint);
            Log.e((String)"log", (String)(centre + ""));
        }
        if (this.isText) {
            this.paint.setStrokeWidth(0.0f);
            this.paint.setColor(this.textColor);
            this.paint.setTextSize(this.textSize);
            this.paint.setTypeface(Typeface.DEFAULT_BOLD);
            int percent = (int)((float)this.progress / (float)this.max * 100.0f);
            float textWidth = this.paint.measureText(percent + "%");
            if (percent != 0 && this.style == 0) {
                canvas.drawText(percent + "%", (float)centre - textWidth / 2.0f, (float)centre + this.textSize / 2.0f, this.paint);
            }
        }
        this.paint.setStrokeWidth(this.roundWidth);
        this.paint.setColor(this.roundProgressColor);
        RectF oval = new RectF((float)(centre - radius), (float)(centre - radius), (float)(centre + radius), (float)(centre + radius));
        switch (this.style) {
            case 0: {
                this.paint.setAntiAlias(true);
                this.paint.setFlags(1);
                this.paint.setStyle(Paint.Style.STROKE);
                canvas.drawArc(oval, 0.0f, (float)(360 * this.progress / this.max), false, this.paint);
                break;
            }
            case 1: {
                this.paint.setAntiAlias(true);
                this.paint.setFlags(1);
                this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
                if (this.progress == 0) break;
                canvas.drawArc(oval, 0.0f, (float)(360 * this.progress / this.max), true, this.paint);
            }
        }
    }

    public synchronized int getMax() {
        return this.max;
    }

    public synchronized void setMax(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("max not less than 0");
        }
        this.max = max;
    }

    public synchronized int getProgress() {
        return this.progress;
    }

    public synchronized void setProgress(int progress) {
        if (Math.abs(progress) > this.max) {
            progress = this.max;
        }
        if (Math.abs(progress) <= this.max) {
            this.progress = progress;
            this.postInvalidate();
        }
    }

    public int getCricleColor() {
        return this.roundColor;
    }

    public void setCricleColor(int cricleColor) {
        this.roundColor = cricleColor;
        this.roundProgressColor = cricleColor;
    }

    public int getCricleProgressColor() {
        return this.roundProgressColor;
    }

    public void setCricleProgressColor(int cricleProgressColor) {
        this.roundProgressColor = cricleProgressColor;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
    }

    public float getRoundWidth() {
        return this.roundWidth;
    }

    public void setRoundWidth(float roundWidth) {
        this.roundWidth = roundWidth;
    }

    public void setArcColor(int color2) {
        this.roundProgressColor = color2;
        this.roundColor = color2;
    }
}

