/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Environment;
import android.os.Process;
import cn.cloudwalk.TestLog;
import cn.cloudwalk.callback.BankCardCallback;
import cn.cloudwalk.jni.BankCardInfo;
import cn.cloudwalk.jni.BankCardOCR;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class BankOcrSDK {
    private static float yuz_high = 0.7f;
    private static float yuz_mid = 0.6f;
    private static float yuz_low = 0.5f;
    private static int MAX_QUEUE_Mid = 3;
    private static int MAX_QUEUE_Low = 8;
    BankCardOCR bankOcrDetect;
    private BankCardCallback bankCardCallback;
    private static BankOcrSDK bankOcrSDK;
    private BankCardInfo bankCardInfo;
    private Context context;
    private int InfoWidth;
    private int InfoHeight;
    private int pDetector;
    private byte[] mFrame = null;
    private Thread videoThread = null;
    private int width;
    private int height;
    private int colorType;
    private int left_topx;
    private int left_topy;
    private int right_bottomx;
    private int right_bottomy;
    private int orientation;
    ReentrantLock _lock = new ReentrantLock();
    volatile int _times = 0;
    volatile boolean _isThreadAlive = false;
    private TreeMap<Float, byte[]> AlignDatasMid;
    private TreeMap<Float, byte[]> AlignDatasLow;
    long _tmp_time = 0L;
    long _tmp_count = 0L;
    int nTestIndex = 0;

    private BankOcrSDK(Context context) {
        this.context = context.getApplicationContext();
        this.bankOcrDetect = BankCardOCR.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static BankOcrSDK getInstance(Context context) {
        if (bankOcrSDK == null) {
            Class<BankOcrSDK> clazz = BankOcrSDK.class;
            // MONITORENTER : cn.cloudwalk.BankOcrSDK.class
            if (bankOcrSDK == null) {
                bankOcrSDK = new BankOcrSDK(context);
            }
            // MONITOREXIT : clazz
        }
        float lastLow = yuz_low;
        float lastMid = yuz_mid;
        float lastHigh = yuz_high;
        if (!((double)Math.abs(yuz_low - lastLow) > 0.01) && !((double)Math.abs(yuz_mid - lastMid) > 0.01)) {
            if (!((double)Math.abs(yuz_high - lastHigh) > 0.01)) return bankOcrSDK;
        }
        TestLog.LogE("\u9608\u503c", String.format("%.2f - % .2f - %.2f", Float.valueOf(yuz_low), Float.valueOf(yuz_mid), Float.valueOf(yuz_high)));
        return bankOcrSDK;
    }

    public void cwBankCardCallback(BankCardCallback bankCardCallback) {
        this.bankCardCallback = bankCardCallback;
    }

    public int cwCreateCardHandle(String pLicence) {
        TestLog.LogE("CardFront version = ", "" + this.cwGetCardFrontVersion());
        this.pDetector = this.bankOcrDetect.createCardHandle(pLicence);
        if (this.pDetector == 0) {
            this.cwStart();
        }
        return this.pDetector;
    }

    public int cwDestroyCardHandle() {
        return this.bankOcrDetect.destroyCardHandle(this.pDetector);
    }

    public int cwDetectCardEdges(byte[] imgdata, int width, int height, int colorType, int left_topx, int left_topy, int right_bottomx, int right_bottomy) {
        int ret = -8;
        if (this.pDetector >= 0) {
            this.bankCardInfo.left = 0;
            this.bankCardInfo.top = 0;
            this.bankCardInfo.right = 0;
            this.bankCardInfo.bottom = 0;
            ret = this.bankOcrDetect.detectCardEdges(this.pDetector, imgdata, width, height, colorType, left_topx, left_topy, right_bottomx, right_bottomy, this.bankCardInfo, 2);
            if (this.bankCardCallback != null) {
                this.bankCardCallback.BankCardInfo(this.bankCardInfo);
            }
        }
        return ret;
    }

    public int cwGetAlignImageWidth() {
        return this.bankOcrDetect.getAlignImageWidth(this.pDetector);
    }

    public int cwGetAlignImageHeight() {
        return this.bankOcrDetect.getAlignImageHeight(this.pDetector);
    }

    public float cwGetAlignCardImage(byte[] Alignimgdata, int width, int height) {
        float result = 0.0f;
        float fScore = this.bankOcrDetect.getAlignCardImage(this.pDetector, Alignimgdata, width, height);
        if (fScore > 0.0f) {
            TestLog.LogE("\u8d28\u91cf\u5206\u6570", String.format("%.2f", Float.valueOf(fScore)));
        }
        if (fScore >= yuz_high) {
            if (this.bankCardCallback != null) {
                this.bankCardCallback.BankCardAlignData(Alignimgdata, width, height);
                result = fScore;
            }
        } else if (yuz_low <= fScore) {
            if (yuz_mid <= fScore && fScore < yuz_high && MAX_QUEUE_Mid > 0) {
                this.AlignDatasMid.put(Float.valueOf(fScore), Alignimgdata);
            }
            if (MAX_QUEUE_Low > 0) {
                this.AlignDatasLow.put(Float.valueOf(fScore), Alignimgdata);
            }
            TestLog.LogE("#\u7f13\u5b58\u6570\u91cf", String.format("\u4e2d\u5c42=%d, \u4f4e\u5c42=%d", this.AlignDatasMid.size(), this.AlignDatasLow.size()));
            TreeMap<Float, byte[]> toDealDatas = null;
            if (this.AlignDatasMid.size() == MAX_QUEUE_Mid && MAX_QUEUE_Mid > 0) {
                toDealDatas = this.AlignDatasMid;
                TestLog.LogE("#\u7f13\u5b58 \u9009\u53d6", "\u4e2d\u5c42");
            } else if (this.AlignDatasLow.size() == MAX_QUEUE_Low && MAX_QUEUE_Low > 0) {
                toDealDatas = this.AlignDatasLow;
                TestLog.LogE("#\u7f13\u5b58 \u9009\u53d6", "\u4f4e\u5c42");
            }
            if (null != toDealDatas) {
                float tmpScore = 0.0f;
                byte[] alidatas = null;
                for (Map.Entry<Float, byte[]> entry : toDealDatas.entrySet()) {
                    if (entry.getKey().floatValue() > tmpScore) {
                        tmpScore = entry.getKey().floatValue();
                        alidatas = entry.getValue();
                    }
                    TestLog.LogE("#\u7f13\u5b58 \u8d28\u91cf\u5206", String.format("%.2f", entry.getKey()));
                }
                TestLog.LogE("#\u7f13\u5b58 \u8d28\u91cf\u5206 - \u9009\u62e9", String.format("%.2f", Float.valueOf(tmpScore)));
                this.AlignDatasMid = null;
                this.AlignDatasLow = null;
                toDealDatas = null;
                if (this.bankCardCallback != null) {
                    this.bankCardCallback.BankCardAlignData(alidatas, width, height);
                    result = fScore;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwPushFrame(byte[] frameData, int width, int height, int colorType, int left_topx, int left_topy, int right_bottomx, int right_bottomy, int orientation) {
        if (null == frameData || !this._isThreadAlive) {
            return;
        }
        if (this._lock.isLocked()) {
            return;
        }
        this._lock.lock();
        try {
            this.mFrame = frameData;
            this.orientation = orientation;
            this.width = width;
            this.height = height;
            this.colorType = colorType;
            this.left_topx = left_topx;
            this.left_topy = left_topy;
            this.right_bottomx = right_bottomx;
            this.right_bottomy = right_bottomy;
        }
        catch (Exception exception) {
        }
        finally {
            this._lock.unlock();
        }
    }

    public static byte[] rotateNV21Degree90(byte[] data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        try {
            int y;
            int x;
            int i = 0;
            for (x = 0; x < imageWidth; ++x) {
                for (y = imageHeight - 1; y >= 0; --y) {
                    yuv[i] = data[y * imageWidth + x];
                    ++i;
                }
            }
            i = imageWidth * imageHeight * 3 / 2 - 1;
            for (x = imageWidth - 1; x > 0; x -= 2) {
                for (y = 0; y < imageHeight / 2; ++y) {
                    yuv[i] = data[imageWidth * imageHeight + y * imageWidth + x];
                    yuv[--i] = data[imageWidth * imageHeight + y * imageWidth + (x - 1)];
                    --i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return yuv;
    }

    private void processVideoFrame(byte[] frame) {
        if (0L == this._tmp_time) {
            this._tmp_time = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this._tmp_time >= 60000L) {
            TestLog.LogE("\u5e27\u7387----", "" + this._tmp_count + " \u5e27/\u5206");
            this._tmp_count = 0L;
            this._tmp_time = 0L;
        }
        ++this._tmp_count;
        if (this.bankCardInfo == null) {
            this.bankCardInfo = new BankCardInfo();
        }
        if (this.AlignDatasMid == null) {
            this.AlignDatasMid = new TreeMap();
        }
        if (this.AlignDatasLow == null) {
            this.AlignDatasLow = new TreeMap();
        }
        if (this.orientation == 1 && this.height > this.width) {
            frame = BankOcrSDK.rotateNV21Degree90(frame, this.height, this.width);
        }
        int ret = this.cwDetectCardEdges(frame, this.width, this.height, this.colorType, this.left_topx, this.left_topy, this.right_bottomx, this.right_bottomy);
        float fScore = 0.0f;
        if (ret == 0 && this.bankCardInfo.left == 1 && this.bankCardInfo.top == 1 && this.bankCardInfo.right == 1 && this.bankCardInfo.bottom == 1) {
            this.InfoWidth = this.cwGetAlignImageWidth();
            this.InfoHeight = this.cwGetAlignImageHeight();
            byte[] Alignimgdata = new byte[this.InfoWidth * this.InfoHeight * 3];
            fScore = this.cwGetAlignCardImage(Alignimgdata, this.InfoWidth, this.InfoHeight);
            if ((double)fScore > 0.01) {
                // empty if block
            }
            Alignimgdata = null;
        }
    }

    public static byte[] BitmapToBGR(Bitmap image) {
        int bits = 4;
        int bytes = image.getByteCount();
        ByteBuffer buffer = ByteBuffer.allocate(bytes);
        image.copyPixelsToBuffer((Buffer)buffer);
        byte[] temp = buffer.array();
        byte[] pixels = new byte[temp.length / bits * 3];
        int count = temp.length / bits;
        for (int i = 0; i < count; ++i) {
            pixels[i * 3 + 0] = temp[i * 4 + 0];
            pixels[i * 3 + 1] = temp[i * 4 + 1];
            pixels[i * 3 + 2] = temp[i * 4 + 2];
        }
        buffer.clear();
        buffer = null;
        temp = null;
        return pixels;
    }

    public static Bitmap byteArrayBGRToBitmap(byte[] data, int width, int height) {
        int frameSize = width * height;
        int[] rgba = new int[frameSize];
        for (int i = 0; i < height * width; ++i) {
            int b = 0xFF & data[i * 3 + 0];
            int g = 0xFF & data[i * 3 + 1];
            int r = 0xFF & data[i * 3 + 2];
            int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
            int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
            b = b < 0 ? 0 : (b > 255 ? 255 : b);
            rgba[i] = -16777216 + (r << 16) + (g << 8) + b;
        }
        Bitmap bmp = Bitmap.createBitmap((int[])rgba, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        rgba = null;
        return bmp;
    }

    public static Bitmap decodeBitmap(byte[] is, int inSampleSize) {
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inSampleSize = inSampleSize;
            opts.inTempStorage = new byte[16384];
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])is, (int)0, (int)is.length, (BitmapFactory.Options)opts);
            opts = null;
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Bitmap decodeBitmap(InputStream is, int inSampleSize) {
        try {
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inSampleSize = inSampleSize;
            opts.inTempStorage = new byte[16384];
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
            opts = null;
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Bitmap yuv2Img(byte[] frameData, int yuvFormat, int prevWidth, int prevHeight, int quality) {
        Long start = System.currentTimeMillis();
        Bitmap img = null;
        try {
            YuvImage image = new YuvImage(frameData, yuvFormat, prevWidth, prevHeight, null);
            if (image != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                image.compressToJpeg(new Rect(0, 0, prevWidth, prevHeight), quality, (OutputStream)stream);
                img = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                stream.close();
                image = null;
            }
        }
        catch (Exception ex) {
            TestLog.netE("ContentValues", "yuv2Img\u5f02\u5e38:" + ex.getMessage());
        }
        TestLog.netE("ContentValues", "yuv2Img" + (System.currentTimeMillis() - start));
        return img;
    }

    public static String getDiskCacheDir(Context context) {
        String cachePath = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            cachePath = context.getExternalCacheDir().getPath();
        }
        if (cachePath == null) {
            cachePath = context.getCacheDir().getPath();
        }
        return cachePath;
    }

    public static void saveJPG_After(Bitmap bitmap, String path, int quality) {
        File file = new File(path);
        try {
            FileOutputStream out = new FileOutputStream(file);
            if (bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out)) {
                out.flush();
                out.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int cwStart() {
        this._times = 0;
        this._isThreadAlive = true;
        this.mFrame = null;
        if (null == this.videoThread) {
            this.videoThread = new Thread(new VideoRecordRunnable());
            this.videoThread.start();
        }
        return 0;
    }

    private int cwStop() {
        this._isThreadAlive = false;
        if (null != this.videoThread) {
            try {
                this.videoThread.join();
                this.videoThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    public String cwGetCardFrontVersion() {
        String version = this.bankOcrDetect.getCardFrontVersion();
        return version;
    }

    public int cwDestory() {
        this.bankCardCallback = null;
        this.AlignDatasMid = null;
        this.AlignDatasLow = null;
        this.cwStop();
        return 0;
    }

    static /* synthetic */ byte[] access$002(BankOcrSDK x0, byte[] x1) {
        x0.mFrame = x1;
        return x1;
    }

    private class VideoRecordRunnable
    implements Runnable {
        private VideoRecordRunnable() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)19);
            TestLog.LogE("Thread", "----start");
            while (BankOcrSDK.this._isThreadAlive) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (BankOcrSDK.this._lock.isLocked() || null == BankOcrSDK.this.mFrame) continue;
                byte[] curFrame = BankOcrSDK.this.mFrame;
                BankOcrSDK.access$002(BankOcrSDK.this, null);
                BankOcrSDK.this._lock.lock();
                ++BankOcrSDK.this._times;
                TestLog.LogE("\u8bc6\u522b\u5e8f\u53f7", "index = " + BankOcrSDK.this._times);
                try {
                    BankOcrSDK.this.processVideoFrame(curFrame);
                }
                catch (Exception ex) {
                    TestLog.LogE("processVideoFrame", "\u5f02\u5e38:" + ex.getMessage());
                }
                finally {
                    BankOcrSDK.this._lock.unlock();
                    System.gc();
                }
            }
            BankOcrSDK.this.cwDestroyCardHandle();
            TestLog.LogE("Thread", "----stop");
        }
    }
}

