/*
 * Decompiled with CFR 0.152.
 */
package cn.cloudwalk;

import android.content.Context;
import android.os.Process;
import cn.cloudwalk.TestLog;
import cn.cloudwalk.callback.IDCardImgCallback;
import cn.cloudwalk.jni.IDCardImg;
import cn.cloudwalk.jni.IDCardRecog;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;

public class IDCardSDK {
    int pDetector;
    IDCardRecog idCardRecog;
    final float maxScore = 0.62f;
    final float minFrontScore = 0.55f;
    final float minBackScore = 0.55f;
    private Context context;
    private IDCardImgCallback idCardImgCallback;
    private IDCardImg idCardImg = new IDCardImg();
    private static volatile IDCardSDK IDCardSDK;
    private byte[] mFrame = null;
    private Thread videoThread = null;
    private int width;
    private int height;
    private int colorType;
    private int flag;
    int mleft;
    int mtop;
    int mright;
    int mbottom;
    ReentrantLock _lock = new ReentrantLock();
    volatile int _times = 0;
    volatile boolean _isThreadAlive = false;
    private TreeMap<Float, IDCardImg> AlignDatas;
    private IDCardImg alidatas;
    long _tmp_time = 0L;
    long _tmp_count = 0L;

    private IDCardSDK(Context context) {
        this.context = context;
        this.idCardRecog = IDCardRecog.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDCardSDK getInstance(Context context) {
        if (IDCardSDK != null) return IDCardSDK;
        Class<IDCardSDK> clazz = IDCardSDK.class;
        synchronized (IDCardSDK.class) {
            if (IDCardSDK != null) return IDCardSDK;
            IDCardSDK = new IDCardSDK(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return IDCardSDK;
        }
    }

    public void cwIDCardImgCallback(IDCardImgCallback idCardImgCallback) {
        this.idCardImgCallback = idCardImgCallback;
    }

    public int cwCreateIdCardRecog(String pLicence) {
        TestLog.LogE("DecectIdCard version = ", "" + this.idCardRecog.getVersion());
        int ThreadNum = 1;
        this.pDetector = this.idCardRecog.createIdCardRecog(pLicence, ThreadNum);
        if (0 == this.pDetector) {
            this.cwStart();
        }
        return this.pDetector;
    }

    public void cwDestroyIdCardRecog() {
        this.idCardImgCallback = null;
        this.cwStop();
    }

    public int cwDetectIdCard(byte[] in_jpeg, int width, int height, int colorType, int left_topx, int left_topy, int right_bottomx, int right_bottomy, int cardType) {
        this.idCardImg.left = 0;
        this.idCardImg.top = 0;
        this.idCardImg.right = 0;
        this.idCardImg.bottom = 0;
        int sfret = this.idCardRecog.detectIdCard(this.pDetector, in_jpeg, width, height, colorType, this.idCardImg, left_topx, left_topy, right_bottomx, right_bottomy, cardType);
        if (this.idCardImgCallback != null) {
            float socre = this.idCardImg.socre;
            this.idCardImgCallback.IDCardImg(this.idCardImg);
        }
        return sfret;
    }

    public String cwGetVersion() {
        return this.idCardRecog.getVersion();
    }

    public int checkInt(Object sint, int def) {
        try {
            return Integer.valueOf("" + sint);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    private int cwStart() {
        this._times = 0;
        this._isThreadAlive = true;
        this.mFrame = null;
        if (null == this.videoThread) {
            this.videoThread = new Thread(new VideoRecordRunnable());
            this.videoThread.start();
        }
        return 0;
    }

    private int cwStop() {
        this._isThreadAlive = false;
        if (null != this.videoThread) {
            try {
                this.videoThread.join();
                this.videoThread = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cwPushFrame(byte[] frameData, int width, int height, int colorType, int flag, int left, int top, int right, int bottom) {
        if (null == frameData || !this._isThreadAlive) {
            return;
        }
        if (this._lock.isLocked()) {
            return;
        }
        this._lock.lock();
        try {
            this.mFrame = frameData;
            this.width = width;
            this.height = height;
            this.colorType = colorType;
            this.flag = flag;
            this.mleft = left;
            this.mtop = top;
            this.mright = right;
            this.mbottom = bottom;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this._lock.unlock();
        }
    }

    private void processVideoFrame(byte[] frame) {
        if (0L == this._tmp_time) {
            this._tmp_time = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - this._tmp_time >= 60000L) {
            TestLog.LogE("\u5e27\u7387----", "" + this._tmp_count + " \u5e27/\u5206");
            this._tmp_count = 0L;
            this._tmp_time = 0L;
        }
        ++this._tmp_count;
        boolean result = false;
        if (this.AlignDatas == null) {
            this.AlignDatas = new TreeMap();
        }
        int ret = this.cwDetectIdCard(frame, this.width, this.height, this.colorType, this.mleft, this.mtop, this.mright, this.mbottom, this.flag == 1 ? 0 : 1);
        float fScore = this.idCardImg.socre;
        if (this.idCardImgCallback != null && ret == 0 && this.flag == this.idCardImg.flag) {
            float minScore = 0.0f;
            if (1 == this.flag) {
                minScore = 0.55f;
            } else if (0 == this.flag) {
                minScore = 0.55f;
            }
            if (fScore >= 0.62f) {
                this.alidatas = this.idCardImg;
                TestLog.LogE("\u7f13\u5b58", String.format("(\u8d85\u8fc7)\u5206\u6570 = %.3f", Float.valueOf(fScore)));
                this.idCardImgCallback.IDCardDetectOk(this.alidatas);
            } else if (minScore <= fScore && fScore < 0.62f) {
                this.AlignDatas.put(Float.valueOf(fScore), this.idCardImg);
                TestLog.LogE("\u7f13\u5b58", String.format("(\u666e\u901a)\u5206\u6570 = %.3f", Float.valueOf(fScore)));
                if (this.AlignDatas.size() >= 3) {
                    this.alidatas = null;
                    float tmpScore = 0.0f;
                    for (Map.Entry<Float, IDCardImg> entry : this.AlignDatas.entrySet()) {
                        if (!(entry.getKey().floatValue() > tmpScore)) continue;
                        tmpScore = entry.getKey().floatValue();
                        this.alidatas = entry.getValue();
                    }
                    this.AlignDatas.clear();
                    this.idCardImgCallback.IDCardDetectOk(this.alidatas);
                }
            }
        }
    }

    static /* synthetic */ byte[] access$102(IDCardSDK x0, byte[] x1) {
        x0.mFrame = x1;
        return x1;
    }

    private class VideoRecordRunnable
    implements Runnable {
        private VideoRecordRunnable() {
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)19);
            TestLog.LogE("Thread", "----start");
            while (IDCardSDK.this._isThreadAlive) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (IDCardSDK.this._lock.isLocked() || null == IDCardSDK.this.mFrame) continue;
                byte[] curFrame = IDCardSDK.this.mFrame;
                cn.cloudwalk.IDCardSDK.access$102(IDCardSDK.this, null);
                IDCardSDK.this._lock.lock();
                ++IDCardSDK.this._times;
                TestLog.LogE("\u8bc6\u522b\u5e8f\u53f7", "index = " + IDCardSDK.this._times);
                try {
                    IDCardSDK.this.processVideoFrame(curFrame);
                }
                catch (Exception ex) {
                    TestLog.LogE("processVideoFrame", "\u5f02\u5e38:" + ex.getMessage());
                    ex.printStackTrace();
                }
                finally {
                    IDCardSDK.this._lock.unlock();
                    System.gc();
                }
            }
            IDCardSDK.this.idCardRecog.destroyIdCardRecog(IDCardSDK.this.pDetector);
            TestLog.LogE("Thread", "----stop");
        }
    }
}

