/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenessdetection;

import com.megvii.livenessdetection.DetectionFrame;
import com.megvii.livenessdetection.bean.FaceInfo;
import java.security.InvalidParameterException;
import java.util.LinkedList;
import java.util.List;

public class FaceQualityManager {
    public float pitchThreshold = 0.17f;
    public float yawThreshold = 0.17f;
    public float integrityThreshold = 0.99f;
    public float minBrightnessThreshold = 70.0f;
    public float maxBrightnessThreshold = 230.0f;
    public float faceWidthThreshold = 150.0f;
    public float motionBlurThreshold = 0.2f;
    public float gaussianBlurThreshold = 0.15f;
    private float a = 0.5f;
    private float b = 0.5f;
    public int needHolding = 3;
    private int c = 0;
    public float faceMaxSizeRatioThreshold = 0.4f;

    public FaceQualityManager(float f, float f2) {
        this.a = f;
        this.b = f2;
    }

    public synchronized List<FaceQualityErrorType> feedFrame(DetectionFrame detectionFrame) {
        LinkedList<FaceQualityErrorType> linkedList = new LinkedList<FaceQualityErrorType>();
        if (detectionFrame == null) {
            throw new InvalidParameterException("detectionFrame could not be null");
        }
        int n = detectionFrame.getRotation() % 180 == 0 ? detectionFrame.getImageWidth() : detectionFrame.getImageHeight();
        int n2 = detectionFrame.getRotation() % 180 == 0 ? detectionFrame.getImageHeight() : detectionFrame.getImageWidth();
        FaceInfo faceInfo = detectionFrame.getFaceInfo();
        if (faceInfo == null) {
            linkedList.add(FaceQualityErrorType.FACE_NOT_FOUND);
        } else {
            float f;
            detectionFrame = detectionFrame.getFacePos();
            float f2 = detectionFrame.centerX();
            float f3 = detectionFrame.centerY();
            float f4 = (float)Math.sqrt(Math.pow((f2 - this.a) * (float)n, 2.0) + Math.pow((f3 - this.b) * (float)n2, 2.0));
            if (f / (float)faceInfo.faceSize.width() > 0.5f) {
                linkedList.add(FaceQualityErrorType.FACE_OUT_OF_RECT);
            }
            if (Math.abs(faceInfo.yaw) > this.yawThreshold || Math.abs(faceInfo.pitch) > this.pitchThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_POS_DEVIATED);
            }
            if (faceInfo.integrity < this.integrityThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_NONINTEGRITY);
            }
            if (faceInfo.brightness < this.minBrightnessThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_TOO_DARK);
            }
            if (faceInfo.brightness > this.maxBrightnessThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_TOO_BRIGHT);
            }
            if ((float)faceInfo.faceSize.width() < this.faceWidthThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_TOO_SMALL);
            }
            if (detectionFrame.width() > this.faceMaxSizeRatioThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_TOO_LARGE);
            }
            if (faceInfo.motionBlur > this.motionBlurThreshold || faceInfo.gaussianBlur > this.gaussianBlurThreshold) {
                linkedList.add(FaceQualityErrorType.FACE_TOO_BLURRY);
            }
            if (faceInfo.eyeLeftOcclusion > 0.5f || faceInfo.eyeRightOcclusion > 0.5f) {
                linkedList.add(FaceQualityErrorType.FACE_EYE_OCCLUSIVE);
            }
            if (faceInfo.mouthOcclusion > 0.5f) {
                linkedList.add(FaceQualityErrorType.FACE_MOUTH_OCCLUSIVE);
            }
        }
        if (linkedList.size() == 0) {
            if (this.c++ < this.needHolding) {
                linkedList.add(FaceQualityErrorType.FRAME_NEED_HOLDING);
            }
        } else {
            this.c = 0;
        }
        return new LinkedList<FaceQualityErrorType>(linkedList);
    }

    public static enum FaceQualityErrorType {
        NONE,
        FRAME_NEED_HOLDING,
        FACE_NOT_FOUND,
        FACE_POS_DEVIATED,
        FACE_NONINTEGRITY,
        FACE_TOO_DARK,
        FACE_TOO_BRIGHT,
        FACE_TOO_SMALL,
        FACE_TOO_LARGE,
        FACE_TOO_BLURRY,
        FACE_OUT_OF_RECT,
        FACE_EYE_OCCLUSIVE,
        FACE_MOUTH_OCCLUSIVE;

    }
}

