/*
 * Decompiled with CFR 0.152.
 */
package com.megvii.livenessdetection.bean;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import org.json.JSONObject;

public class FaceInfo {
    public Rect faceSize;
    public RectF position;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float gaussianBlur = 0.0f;
    public float motionBlur = 0.0f;
    public float brightness = 0.0f;
    public float wearGlass = 0.0f;
    public float faceQuality = 0.0f;
    public float leftEyeHWRatio = 0.0f;
    public float rightEyeHWRatio = 0.0f;
    public float mouthHWRatio = 0.0f;
    public float integrity = 0.0f;
    public boolean pitch3d = false;
    public boolean notVideo = false;
    public boolean mouthOpen = false;
    public boolean eyeBlink = false;
    public float smoothYaw = 0.0f;
    public float smoothPitch = 0.0f;
    public float eyeLeftDet = 0.0f;
    public float eyeRightDet = 0.0f;
    public float mouthDet = 0.0f;
    public float smoothQuality = 0.0f;
    public float eyeLeftOcclusion = 0.0f;
    public float eyeRightOcclusion = 0.0f;
    public float mouthOcclusion = 0.0f;
    public PointF[] landmark;
    public boolean faceTooLarge = false;

    public String toString() {
        return "FaceInfo{faceSize=" + this.faceSize.toShortString() + ", position=" + this.position.toShortString() + ", yaw=" + this.yaw + ", pitch=" + this.pitch + ", gaussianBlur=" + this.gaussianBlur + ", motionBlur=" + this.motionBlur + ", brightness=" + this.brightness + ", wearGlass=" + this.wearGlass + ", faceQuality=" + this.faceQuality + ", leftEyeHWRatio=" + this.leftEyeHWRatio + ", rightEyeHWRatio=" + this.rightEyeHWRatio + ", mouthHWRatio=" + this.mouthHWRatio + '}';
    }

    public static class FaceInfoFactory {
        public static FaceInfo createFaceInfo(String string) {
            try {
                string = new JSONObject(string);
                if (!string.has("has_face") || !string.getBoolean("has_face")) {
                    return null;
                }
                FaceInfo faceInfo = new FaceInfo();
                JSONObject jSONObject = string.getJSONObject("pos");
                faceInfo.pitch = (float)jSONObject.getDouble("pitch");
                faceInfo.yaw = (float)jSONObject.getDouble("yaw");
                jSONObject = string.getJSONArray("facerect");
                RectF rectF = new RectF();
                new RectF().left = (float)jSONObject.getDouble(0);
                rectF.top = (float)jSONObject.getDouble(1);
                rectF.right = (float)jSONObject.getDouble(2);
                rectF.bottom = (float)jSONObject.getDouble(3);
                faceInfo.position = rectF;
                faceInfo.brightness = (float)string.getDouble("brightness");
                faceInfo.motionBlur = (float)string.getJSONObject("blurness").getDouble("motion");
                faceInfo.gaussianBlur = (float)string.getJSONObject("blurness").getDouble("gaussian");
                faceInfo.wearGlass = (float)string.getDouble("wearglass");
                faceInfo.pitch3d = string.getBoolean("pitch3d");
                string.getDouble("eye_hwratio");
                faceInfo.mouthHWRatio = (float)string.getDouble("mouth_hwratio");
                faceInfo.leftEyeHWRatio = (float)string.getDouble("eye_left_hwratio");
                faceInfo.rightEyeHWRatio = (float)string.getDouble("eye_right_hwratio");
                faceInfo.integrity = (float)string.getDouble("integrity");
                jSONObject = new Rect();
                new Rect().left = 0;
                jSONObject.top = 0;
                jSONObject.right = (int)string.getDouble("real_width");
                jSONObject.bottom = (int)string.getDouble("real_height");
                faceInfo.faceSize = jSONObject;
                faceInfo.smoothYaw = (float)string.getDouble("smooth_yaw");
                faceInfo.smoothPitch = (float)string.getDouble("smooth_pitch");
                faceInfo.notVideo = string.getBoolean("not_video");
                faceInfo.eyeBlink = string.getBoolean("eye_blink");
                faceInfo.mouthOpen = string.getBoolean("mouth_open");
                faceInfo.eyeLeftDet = (float)string.getDouble("eye_left_det");
                faceInfo.eyeRightDet = (float)string.getDouble("eye_right_det");
                faceInfo.mouthDet = (float)string.getDouble("mouth_det");
                faceInfo.faceQuality = (float)string.getDouble("quality");
                faceInfo.eyeLeftOcclusion = (float)string.getDouble("eye_left_occlusion");
                faceInfo.eyeRightOcclusion = (float)string.getDouble("eye_right_occlusion");
                faceInfo.mouthOcclusion = (float)string.getDouble("mouth_occlusion");
                jSONObject = string.getJSONArray("landmark");
                if (jSONObject.length() % 2 == 0) {
                    faceInfo.landmark = new PointF[jSONObject.length() / 2];
                    for (int i = 0; i < jSONObject.length() / 2; ++i) {
                        PointF pointF = new PointF();
                        new PointF().x = (float)jSONObject.getDouble(i);
                        pointF.y = (float)jSONObject.getDouble(i);
                    }
                }
                faceInfo.faceTooLarge = string.getBoolean("face_too_large");
                return faceInfo;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }
}

