package com.xdja.updatelibrary;

import android.content.Context;

import com.xdja.updatelibrary.data.ServerPathBean;
import com.xdja.updatelibrary.data.ServerPathInterface;

/**
 * Created by hyh on 2018/8/21.
 */

public class UpdateConfig {
    private Context context;

    private boolean isReadAssets;

    private boolean isStartLocalAlarm;
    private int hour;

    private int minute;

    private boolean isNeedBreakPointResume;

    private ServerPathBean serverPathBean;

    private ServerPathInterface serverPathInterface;

    UpdateConfig(Builder builder) {
        context = builder.context;
        isReadAssets = builder.isReadAssets;
        hour = builder.alarmHour;
        minute = builder.alarmMinute;
        isStartLocalAlarm = builder.isStartLocakAlarm;
        isNeedBreakPointResume = builder.isNeedBreakPointResume;
        serverPathBean = builder.serverPathBean;
        this.serverPathInterface = builder.serverPathInterface;
    }

    public Context getApplictionContext() {
        return context;
    }

    public boolean getIsReadAssets() {
        return isReadAssets;
    }

    public boolean isStartLocaLAlarm() {
        return isStartLocalAlarm;
    }

    public int getLocaLAlarmHour() {
        return hour;
    }

    public int getLocaLAlarmMinute() {
        return minute;
    }

    public boolean isNeedBreakPointResume() {
        return isNeedBreakPointResume;
    }

    public ServerPathBean getServerPathBean() {
        return serverPathBean;
    }

    public void setServerPathBean(ServerPathBean serverPathBean) {
        this.serverPathBean = serverPathBean;
    }

    public ServerPathInterface getServerPathInterface() {
        return serverPathInterface;
    }

    public static class Builder {
        Context context;

        boolean isReadAssets = false;

        boolean isStartLocakAlarm = true;

        int alarmHour = 9;

        int alarmMinute = 0;

        boolean isNeedBreakPointResume = false;

        ServerPathBean serverPathBean;

        ServerPathInterface serverPathInterface;

        public Builder(Context context) {
            this.context = context;
        }

        /**
         * 是否读取assets下面的文件来获取ip和端口
         *
         * @param isReadAssets
         * @return
         */
        public Builder configIsReadAssets(boolean isReadAssets) {
            this.isReadAssets = isReadAssets;
            return this;
        }

        /**
         * 是否启动闹钟提醒:默认启动
         */
        public Builder configIsStartLocalAlarmCheck(boolean isStart) {
            isStartLocakAlarm = isStart;
            return this;
        }

        /**
         * 设置闹钟每天启动时间:默认9：00
         */
        public Builder configLocalAlarmCheckTime(int hour, int minute) {
            alarmHour = hour;
            alarmMinute = minute;
            return this;
        }

        /**
         * 是否支持断点续传
         *
         * @return
         */
        public Builder configIsNeedBreakPointResume(boolean isNeedBreakPointResume) {
            this.isNeedBreakPointResume = isNeedBreakPointResume;
            return this;
        }

        /**
         * 服务器地址
         *
         * @return
         */
        public Builder configServerPath(ServerPathBean serverPathBean) {
            this.serverPathBean = serverPathBean;
            return this;
        }

        /**
         * 接口类型服务器地址
         *
         * @return
         */
        public Builder configServerPathInterface(ServerPathInterface serverPathInterface) {
            this.serverPathInterface = serverPathInterface;
            return this;
        }


        public UpdateConfig build() {
            return new UpdateConfig(this);
        }

    }
}
