package com.xdja.updatelibrary;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;

import com.xdja.update.UpdateManager;
import com.xdja.update.bean.CheckResult;
import com.xdja.updatelibrary.data.DialogCancelInterface;
import com.xdja.updatelibrary.data.UpdateInfo;
import com.xdja.updatelibrary.data.UpdateLoadingNotification;
import com.xdja.updatelibrary.utils.DialogUpdateUtil;
import com.xdja.updatelibrary.utils.UpdateSharePreferenceUtils;
import com.xdja.updatelibrary.widget.UpdateProgressDialog;

import java.lang.ref.WeakReference;

/**
 * 下载更新总入口
 * Created by hyh on 2018/5/4.
 */
public class XDJAUpdateExecutor implements XDJAUpdateService.UpdateInterface, DialogUpdateUtil.DialogUpdateInterface {
    private UpdateLoadingNotification mNotification;
    public static final int UPDATE_CLICK_CHECK = 1;//手动点击检查
    public static final int UPDATE_ALARM_CHECK = 2;//定期检查
    public static final int UPDATE_ONLY_CHECK = 3;//只检查不做处理
    private boolean mNoShowToast;//从应用首页进入的，不弹Toast
    private WeakReference<Context> mWeakReferenceContext;
    private int mUpdateType;
    //进度条dialog
    private UpdateProgressDialog mProgressDialog;
    private AlertDialog mCheckingDialog;

    /**
     * 是否是强制下载
     */
    private boolean mIsForceUpdate;

    public XDJAUpdateExecutor() {
    }

    public static XDJAUpdateExecutor getInstance() {
        return new XDJAUpdateExecutor();
    }


    /**
     * 这种情况是需要出现dialog提醒框，并且需要Toast提醒，检查更新
     */
    public void onCheckIsNeedUpdate(Context context) {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            mWeakReferenceContext = new WeakReference<Context>(context);
            mUpdateType = UPDATE_CLICK_CHECK;
            if (mWeakReferenceContext.get() != null) {
                mCheckingDialog = DialogUpdateUtil.showCheckLoading(mWeakReferenceContext.get());
                mCheckingDialog.show();
            }
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }

    }

    /**
     * 闹钟提醒检查升级
     */
    public void onLocalAlarmCheckUpdate() {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            mUpdateType = UPDATE_ALARM_CHECK;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    /**
     * 进入应用时，需要更新，弹出提醒框，但是不需要Toast
     */
    public void onForceShowUpdateDialog(Context context) {
        if (
//                UpdateSharePreferenceUtils.getIsUpdateState(context) &&
                !XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            mNoShowToast = true;
            mWeakReferenceContext = new WeakReference<Context>(context);
            mUpdateType = UPDATE_CLICK_CHECK;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    /**
     * 冷启动的时候，启动检查
     */
    public void onOnlyCheckUpdate() {
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            mUpdateType = UPDATE_ONLY_CHECK;
            XDJAUpdateService.getInstance().onStartCheckUpdate(this);
        }
    }

    private DialogCancelInterface mCancelInterface;

    /**
     * 点击通知栏进入activity更新界面，支持取消finish
     */
    public void onClickNotificationShowDialog(Context context, DialogCancelInterface dialogCancelInterface) {
        mCancelInterface = dialogCancelInterface;
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading()) {
            onCheckIsNeedUpdate(context);
        } else {
            onCancelInterface();
        }
    }

    /**
     * 下载apk文件
     */
    public void onDownloadUpdateFile(int updateType) {
        mUpdateType = updateType;
        if (!XDJAUpdateService.getInstance().isCheckingOrLoading() && UpdateSharePreferenceUtils.getIsUpdateState(UpdateManager.getInstance().getContext())) {
            boolean isError = XDJAUpdateService.getInstance().onDownLoadApkFile(this);
            if (isError) {
                onUpdateDownloadFailUi(true);
            }
        } else {
            onUpdateDownloadFailUi(false);
        }
    }

    /**
     * 取消下载
     */
    private void onCancelDownLoadUpdate() {
        XDJAUpdateService.getInstance().onStopLoad();
    }

    /**
     * 查询结果
     */
    @Override
    public void onUpdateCheckResult(String result, UpdateInfo info) {
        mIsForceUpdate = info.isForceUpdate();
        if (mCheckingDialog != null) {
            mCheckingDialog.dismiss();
            mCheckingDialog = null;
        }
        if (mUpdateType == UPDATE_ONLY_CHECK) {
            return;
        } else if (mUpdateType == UPDATE_CLICK_CHECK) {
            if (mWeakReferenceContext.get() == null) {
                return;
            }
            if (mWeakReferenceContext.get() instanceof Activity) {
                if (((Activity) mWeakReferenceContext.get()).isFinishing() || ((Activity) mWeakReferenceContext.get()).isDestroyed()) {
                    return;
                }
            }
            if (result.equals(CheckResult.RESULT_UPDATE_POSITIVE)) {
                DialogUpdateUtil.showUpdateDialog(mWeakReferenceContext.get(), info, this);
            } else if (result.equals(CheckResult.RESULT_UPDATE_NEGATIVE) && !mNoShowToast) {
                ModuleToast.showNoRepeat(mWeakReferenceContext.get(), mWeakReferenceContext.get().getResources().getString(R.string.update_check_newest));
                onCancelInterface();
            } else if (!mNoShowToast) {
                ModuleToast.showNoRepeat(mWeakReferenceContext.get(), mWeakReferenceContext.get().getResources().getString(R.string.update_check_error));
                onCancelInterface();
            }
        } else {
            if (result.equals(CheckResult.RESULT_UPDATE_POSITIVE)) {
                UpdateLoadingNotification.setConfigInstallRemindNf(info.isForceUpdate());
            }
        }
    }

    /**
     * 开始下载
     */
    @Override
    public void onUpdatedownloadStart() {
        mNotification = UpdateLoadingNotification.setConfigProgressNf();
    }

    /**
     * 下载进行中
     */
    @Override
    public void onUpdatedownloadProgress(long totalSize, long cSize) {
        int progress = Float.valueOf((((float) cSize / (float) totalSize) * 100)).intValue();
        if (mNotification != null) {
            mNotification.setProgress(progress);
        }
        if (mUpdateType == UPDATE_CLICK_CHECK) {
            if (mProgressDialog != null) {
                mProgressDialog.setProgress(progress);
            }
        }
    }

    /**
     * 下载成功
     */
    @Override
    public void onUpdatedownloadSuccess() {
        if (mNotification != null) {
            mNotification.cancelNotification();
        }
        onCancelInterface();
        onDismissProgressDialog();
    }

    /**
     * 下载失败
     */
    @Override
    public void onUpdatedownloadError() {
        onUpdateDownloadFailUi(true);
    }

    /**
     * 下载失败ui操作
     *
     * @param isShowErrDg
     */
    private void onUpdateDownloadFailUi(boolean isShowErrDg) {
        if (mNotification != null) {
            mNotification.cancelNotification();
            mNotification = null;
        }
        onDismissProgressDialog();
        if (mUpdateType == UPDATE_CLICK_CHECK && isShowErrDg) {
            if (mWeakReferenceContext.get() == null) return;
            DialogUpdateUtil.showDownLoadFailed(mWeakReferenceContext.get(), this);
        }
    }


//    /**
//     * 不是wife模式下载，提醒用户
//     */
//    private void onShowNoWifeDialog(Context context) {
//        DialogUpdateUtil.showNoWifeDialog(context, new DialogUpdateUtil.DialogUpdateInterface() {
//            @Override
//            public void onDgUpdateSuccess(Object... objects) {
//                onShowDownProgress();
//            }
//        });
//    }

    /**
     * 下载进度条展示并开始下载
     */
    private void onShowDownProgress() {
        if (mWeakReferenceContext.get() == null) return;
        mProgressDialog = new UpdateProgressDialog(mWeakReferenceContext.get());
        mProgressDialog.setDialogClickInterface(XDJAUpdateExecutor.this);
        mProgressDialog.setIsForceUpdate(mIsForceUpdate);
        mProgressDialog.show();
        onDownloadUpdateFile(mUpdateType);
    }

    private void onDismissProgressDialog() {
        if (mProgressDialog != null && mProgressDialog.isShowing()) {
            mProgressDialog.dismiss();
            mProgressDialog = null;
        }
    }

    @Override
    public void onDgUpdateSuccess(String result) {
        if (result != null) {
            if (result.equals(UpdateProgressDialog.CANCEL_DOWNLOAD)) {//结束下载
                onUpdateDownloadFailUi(true);
                onCancelDownLoadUpdate();
            } else if (result.equals(DialogUpdateUtil.DIALOG_DOWNLOAD_OK)) {//下载
                onShowDownProgress();
            } else if (result.equals(DialogUpdateUtil.DIALOG_CANCEL)) {//取消dialog
                onCancelInterface();
            }
        }
    }

    private void onCancelInterface() {
        if (mCancelInterface != null) {
            mCancelInterface.onFinshActivity();
            mCancelInterface = null;
        }
    }


}
