package com.xdja.updatelibrary;

import android.content.Context;
import android.util.Log;

import com.xdja.update.UpdateManager;
import com.xdja.updatelibrary.data.ServerPathInterface;
import com.xdja.updatelibrary.utils.UpdateAlarmUtils;

/**
 * 配置
 * Created by hyh on 2018/5/4.
 */
public class XDJAUpdateManager {

    static UpdateConfig config;

    /**
     * 升级检测协议ip和端口
     *
     * @return
     */
    public static void onConfigCheckProtocol(ServerPathInterface serverPath) {
        XDJAUpdateManager.config.setServerPathBean(serverPath.getServerPath());
    }

    /**
     * 配置基本的升级
     *
     * @param config
     */
    public static void init(UpdateConfig config) {
        XDJAUpdateManager.config = config;
        if (config != null) {
            UpdateManager.getInstance().install(config.getApplictionContext());
            if (config.getServerPathInterface() != null) {
                onConfigCheckProtocol(config.getServerPathInterface());
            } else {
                onConfigCheckProtocol(ServerPathInterface.DEFAULT_SERVERPATH);
            }
            if (config.isStartLocaLAlarm()) {
                UpdateAlarmUtils.setLocalAlarm(UpdateManager.getInstance().getContext(), config.getLocaLAlarmHour(), config.getLocaLAlarmMinute(), 1);
            }
        } else {
            Log.e("XDJAUpdateManager", "升级配置为空");
        }
    }

    /**
     * 此方法属安全接入重载，方便反射调用
     *
     * @param context
     */
    public static void init(Context context) {
        UpdateConfig config = new UpdateConfig.Builder(context).configIsReadAssets(true).build();
        XDJAUpdateManager.init(config);
    }


    public static UpdateConfig getConfig() {
        if (config == null) {
            throw new IllegalStateException("Configuration is not initialized. " +
                    "Please call init(FlowConfig) in your application class.");
        }
        return config;
    }
}
