package com.xdja.updatelibrary.data;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.os.Build;

import com.xdja.update.UpdateManager;
import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.activtiy.UpgradeShowActivity;
import com.xdja.updatelibrary.receive.UpdateclockReceive;
import com.xdja.updatelibrary.utils.AppUtil;


/**
 * Created by hyh on 2018/5/3.
 */

public class UpdateLoadingNotification {
    static final int UPDATE_NOTIFY_ID = 200;

    String content;

    String title;

    int resSmallIcon;
    int resLargeIcon;
    boolean forceUpdate;

    int notifyId;
    boolean isProgress;
    boolean enableNotify;
    boolean autoCancel;
    private Notification.Builder mNbuilder;
    private static final String UPDATE_CHANNEL_ID = "NOTIFY_UPDATE_ID";
    private static final String UPDATE_CHANNEL_NAME = "升级通知栏";

    public UpdateLoadingNotification() {
    }

    public UpdateLoadingNotification(Builder builder) {
        content = builder.content;
        title = builder.title;
        resSmallIcon = builder.resSmallIcon;
        notifyId = builder.notifyId;
        enableNotify = builder.enableNotify;
        isProgress = builder.isProgress;
        autoCancel = builder.autoCancel;
        resLargeIcon = builder.resLargeIcon;
        forceUpdate = builder.forceUpdate;
    }

    public void showNotification(UpdateLoadingNotification notification) {
        Context context = UpdateManager.getInstance().getContext();
        if (!notification.enableNotify) return;
        mNbuilder = new Notification.Builder(context);
        // mNbuilder = new NotificationCompat.Builder(context);
        mNbuilder.setContentTitle(notification.title);
        mNbuilder.setContentText(notification.content);
        mNbuilder.setTicker(notification.content);
        mNbuilder.setSmallIcon(notification.resSmallIcon);
        mNbuilder.setLargeIcon(BitmapFactory.decodeResource(context.getResources(), notification.resLargeIcon));
        mNbuilder.setAutoCancel(notification.autoCancel);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            createNotificationChannel(context, UPDATE_CHANNEL_ID, UPDATE_CHANNEL_NAME);
            mNbuilder.setChannelId(UPDATE_CHANNEL_ID);
        }
        if (notification.isProgress) {
            mNbuilder.setProgress(100, 0, false);
            getNotificationManager().notify(UPDATE_NOTIFY_ID, mNbuilder.build());
        } else {
            PendingIntent intent;
            if (notification.forceUpdate) {
                intent = getReceiveIntent(context);
            } else {
                intent = getActivityIntent(context);
            }
            mNbuilder.setContentIntent(intent);
            getNotificationManager().notify(UPDATE_NOTIFY_ID, mNbuilder.build());
        }
    }

    private static void createNotificationChannel(Context context, String id, String name) {
        NotificationManager manager = (NotificationManager) context.getSystemService(Context.NOTIFICATION_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            NotificationChannel channel = new NotificationChannel(id, name, NotificationManager.IMPORTANCE_LOW);
            if (manager != null) {
                channel.setSound(null,null);
                manager.createNotificationChannel(channel);
            }
        }
    }

    /**
     * 点击通知栏直接下载
     */
    private PendingIntent getReceiveIntent(Context context) {
        Intent intent = new Intent(context, UpdateclockReceive.class);
        intent.putExtra(UpdateclockReceive.RECEIVER_TYPE, UpdateclockReceive.RECEIVER_INSTALL_TYPE);
        PendingIntent clickIntent = PendingIntent.getBroadcast(context, 1, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        return clickIntent;
    }

    /**
     * 点击通知栏进入更新页，用户点击下载
     */
    private PendingIntent getActivityIntent(Context context) {
        Intent intent = new Intent(context, UpgradeShowActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        PendingIntent pendingIntent = PendingIntent.getActivity(context, 1, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        return pendingIntent;
    }

    public void setProgress(int progress) {
        if (mNbuilder != null && getNotificationManager() != null) {
            mNbuilder.setProgress(100, progress, false);
            getNotificationManager().notify(UPDATE_NOTIFY_ID, mNbuilder.build());
        }
    }

    public void cancelNotification() {
        getNotificationManager().cancel(UPDATE_NOTIFY_ID);
    }

    //获取系统服务
    private NotificationManager mNotificationManager;

    private NotificationManager getNotificationManager() {
        if (mNotificationManager == null) {
            mNotificationManager = (NotificationManager) UpdateManager.getInstance().getContext().getSystemService(Context.NOTIFICATION_SERVICE);
        }
        return mNotificationManager;
    }

    /**
     * 配置有进度条的通知
     */
    public static UpdateLoadingNotification setConfigProgressNf() {
        Builder builder = onConfigCommonNf(R.string.update_notification_title, R.string.update_notification_content);
        builder.setIsProgress(true);
        UpdateLoadingNotification mNotification = builder.builder();
        mNotification.showNotification(mNotification);
        return mNotification;
    }

    /**
     * 配置提醒下载通知
     */
    public static void setConfigInstallRemindNf(boolean isForceUpdate) {
        Builder builder = onConfigCommonNf(R.string.update_notification_insatll_title, R.string.update_notification_insatll_content);
        builder.setForceUpdate(isForceUpdate);
        builder.setIsProgress(false);
        UpdateLoadingNotification mNotification = builder.builder();
        mNotification.showNotification(mNotification);
    }

    private static Builder onConfigCommonNf(int titleId, int contentId) {
        Context context = UpdateManager.getInstance().getContext();
        Builder builder = new Builder();
        builder.setTitle(String.format(context.getResources().getString(titleId), AppUtil.getProjectName(context)));
        String content = String.format(context.getResources().getString(contentId), AppUtil.getProjectName(context));
        builder.setContent(content);
        builder.setResSmallIcon(R.drawable.notify_icon);
        builder.setResLargeIcon(R.drawable.notify_icon);
        builder.setEnableNotify(true);
        return builder;
    }

    public static class Builder {
        String content;

        String title;

        int resSmallIcon;

        int notifyId;
        boolean enableNotify;
        /**
         * 是否是带有进度条的通知
         */
        boolean isProgress;
        boolean autoCancel;
        int resLargeIcon;
        boolean forceUpdate;

        public Builder() {
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setResSmallIcon(int resSmallIcon) {
            this.resSmallIcon = resSmallIcon;
            return this;
        }

        public Builder setNotifyId(int notifyId) {
            this.notifyId = notifyId;
            return this;
        }

        public Builder setEnableNotify(boolean enableNotify) {
            this.enableNotify = enableNotify;
            return this;
        }

        public Builder setIsProgress(boolean isProgress) {
            this.isProgress = isProgress;
            return this;
        }

        public Builder setAutoCancel(boolean autoCancel) {
            this.autoCancel = autoCancel;
            return this;
        }

        public Builder setResLargeIcon(int resId) {
            this.resLargeIcon = resId;
            return this;
        }

        public Builder setForceUpdate(boolean forceUpdate) {
            this.forceUpdate = forceUpdate;
            return this;
        }

        public UpdateLoadingNotification builder() {
            return new UpdateLoadingNotification(this);
        }
    }
}
