package com.xdja.updatelibrary.utils;

import android.content.Context;
import android.content.pm.PackageManager;

/**
 * Created by wanghao on 2016/11/23.
 * 当前文件旨在定义app本身的辅助工具
 */
public class AppUtil {

    public static final String TAG = "safeclient";

    /**
     * 获取当前app对应的版本名称
     *
     * @return String 返回当前应用的版本名称，不会为null
     */
    public static String getCurrentVersion(Context context) {
        String versionName = "";
        try {
            versionName = context.getPackageManager().getPackageInfo(context.getPackageName(), 0).versionName;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return versionName;
    }

    /**
     * 获取当前app绝对路径
     *
     * @return
     */
    public static String getAppAbsolutePath(Context context) {
        return context.getFilesDir().getPath();
    }

    /**
     * 获取app包名
     *
     * @param context
     * @return
     */
    public static String getPackageName(Context context) {
        return context.getPackageName();
    }
    /**
     * 获取项目的名称
     */
    public static String getProjectName(Context context) {
       PackageManager pm= context.getPackageManager();
        return  context.getApplicationInfo().loadLabel(pm).toString();
    }
}
