package com.xdja.updatelibrary.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.updatelibrary.data.UpdateInfo;

import com.xdja.updatelibrary.R;

/**
 * Created by hyh on 2018/5/3
 */
public class DialogUpdateUtil {

    public interface DialogUpdateInterface {
        void onDgUpdateSuccess(String result);
    }

    public static AlertDialog showCheckLoading(Context context) {
        AlertDialog connectDialog = new AlertDialog.Builder(context, R.style.UpdateLibDialogTheme).create();
        View view = LayoutInflater.from(context).inflate(R.layout.dialog_checking_progress, null);
        ImageView mConnectingView = (ImageView) view.findViewById(R.id.iv_loading);
        Animation rotateAnimation = AnimationUtils.loadAnimation(context, R.anim.rotate_anim);
        mConnectingView.startAnimation(rotateAnimation);
        connectDialog.setView(view);
        return connectDialog;
    }

    public static final String DIALOG_CANCEL = "dialog_cancel";//取消dialog
    public static final String DIALOG_DOWNLOAD_OK = "dialog_download_ok";//下载apk

    public static void showUpdateDialog(final Context context, UpdateInfo updateInfo, final DialogUpdateInterface result) {
        final AlertDialog dialog = new AlertDialog.Builder(new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        View view = LayoutInflater.from(context).inflate(R.layout.update_dialog, null, false);
        dialog.setView(view);

        boolean forceUpdate = updateInfo.isForceUpdate();

        TextView title = (TextView) view.findViewById(R.id.title);
        title.setText(forceUpdate ? R.string.dg_update_force_update : R.string.dg_update_new_version);

        TextView version = (TextView) view.findViewById(R.id.version_code);
        version.setText(String.format(context.getResources().getString(R.string.update_version), updateInfo.getVersion()));

        TextView info = (TextView) view.findViewById(R.id.version_desc);
        info.setText(updateInfo.getInfo());

        Button positive = (Button) view.findViewById(R.id.dialog_positive);
        positive.setText(R.string.dg_update_update_now);
        positive.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DIALOG_DOWNLOAD_OK);
            }
        });

        Button negative = (Button) view.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_update_remind_later);
        negative.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DIALOG_CANCEL);
            }
        });

        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        negative.setVisibility(forceUpdate ? View.GONE : View.VISIBLE);
        dialog.show();
    }

    public static void showNoWifeDialog(Context context, DialogUpdateInterface updateInterface) {
        final AlertDialog dialog = new AlertDialog.Builder(new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        View view = LayoutInflater.from(context).inflate(R.layout.nowife_dialog, null, false);
        dialog.setView(view);
        dialog.show();
    }

    /**
     * 下载失败
     */
    public static void showDownLoadFailed(Context context, final DialogUpdateInterface result) {
        if (((Activity) context).isDestroyed() || ((Activity) context).isFinishing()) {
            return;
        }
        final AlertDialog dialog = new AlertDialog.Builder(new ContextThemeWrapper(context, R.style.UpdateLibDialogTheme)).create();
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        View view = LayoutInflater.from(context).inflate(R.layout.download_failed_dialog, null, false);
        dialog.setView(view);

        Button positive = (Button) view.findViewById(R.id.dialog_positive);
        positive.setVisibility(View.GONE);
        Button negative = (Button) view.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_update_fail_ok);
        negative.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                dialog.cancel();
                result.onDgUpdateSuccess(DIALOG_CANCEL);
            }
        });
        dialog.show();
    }

}
