package com.xdja.updatelibrary.utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import com.xdja.updatelibrary.data.UpOperationInterface;
import com.xdja.updatelibrary.data.UpdatePushOperation;
import com.xdja.updatelibrary.receive.UpdateclockReceive;

import java.util.Calendar;

/**
 * Created by admin on 2017/4/11.
 */

public class UpdateAlarmUtils {
    private static final int INTERVAL = 1000 * 60 * 60 * 24;// 24h
    public static UpOperationInterface OPERATION = null;

    public static void sendPushData(int type) {
        if (OPERATION == null) {
            OPERATION = new UpdatePushOperation();
        }
        OPERATION.onSendUpdateMessage(type);
    }

    /**
     * @param context
     * @param hour
     * @param minute
     * @param type    闹钟类型，可以设置不同的值来标识不同时段的闹钟
     */
    public static void setLocalAlarm(Context context, int hour, int minute, int type) {
        initAlarm(context, hour, minute, type);
    }

    public static void setUpOperationInterface(UpOperationInterface operation) {
        OPERATION = operation;
    }

    private static void initAlarm(Context context, int hour, int minute, int type) {
        AlarmManager alarmService = (AlarmManager) context.getSystemService(context.ALARM_SERVICE);
        Calendar instance = Calendar.getInstance();
        instance.set(Calendar.HOUR_OF_DAY, hour);
        instance.set(Calendar.MINUTE, minute);
        instance.set(Calendar.SECOND, 0);
        Intent alarmIntent = new Intent(context, UpdateclockReceive.class);
        alarmIntent.putExtra(UpdateclockReceive.RECEIVER_TYPE, UpdateclockReceive.RECEIVER_ALARM_TYPE);
        PendingIntent broadcast = PendingIntent.getBroadcast(context, type, alarmIntent, PendingIntent.FLAG_CANCEL_CURRENT);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            alarmService.setWindow(AlarmManager.RTC_WAKEUP, calMethod(instance.getTimeInMillis()), INTERVAL, broadcast);
        } else {
            alarmService.setRepeating(AlarmManager.RTC_WAKEUP, calMethod(instance.getTimeInMillis()), INTERVAL, broadcast);
        }

    }


    private static long calMethod(long dateTime) {
        long time = 0;
        if (dateTime > System.currentTimeMillis()) {
            time = dateTime;
        } else {
            time = dateTime + 24 * 3600 * 1000;
        }
        return time;
    }
}
