package com.xdja.updatelibrary.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.xdja.updatelibrary.data.UpdateInfo;

/**
 * Created by hyh on 2018/5/7.
 */

public class UpdateSharePreferenceUtils {
    private static final String UPDATE_REMIND = "update_remind";
    private static final String VERSION = "version";
    private static final String INFO = "info";
    private static final String FORCEUPDATE = "forceUpdate";

    public static void onChangeUpdateState(Context context, UpdateInfo info) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(VERSION, info.getVersion());
        editor.putString(INFO, info.getInfo());
        editor.putBoolean(FORCEUPDATE, info.isForceUpdate());
        editor.commit();
    }

    /**
     * 获取是否需要升级
     */
    public static boolean getIsUpdateState(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, Context.MODE_PRIVATE);
        if (AppUtil.getCurrentVersion(context).equals(preferences.getString(VERSION, AppUtil.getCurrentVersion(context)))) {
            return false;
        }
        return true;
    }

    public static UpdateInfo getUpdateMessage(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, Context.MODE_PRIVATE);
        UpdateInfo info = new UpdateInfo();
        info.setVersion(preferences.getString(VERSION, AppUtil.getCurrentVersion(context)));
        info.setInfo(preferences.getString(INFO, ""));
        info.setForceUpdate(preferences.getBoolean(FORCEUPDATE, false));
        return info;
    }

    public static void onChangeVersion(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(UPDATE_REMIND, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(VERSION, AppUtil.getCurrentVersion(context));
        editor.commit();
    }

}
