package com.xdja.updatelibrary.widget;

import android.app.Dialog;
import android.app.WallpaperManager;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;

import com.xdja.updatelibrary.R;
import com.xdja.updatelibrary.utils.DensityUtil;
import com.xdja.updatelibrary.utils.DialogUpdateUtil;


/**
 * Created by hyh on 2018/5/2.
 */

public class UpdateProgressDialog extends Dialog {
    public static final String CANCEL_DOWNLOAD = "cancel_download";
    private View mView;
    private ProgressBar mProgressBar;
    private static final int RESID = R.style.UpdateLibDialogTheme;
    public DialogUpdateUtil.DialogUpdateInterface mInterface;
    private View mBottomView;

    public UpdateProgressDialog(@NonNull Context context) {
        super(context, RESID);
        initView();
    }

    public UpdateProgressDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        initView();
    }

    public void setDialogClickInterface(DialogUpdateUtil.DialogUpdateInterface updateInterface) {
        mInterface = updateInterface;
    }

    public void setIsForceUpdate(boolean isForceUpdate) {
        if (mBottomView == null) return;
        mBottomView.setVisibility(isForceUpdate ? View.GONE : View.VISIBLE);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(mView);
        setCanceledOnTouchOutside(false);
        setCancelable(false);

    }

    private void initView() {
        mView = LayoutInflater.from(getContext()).inflate(R.layout.update_progress, null);
        mProgressBar = (ProgressBar) mView.findViewById(R.id.pb_download);
        Button positive = (Button) mView.findViewById(R.id.dialog_positive);
        positive.setVisibility(View.GONE);
        Button negative = (Button) mView.findViewById(R.id.dialog_negative);
        negative.setText(R.string.dg_cancel_downloan);
        negative.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (mInterface != null) {
                    mInterface.onDgUpdateSuccess(CANCEL_DOWNLOAD);
                }
            }
        });
        mBottomView = mView.findViewById(R.id.include_bottom);
        LinearLayout linear = (LinearLayout) mView.findViewById(R.id.linear_update_progress);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) linear.getLayoutParams();
        layoutParams.width = (int) (DensityUtil.getScreenWidth(getContext()) * 0.9);
        linear.setLayoutParams(layoutParams);
    }

    public void setProgress(int progress) {
        if (mProgressBar != null) {
            mProgressBar.setProgress(progress);
        }
    }
}
