/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.updatelibrary;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.update.CheckCallback;
import com.xdja.update.CheckTask;
import com.xdja.update.DownloadCallback;
import com.xdja.update.UpdateManager;
import com.xdja.update.bean.CheckResult;
import com.xdja.update.enums.DownLoadFileError;
import com.xdja.updatelibrary.XDJAUpdateManager;
import com.xdja.updatelibrary.data.UpdateInfo;
import com.xdja.updatelibrary.utils.UpdateSharePreferenceUtils;
import java.io.File;
import java.io.IOException;

public class XDJAUpdateService
implements CheckCallback {
    private static XDJAUpdateService mXdjaUpdate = null;
    private CheckResult mCheckResult;
    private UpdateInterface mUpdateInterface;
    private boolean mIsCheckingOrLoading;

    private XDJAUpdateService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XDJAUpdateService getInstance() {
        if (mXdjaUpdate != null) return mXdjaUpdate;
        Class<XDJAUpdateService> clazz = XDJAUpdateService.class;
        synchronized (XDJAUpdateService.class) {
            if (mXdjaUpdate != null) return mXdjaUpdate;
            mXdjaUpdate = new XDJAUpdateService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mXdjaUpdate;
        }
    }

    public void onStartCheckUpdate(UpdateInterface updateInterface) {
        this.mUpdateInterface = updateInterface;
        this.mIsCheckingOrLoading = true;
        if (XDJAUpdateManager.getConfig().getIsReadAssets()) {
            UpdateManager.getInstance().checkUpdate((CheckCallback)this);
        } else if (XDJAUpdateManager.getConfig().getServerPathBean() == null) {
            CheckResult result = new CheckResult();
            result.setResult("-1");
            this.onCheckResult(result);
        } else {
            UpdateManager.getInstance().checkUpdate((CheckCallback)this, XDJAUpdateManager.getConfig().getServerPathBean().getServerIp(), XDJAUpdateManager.getConfig().getServerPathBean().getServerPort());
        }
    }

    public void onChecking() {
        this.mIsCheckingOrLoading = true;
    }

    public void onCheckResult(@NonNull CheckResult checkResult) {
        Log.i((String)CheckTask.TAG, (String)("result=" + checkResult.toString()));
        this.mIsCheckingOrLoading = false;
        this.mCheckResult = checkResult;
        UpdateInfo updateInfo = new UpdateInfo();
        if (this.mCheckResult.getResult().equals("0")) {
            updateInfo.setVersion(((CheckResult.Update)checkResult.getUpdates().get(0)).getVersion());
            updateInfo.setInfo(((CheckResult.Update)checkResult.getUpdates().get(0)).getComment());
            if (((CheckResult.Update)checkResult.getUpdates().get(0)).getUpdateTag() == 0) {
                updateInfo.setForceUpdate(false);
            } else {
                updateInfo.setForceUpdate(true);
            }
            updateInfo.setUpdate(true);
            UpdateSharePreferenceUtils.onChangeUpdateState(UpdateManager.getInstance().getContext(), updateInfo);
        } else if (this.mCheckResult.getResult().equals("1")) {
            UpdateSharePreferenceUtils.onChangeVersion(UpdateManager.getInstance().getContext());
        }
        if (this.mUpdateInterface != null) {
            this.mUpdateInterface.onUpdateCheckResult(checkResult.getResult(), updateInfo);
            this.onReleaseResource();
        }
    }

    public boolean onDownLoadApkFile(UpdateInterface updateInterface) {
        this.mUpdateInterface = updateInterface;
        if (this.mCheckResult == null || !this.mCheckResult.getResult().equals("0") || this.mCheckResult.getUpdates() == null || this.mCheckResult.getUpdates().size() == 0 || ((CheckResult.Update)this.mCheckResult.getUpdates().get(0)).getFiles() == null || ((CheckResult.Update)this.mCheckResult.getUpdates().get(0)).getFiles().size() == 0) {
            return true;
        }
        UpdateManager.getInstance().downloadFile((CheckResult.Update.File)((CheckResult.Update)this.mCheckResult.getUpdates().get(0)).getFiles().get(0), new DownloadCallback(){

            public void onStart(@NonNull String fileId) {
                XDJAUpdateService.this.mIsCheckingOrLoading = true;
                if (XDJAUpdateService.this.mUpdateInterface != null) {
                    XDJAUpdateService.this.mUpdateInterface.onUpdatedownloadStart();
                }
                XDJAUpdateService.this.onDeleteUnFinishedApkFile(XDJAUpdateService.this.getDownLoadApkPath(this.downloadDir(), fileId), (CheckResult.Update.File)((CheckResult.Update)XDJAUpdateService.this.mCheckResult.getUpdates().get(0)).getFiles().get(0));
            }

            public void onProgress(@NonNull String fileId, long totalSize, long cSize) {
                if (XDJAUpdateService.this.mUpdateInterface != null) {
                    XDJAUpdateService.this.mUpdateInterface.onUpdatedownloadProgress(totalSize, cSize);
                }
            }

            public void onStop(@NonNull String fileId) {
                XDJAUpdateService.this.mIsCheckingOrLoading = false;
                XDJAUpdateService.this.onDeleteApkFile(XDJAUpdateService.this.getDownLoadApkPath(this.downloadDir(), fileId));
                XDJAUpdateService.this.mCheckResult = null;
                XDJAUpdateService.this.onReleaseResource();
            }

            public void onError(@NonNull String fileId, @Nullable DownLoadFileError errorMsg, @Nullable Exception ex) {
                XDJAUpdateService.this.mIsCheckingOrLoading = false;
                XDJAUpdateService.this.onDeleteApkFile(XDJAUpdateService.this.getDownLoadApkPath(this.downloadDir(), fileId));
                if (XDJAUpdateService.this.mUpdateInterface != null) {
                    XDJAUpdateService.this.mUpdateInterface.onUpdatedownloadError();
                }
                XDJAUpdateService.this.mCheckResult = null;
                XDJAUpdateService.this.onReleaseResource();
            }

            public void onComplete(@NonNull String fileId, @NonNull String filePath) {
                XDJAUpdateService.this.mIsCheckingOrLoading = false;
                if (XDJAUpdateService.this.mUpdateInterface != null) {
                    XDJAUpdateService.this.mUpdateInterface.onUpdatedownloadSuccess();
                }
                XDJAUpdateService.this.onInstallApk(filePath, UpdateManager.getInstance().getContext());
                XDJAUpdateService.this.onReleaseResource();
            }

            public int unit() {
                return 0x100000;
            }

            @NonNull
            public String downloadDir() {
                return UpdateManager.getInstance().getContext().getExternalFilesDir(Environment.DIRECTORY_DOWNLOADS).getPath();
            }
        });
        return false;
    }

    public void onStopLoad() {
        this.mIsCheckingOrLoading = false;
        UpdateManager.getInstance().stopDownload();
    }

    public boolean isCheckingOrLoading() {
        return this.mIsCheckingOrLoading;
    }

    private void onInstallApk(String filePath, Context context) {
        File file = new File(filePath);
        if (file.exists()) {
            Intent intent = new Intent("android.intent.action.VIEW");
            if (Build.VERSION.SDK_INT >= 24) {
                intent.addFlags(1);
                String auth = "com.xdja.aircert.fileprovider";
                Uri uri = FileProvider.getUriForFile((Context)context, (String)auth, (File)file);
                intent.setDataAndType(uri, "application/vnd.android.package-archive");
            } else {
                intent.setDataAndType(Uri.fromFile((File)file), "application/vnd.android.package-archive");
            }
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    private void onDeleteUnFinishedApkFile(String path, CheckResult.Update.File file) {
        if (!XDJAUpdateManager.getConfig().isNeedBreakPointResume()) {
            try {
                File targetFile = new File(path);
                long offset = this.getOffset(targetFile);
                if (offset < file.getfSize() - 1L) {
                    this.onDeleteApkFile(path);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private long getOffset(File of) throws IOException {
        long offset = 0L;
        if (!of.exists()) {
            if (!of.createNewFile()) {
                // empty if block
            }
        } else {
            offset = of.length() - 1L;
        }
        return offset < 0L ? 0L : offset;
    }

    private void onDeleteApkFile(String fileName) {
        File file;
        if (!XDJAUpdateManager.getConfig().isNeedBreakPointResume() && !TextUtils.isEmpty((CharSequence)fileName) && (file = new File(fileName)).exists()) {
            file.delete();
        }
    }

    private String getDownLoadApkPath(String path, String fileId) {
        StringBuilder builder = new StringBuilder();
        builder.append(path).append("/").append(fileId).append(".apk");
        return builder.toString();
    }

    private void onReleaseResource() {
        if (this.mUpdateInterface != null) {
            this.mUpdateInterface = null;
        }
    }

    public static interface UpdateInterface {
        public void onUpdateCheckResult(String var1, UpdateInfo var2);

        public void onUpdatedownloadStart();

        public void onUpdatedownloadProgress(long var1, long var3);

        public void onUpdatedownloadSuccess();

        public void onUpdatedownloadError();
    }
}

