/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.cluster.ha;

import com.weibo.api.motan.cluster.LoadBalance;
import com.weibo.api.motan.cluster.ha.AbstractHaStrategy;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.Referer;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.List;

@SpiMeta(name="failover")
public class FailoverHaStrategy<T>
extends AbstractHaStrategy<T> {
    protected ThreadLocal<List<Referer<T>>> referersHolder = new ThreadLocal<List<Referer<T>>>(){

        @Override
        protected List<Referer<T>> initialValue() {
            return new ArrayList();
        }
    };

    @Override
    public Response call(Request request, LoadBalance<T> loadBalance) {
        List<Referer<T>> referers = this.selectReferers(request, loadBalance);
        if (referers.isEmpty()) {
            throw new MotanServiceException(String.format("FailoverHaStrategy No referers for request:%s, loadbalance:%s", request, loadBalance));
        }
        URL refUrl = referers.get(0).getUrl();
        int tryCount = refUrl.getMethodParameter(request.getMethodName(), request.getParamtersDesc(), URLParamType.retries.getName(), URLParamType.retries.getIntValue());
        if (tryCount < 0) {
            tryCount = 0;
        }
        for (int i = 0; i <= tryCount; ++i) {
            Referer<T> refer = referers.get(i % referers.size());
            try {
                request.setRetries(i);
                return refer.call(request);
            }
            catch (RuntimeException e) {
                if (ExceptionUtil.isBizException(e)) {
                    throw e;
                }
                if (i >= tryCount) {
                    throw e;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                LoggerUtil.warn(String.format("FailoverHaStrategy Call false for request:%s error=%s", request, e.getMessage()));
                continue;
            }
        }
        throw new MotanFrameworkException("FailoverHaStrategy.call should not come here!");
    }

    protected List<Referer<T>> selectReferers(Request request, LoadBalance<T> loadBalance) {
        List<Referer<T>> referers = this.referersHolder.get();
        referers.clear();
        loadBalance.selectToHolder(request, referers);
        return referers;
    }
}

