package com.fri;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Bitmap.Config;


public class HexManager {

	/**
	 * @description : 进行properties文件的写数据存储
	 * @param fileName
	 *            ： 要保存的文件路径
	 * @param dir
	 *            : 文件保存的文件名的路径
	 * @param properties
	 *            ： properties数据
	 * @return ： null
	 */
	public static void saveConfig(String dir, String fileName,
			Properties properties) {

		try {
			// File fileDir = new File(dir);
			// fileDir.mkdir();
			String localFile = dir + "/" + fileName;
			FileOutputStream s = new FileOutputStream(localFile, false);
			properties.store(s, "");
		} catch (Exception e) {
//			e.printStackTrace();
		}
	}

	/**
	 * @description : 进行properties文件的读数据存储
	 * @param file
	 *            ： 要保存的文件路径
	 * @return ： Properties 数据 ： null 文件不存在
	 */
	public static Properties loadConfig(String file) {
		Properties properties = new Properties();
		File afile = new File(file);
		try {
			if (!afile.exists()) {
				return null;
			} else {

			}// end if(!afile.exists())

			FileInputStream s = new FileInputStream(file);
			properties.load(s);

		} catch (Exception e) {
//			e.printStackTrace();
		}
		return properties;
	}

	/**
	 * @description 删除文件夹以及文件夹下面所有的文件
	 * @param foldPath
	 *            文件夹路径
	 * @return boolean true 删除成功 false 删除失败
	 * */
	public static boolean delFoldAndFile(String foldPath) {
		// printLog.print("开始删除文件夹  " + foldPath);
		File file = new File(foldPath);
		boolean localState = false;

		try {
			if (file.exists()) {
				// 判断文件是否存在
				if (file.isFile()) { // 判断是否是文件
					file.delete(); // delete()方法 你应该知道 是删除的意思;
				} else if (file.isDirectory()) // 否则如果它是一个目录
				{
					File files[] = file.listFiles(); // 声明目录下所有的文件 files[];

					for (int i = 0; i < files.length; i++) // 遍历目录下所有的文件
					{
						delFile(files[i]); // 把每个文件 用这个方法进行迭代
					}
				}
				localState = file.delete();
			} else {
				System.out.println("所删除的文件不存在！" + '\n');
			}
		} catch (Exception e) {
			// printLog.print("删除文件夹时发生异常");
//			e.printStackTrace();
		}

		return localState;

	}

	private static void delFile(File file) {
		try {
			if (file.isFile()) {
				file.delete();
			} else {

			}
		} catch (Exception e) {
			// printLog.print("删除文件时发生异常");
//			e.printStackTrace();
		}

	}

	/**
	 * @author : tangzhi
	 * @param int : mInt 整形数
	 * @return String ：4字节的16进制字符数据
	 * @description : 整形数据转换为4字节的16进制数据,高字节在前，byte[0]-高8位，byte[3]-低8位
	 * 
	 * 
	 * 
	 */
	public static String IntToByteHex(int mInt) {
		String localString = null;
		int localInt = mInt;
		byte localbyte[] = new byte[4];

		for (int k = 0; k < 4; k++) {

			localbyte[3 - k] = (byte) ((localInt >> (k * 8)) & (0xff));

		}
		localString = bytesToHex(localbyte);
		return localString;
	}

	/**
	 * @author : tangzhi
	 * @param int : mInt 整形数
	 * @return String ：4字节的16进制字符数据
	 * @description : 整形数据转换为4字节的16进制数据,高字节在前，byte[0]-高8位，byte[3]-低8位
	 * 
	 * 
	 * 
	 */
	public static String IntToByteOneHex(int mInt) {
		String localString = null;
		int localInt = mInt;
		byte localbyte[] = new byte[1];
		localbyte[0] = (byte) localInt;
		localString = bytesToHex(localbyte);
		return localString;
	}

	/**
	 * @author : tangzhi
	 * @param byte [] : 待组合字节数
	 * @return int ：返回组合后的整形数
	 * @description : 4字节的16进制数据转换为整形数据
	 * 
	 * 
	 */
	public static int ByteToIntHex(byte[] mbyte) {

		int localInt = 0;
		byte localbyte[] = new byte[4];
		System.arraycopy(mbyte, 0, localbyte, 0, mbyte.length);

		for (int k = 0; k < 4; k++) {
			int temp = 0;

			localInt &= (0xFFFFFF00);
			temp = ((int) localbyte[k]) & (0x000000FF);
			localInt |= temp;
			System.out.printf("\nlocalInt = 0x%x", localInt);

			if (k < 3)
				localInt = (localInt << (8));

			// localInt |= (((localInt << (k * 8)) & (0x00)) |
			// (((int)localbyte[k]) & (0x000000FF)));
			// localbyte[3-k] = (byte)((localInt >> (k * 8)) & (0xff));

		}

		return localInt;
	}

	private static final char[] bcdLookup = { '0', '1', '2', '3', '4', '5',
			'6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

	/**
	 * 将字节数组转换为16进制字符串
	 * 
	 * @param bcd
	 * @return
	 */

	public static final String bytesToHex(byte[] bcd) {
		StringBuffer s = new StringBuffer(bcd.length * 2);

		for (int i = 0; i < bcd.length; i++) {
			s.append(bcdLookup[(bcd[i] >>> 4) & 0x0f]);
			s.append(bcdLookup[bcd[i] & 0x0f]);
		}

		return s.toString();
	}

	/**
	 * 将16进制字符串转换为字节数组
	 * 
	 * @param s
	 * @return
	 */
	public static final byte[] hexToBytes(String s) {
		byte[] bytes;
		bytes = new byte[s.length() / 2];

		for (int i = 0; i < bytes.length; i++) {
			bytes[i] = (byte) Integer.parseInt(s.substring(2 * i, 2 * i + 2),
					16);
		}

		return bytes;
	}

	/*
	 * 中文字转UCS2 例：输入：我是中国人 返回：806211662F4E2D56FD4EBA
	 */
	public static String characterTousc2(String zw, boolean f80) {
		byte[] b = null;
		try {
			b = zw.getBytes("UnicodeBigUnmarked");
		} catch (UnsupportedEncodingException ex) {
			ex.printStackTrace();
		}
		int nTmp = 0;
		String strTmp = "";
		StringBuffer strBuffer = new StringBuffer(b.length * 2);
		for (int i = 0; i < b.length; i++) {
			nTmp = b[i] & 0xff;
			strTmp = Integer.toHexString(nTmp);
			while (strTmp.length() < 2) {
				strTmp = "0" + strTmp;
			}
			strTmp = strTmp.toUpperCase();
			strBuffer.append(strTmp);
		}
		String returnstr = strBuffer.toString();
		if (f80)
			returnstr = "80" + returnstr;
		else {
			return returnstr;
		}
		// returnstr = (returnstr.length() / 2) + returnstr;
		return returnstr;
	}

	public static String gb2312ToShow(byte[] gb2312) {
		String sTemp = null;
		try {
			sTemp = new String(gb2312, "GB2312");
		} catch (UnsupportedEncodingException ex) {
			ex.printStackTrace();
		}
		return sTemp;
	}

	/*
	 * UCS2转中文字 例：输入：6211662F4E2D56FD4EBA 返回：我是中国人
	 */
	public static String ucs2ToCharacter(String ucs) {
		// byte[] bUnicode = hexStringToByte(ucs);hexToBytes
		byte[] bUnicode = hexToBytes(ucs);
		String sTemp = null;
		try {
			sTemp = new String(bUnicode, "UTF-16BE");
		} catch (UnsupportedEncodingException ex) {
			ex.printStackTrace();
		}
		return sTemp;
	}

	/**
	 * @author tangzhi
	 * @description 设置图片数据信息
	 * @param filePath
	 *            图片文件路径
	 * @return data null 图片不存在 ，0图片文件存在继续后续操作
	 * */

	public static byte[] getPhotoData(String filePath) {
		File file = new File(filePath);
		InputStream inStream = null;
		ByteArrayOutputStream outStream = null;
		byte[] localdata = null;
		try {
			if (!file.exists()) {
				return null;
			} else {

			}// end if(!file.exists())

			byte[] buffer = new byte[1024];
			int len = -1;
			inStream = new FileInputStream(file);
			outStream = new ByteArrayOutputStream();

			while ((len = inStream.read(buffer)) != -1) {
				outStream.write(buffer, 0, len);
			}

			localdata = outStream.toByteArray();

		} catch (FileNotFoundException e) {
//			e.printStackTrace();
		} catch (Exception e) {
//			e.printStackTrace();
		} finally {
			try {
				if (outStream != null) {
					outStream.close();
				} else {

				}

				if (inStream != null) {
					inStream.close();
				} else {

				}

			} catch (IOException e) {

//				e.printStackTrace();
			}

		}// end finally

		return localdata;

	}// end public void setPhotoData(String filePath)

	/**
	 * @author tangzhi
	 * @description 保存图片数据信息
	 * @param filePath
	 *            图片文件路径
	 * @return void void
	 * */

	public static void savePhotoData(byte[] data, String filePath) {
		BufferedOutputStream stream = null;
		File file = null;

		try {
			file = new File(filePath);
			FileOutputStream fstream = new FileOutputStream(file, false);
			stream = new BufferedOutputStream(fstream);
			stream.write(data);
		} catch (Exception e) {
//			e.printStackTrace();
		} finally {
			if (stream != null) {
				try {
					stream.close();
				} catch (Exception e) {
//					e.printStackTrace();
				}
			} else {

			}
		}

	}// public void savePhotoData(String filePath)

	/**
	 * @description Bitmap 转换为byte
	 * @param bmp
	 *            Bitmap 对象
	 * @return byte[] 字节
	 * **/

	public static byte[] Bitmap2Bytes(Bitmap bm) {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
		bm.compress(Bitmap.CompressFormat.JPEG, 80, baos);
		return baos.toByteArray();
	}

	/**
	 * @description 镜像处理
	 * @param bmp
	 *            Bitmap 对象
	 * @return Bitmap 对象
	 * **/
	public static Bitmap creatflipImage(Bitmap bmp) {
		Canvas canvas = new Canvas();
		Paint paint = new Paint();
		int LCD_WIDTH = bmp.getWidth();
		int LCD_HEIGHT = bmp.getHeight();
		Bitmap bitmap = Bitmap.createBitmap(LCD_WIDTH, LCD_HEIGHT,
				Config.ARGB_8888);
		canvas.setBitmap(bitmap);
		Camera camera = new Camera();
		Matrix matrix = new Matrix();
		camera.rotateY(180.0f);
		camera.getMatrix(matrix);
		matrix.postTranslate(LCD_WIDTH, 0);
		canvas.save();
		canvas.drawBitmap(bmp, matrix, paint);
		canvas.restore();
		return bitmap;
	}

	public static int hexToInt(String value, int defaultValue) {
		try {
			return Integer.parseInt(value, 16);
		} catch (Exception e) {
			return defaultValue;
		}
	}

	private static final char[] base64EncodeChars = new char[] { 'A', 'B', 'C',
			'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P',
			'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c',
			'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
			'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2',
			'3', '4', '5', '6', '7', '8', '9', '+', '/' };

	private static byte[] base64DecodeChars = new byte[] { -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59,
			60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,
			10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1,
			-1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
			38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1,
			-1, -1 };

	/**
	 * 将字节数组编码为字符串
	 * 
	 * @param data
	 */
	public static String encode(byte[] data) {
		StringBuffer sb = new StringBuffer();
		int len = data.length;
		int i = 0;
		int b1, b2, b3;

		while (i < len) {
			b1 = data[i++] & 0xff;
			if (i == len) {
				sb.append(base64EncodeChars[b1 >>> 2]);
				sb.append(base64EncodeChars[(b1 & 0x3) << 4]);
				sb.append("==");
				break;
			}
			b2 = data[i++] & 0xff;
			if (i == len) {
				sb.append(base64EncodeChars[b1 >>> 2]);
				sb.append(base64EncodeChars[((b1 & 0x03) << 4)
						| ((b2 & 0xf0) >>> 4)]);
				sb.append(base64EncodeChars[(b2 & 0x0f) << 2]);
				sb.append("=");
				break;
			}
			b3 = data[i++] & 0xff;
			sb.append(base64EncodeChars[b1 >>> 2]);
			sb.append(base64EncodeChars[((b1 & 0x03) << 4)
					| ((b2 & 0xf0) >>> 4)]);
			sb.append(base64EncodeChars[((b2 & 0x0f) << 2)
					| ((b3 & 0xc0) >>> 6)]);
			sb.append(base64EncodeChars[b3 & 0x3f]);
		}
		return sb.toString();
	}

	/**
	 * 将base64字符串解码为字节数组
	 * 
	 * @param str
	 */
	public static byte[] decode(String str) {
		byte[] data = str.getBytes();
		int len = data.length;
		ByteArrayOutputStream buf = new ByteArrayOutputStream(len);
		int i = 0;
		int b1, b2, b3, b4;

		while (i < len) {

			/* b1 */
			do {
				b1 = base64DecodeChars[data[i++]];
			} while (i < len && b1 == -1);
			if (b1 == -1) {
				break;
			}

			/* b2 */
			do {
				b2 = base64DecodeChars[data[i++]];
			} while (i < len && b2 == -1);
			if (b2 == -1) {
				break;
			}
			buf.write((int) ((b1 << 2) | ((b2 & 0x30) >>> 4)));

			/* b3 */
			do {
				b3 = data[i++];
				if (b3 == 61) {
					return buf.toByteArray();
				}
				b3 = base64DecodeChars[b3];
			} while (i < len && b3 == -1);
			if (b3 == -1) {
				break;
			}
			buf.write((int) (((b2 & 0x0f) << 4) | ((b3 & 0x3c) >>> 2)));

			/* b4 */
			do {
				b4 = data[i++];
				if (b4 == 61) {
					return buf.toByteArray();
				}
				b4 = base64DecodeChars[b4];
			} while (i < len && b4 == -1);
			if (b4 == -1) {
				break;
			}
			buf.write((int) (((b3 & 0x03) << 6) | b4));
		}
		return buf.toByteArray();
	}

}
