/*
 * Decompiled with CFR 0.152.
 */
package com.fri;

import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class HexManager {
    private static final char[] bcdLookup = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] base64EncodeChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static byte[] base64DecodeChars = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1};

    public static void saveConfig(String dir, String fileName, Properties properties) {
        try {
            String localFile = dir + "/" + fileName;
            FileOutputStream s = new FileOutputStream(localFile, false);
            properties.store(s, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Properties loadConfig(String file) {
        Properties properties = new Properties();
        File afile = new File(file);
        try {
            if (!afile.exists()) {
                return null;
            }
            FileInputStream s = new FileInputStream(file);
            properties.load(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    public static boolean delFoldAndFile(String foldPath) {
        File file = new File(foldPath);
        boolean localState = false;
        try {
            if (file.exists()) {
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        HexManager.delFile(files[i]);
                    }
                }
                localState = file.delete();
            } else {
                System.out.println("\u6240\u5220\u9664\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localState;
    }

    private static void delFile(File file) {
        try {
            if (file.isFile()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String IntToByteHex(int mInt) {
        String localString = null;
        int localInt = mInt;
        byte[] localbyte = new byte[4];
        for (int k = 0; k < 4; ++k) {
            localbyte[3 - k] = (byte)(localInt >> k * 8 & 0xFF);
        }
        localString = HexManager.bytesToHex(localbyte);
        return localString;
    }

    public static String IntToByteOneHex(int mInt) {
        String localString = null;
        int localInt = mInt;
        byte[] localbyte = new byte[]{(byte)localInt};
        localString = HexManager.bytesToHex(localbyte);
        return localString;
    }

    public static int ByteToIntHex(byte[] mbyte) {
        int localInt = 0;
        byte[] localbyte = new byte[4];
        System.arraycopy(mbyte, 0, localbyte, 0, mbyte.length);
        for (int k = 0; k < 4; ++k) {
            int temp = 0;
            localInt &= 0xFFFFFF00;
            temp = localbyte[k] & 0xFF;
            System.out.printf("\nlocalInt = 0x%x", localInt |= temp);
            if (k >= 3) continue;
            localInt <<= 8;
        }
        return localInt;
    }

    public static final String bytesToHex(byte[] bcd) {
        StringBuffer s = new StringBuffer(bcd.length * 2);
        for (int i = 0; i < bcd.length; ++i) {
            s.append(bcdLookup[bcd[i] >>> 4 & 0xF]);
            s.append(bcdLookup[bcd[i] & 0xF]);
        }
        return s.toString();
    }

    public static final byte[] hexToBytes(String s) {
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public static String characterTousc2(String zw, boolean f80) {
        byte[] b = null;
        try {
            b = zw.getBytes("UnicodeBigUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        int nTmp = 0;
        String strTmp = "";
        StringBuffer strBuffer = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            nTmp = b[i] & 0xFF;
            strTmp = Integer.toHexString(nTmp);
            while (strTmp.length() < 2) {
                strTmp = "0" + strTmp;
            }
            strTmp = strTmp.toUpperCase();
            strBuffer.append(strTmp);
        }
        String returnstr = strBuffer.toString();
        if (!f80) {
            return returnstr;
        }
        returnstr = "80" + returnstr;
        return returnstr;
    }

    public static String gb2312ToShow(byte[] gb2312) {
        String sTemp = null;
        try {
            sTemp = new String(gb2312, "GB2312");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return sTemp;
    }

    public static String ucs2ToCharacter(String ucs) {
        byte[] bUnicode = HexManager.hexToBytes(ucs);
        String sTemp = null;
        try {
            sTemp = new String(bUnicode, "UTF-16BE");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return sTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getPhotoData(String filePath) {
        File file = new File(filePath);
        InputStream inStream = null;
        ByteArrayOutputStream outStream = null;
        byte[] localdata = null;
        try {
            if (!file.exists()) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] buffer = new byte[1024];
            int len = -1;
            inStream = new FileInputStream(file);
            outStream = new ByteArrayOutputStream();
            while ((len = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            localdata = outStream.toByteArray();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return localdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePhotoData(byte[] data, String filePath) {
        FilterOutputStream stream = null;
        File file = null;
        try {
            file = new File(filePath);
            FileOutputStream fstream = new FileOutputStream(file, false);
            stream = new BufferedOutputStream(fstream);
            stream.write(data);
        }
        catch (Exception exception) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static byte[] Bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)baos);
        return baos.toByteArray();
    }

    public static Bitmap creatflipImage(Bitmap bmp) {
        Canvas canvas = new Canvas();
        Paint paint = new Paint();
        int LCD_WIDTH = bmp.getWidth();
        int LCD_HEIGHT = bmp.getHeight();
        Bitmap bitmap = Bitmap.createBitmap((int)LCD_WIDTH, (int)LCD_HEIGHT, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        canvas.setBitmap(bitmap);
        Camera camera = new Camera();
        Matrix matrix = new Matrix();
        camera.rotateY(180.0f);
        camera.getMatrix(matrix);
        matrix.postTranslate((float)LCD_WIDTH, 0.0f);
        canvas.save();
        canvas.drawBitmap(bmp, matrix, paint);
        canvas.restore();
        return bitmap;
    }

    public static int hexToInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value, 16);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String encode(byte[] data) {
        StringBuffer sb = new StringBuffer();
        int len = data.length;
        int i = 0;
        while (i < len) {
            int b1 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4]);
                sb.append("==");
                break;
            }
            int b2 = data[i++] & 0xFF;
            if (i == len) {
                sb.append(base64EncodeChars[b1 >>> 2]);
                sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
                sb.append(base64EncodeChars[(b2 & 0xF) << 2]);
                sb.append("=");
                break;
            }
            int b3 = data[i++] & 0xFF;
            sb.append(base64EncodeChars[b1 >>> 2]);
            sb.append(base64EncodeChars[(b1 & 3) << 4 | (b2 & 0xF0) >>> 4]);
            sb.append(base64EncodeChars[(b2 & 0xF) << 2 | (b3 & 0xC0) >>> 6]);
            sb.append(base64EncodeChars[b3 & 0x3F]);
        }
        return sb.toString();
    }

    public static byte[] decode(String str) {
        byte[] data = str.getBytes();
        int len = data.length;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(len);
        int i = 0;
        while (i < len) {
            byte b4;
            byte b3;
            byte b2;
            byte b1;
            do {
                b1 = base64DecodeChars[data[i++]];
            } while (i < len && b1 == -1);
            if (b1 == -1) break;
            do {
                b2 = base64DecodeChars[data[i++]];
            } while (i < len && b2 == -1);
            if (b2 == -1) break;
            buf.write(b1 << 2 | (b2 & 0x30) >>> 4);
            do {
                if ((b3 = data[i++]) == 61) {
                    return buf.toByteArray();
                }
                b3 = base64DecodeChars[b3];
            } while (i < len && b3 == -1);
            if (b3 == -1) break;
            buf.write((b2 & 0xF) << 4 | (b3 & 0x3C) >>> 2);
            do {
                if ((b4 = data[i++]) == 61) {
                    return buf.toByteArray();
                }
                b4 = base64DecodeChars[b4];
            } while (i < len && b4 == -1);
            if (b4 == -1) break;
            buf.write((b3 & 3) << 6 | b4);
        }
        return buf.toByteArray();
    }
}

