/*
 * Decompiled with CFR 0.152.
 */
package com.fri.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.fri.service.IZDTokenService;
import com.fri.service.ZDTokenCmd;
import org.json.JSONException;
import org.json.JSONObject;

public class ZDTokenClient
implements ZDTokenCmd {
    final String TAG = "ZDTokenClient";
    Context mContext;
    IZDTokenService mZDTokenService = null;
    ServiceConnection conn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            ZDTokenClient.this.mZDTokenService = IZDTokenService.Stub.asInterface(service);
            if (ZDTokenClient.this.mListener != null) {
                ZDTokenClient.this.mListener.onBindConnect();
            }
            Log.i((String)"ZDTokenClient", (String)"onServiceConnected ");
        }

        public void onServiceDisconnected(ComponentName name) {
            Log.i((String)"ZDTokenClient", (String)"onServiceDisconnected ");
            ZDTokenClient.this.mZDTokenService = null;
            if (ZDTokenClient.this.mListener != null) {
                ZDTokenClient.this.mListener.onBindDisconnect();
            }
        }
    };
    public final String packageName = "com.fri.zdtoken";
    public final String serviceNmae = "com.fri.service.ZDTokenService";
    private Listener mListener;
    int Times = 0;

    public ZDTokenClient(Context context) {
        this.mContext = context;
    }

    public void startTokenService() {
        Intent inte = new Intent();
        ComponentName com = new ComponentName("com.fri.zdtoken", "com.fri.service.ZDTokenService");
        inte.setComponent(com);
        this.mContext.startService(inte);
    }

    public boolean bindTokenService() {
        if (this.mZDTokenService == null) {
            boolean bOk = false;
            Intent inte = new Intent();
            ComponentName com = new ComponentName("com.fri.zdtoken", "com.fri.service.ZDTokenService");
            inte.setComponent(com);
            bOk = this.mContext.bindService(inte, this.conn, 1);
            if (bOk) {
                Log.e((String)"ZDTokenClient", (String)"bindTokenService ok");
            } else {
                Log.e((String)"ZDTokenClient", (String)"bindTokenService error");
            }
            return bOk;
        }
        return true;
    }

    public void unbindTokenService() {
        if (this.mZDTokenService != null) {
            this.mContext.unbindService(this.conn);
            this.mZDTokenService = null;
            if (this.mListener != null) {
                this.mListener.onBindDisconnect();
            }
        }
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public String onTestDemo() {
        String cmd = "";
        cmd = this.command(0, this.Times++, 0, cmd);
        return cmd;
    }

    public String command(int what, int arg1, int arg2, String cmd) {
        String result = "";
        if (this.mZDTokenService == null) {
            this.startTokenService();
            this.bindTokenService();
        }
        if (this.mZDTokenService == null) {
            Log.i((String)"ZDTokenClient", (String)"mZDTokenService == null");
            return "mZDTokenService == null";
        }
        try {
            result = this.mZDTokenService.command(what, arg1, arg2, cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            Log.i((String)"ZDTokenClient", (String)"RemoteException");
            return "RemoteException";
        }
        return result;
    }

    public String getSN() {
        String cmd = "";
        try {
            String result = this.command(10020, 1030, 0, cmd);
            if (result != null && result.length() > 2) {
                JSONObject j_response = new JSONObject(result);
                if (!j_response.has("result")) {
                    return "";
                }
                JSONObject j_result = j_response.getJSONObject("result");
                if (!j_result.has("SN")) {
                    return "";
                }
                String sn = j_result.getString("SN");
                return sn;
            }
            return "";
        }
        catch (JSONException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static class Listener {
        public void onBindConnect() {
        }

        public void onBindDisconnect() {
        }
    }
}

