/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import android.widget.TextView;
import com.aircert.dialog.BindIdentifyDialog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.cryptodev.driver.xdja.XdjaError;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.request.RequestSMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifyPhoneRequest;
import com.xdja.safeclient.certcreation.bean.request.VerifySMSCodeRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.VerifyPhoneResult;
import com.xdja.safeclient.certcreation.bean.result.VerifySMSCodeResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.KeyboardUtils;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.ValidUtil;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import ocr.activity.LiveStartActivity;
import okhttp3.Call;

@Route(path="/cert/phone_info", name="\u8f93\u5165\u624b\u673a\u53f7")
public class PhoneInputActivity
extends BaseActivity
implements View.OnClickListener {
    private RadioGroup gender;
    private EditText etName;
    private EditText etId;
    private EditText etPhone;
    private EditText etSMSCode;
    private Button requestSMSCode;
    private Button btn_submit;
    private Timer timer;
    private final int COUNT_DOWN = 60;
    private LinearLayout standard;
    private TextView title;
    private int count = 60;
    private BindIdentifyDialog pinDialog;
    @Autowired(name="cardType")
    public CryptoDevType cardType;
    @Autowired(name="cardNum")
    public String cardNum;
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            this.temp = charSequence;
        }

        public void afterTextChanged(Editable editable) {
            if (this.temp.length() < 6) {
                PhoneInputActivity.this.btn_submit.setEnabled(false);
            } else {
                PhoneInputActivity.this.btn_submit.setEnabled(true);
            }
        }
    };
    private boolean isNext = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.phone_input);
        ARouter.getInstance().inject((Object)this);
        this.initView();
        this.setHint();
    }

    @Override
    public String nextActivity() {
        return "/cert/selfie";
    }

    private void setHint() {
        if (AppConfig.getInstance().getProject() == 0) {
            this.etPhone.setHint(R.string.valid_phone_hint_guangdong);
        } else {
            this.etPhone.setHint(R.string.valid_phone_hint_others);
            this.etPhone.addTextChangedListener(this.textWatcher);
            this.btn_submit.setEnabled(false);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.isNext) {
            this.etPhone.setText((CharSequence)"");
            this.btn_submit.setEnabled(false);
            this.isNext = false;
        }
        ImageCache.getInstance().clear();
    }

    private void initView() {
        DeviceWrapper.getInstance();
        int pinResult = DeviceWrapper.verifyPin(this.cardType, AppConfig.getInstance().getPin());
        if (pinResult != 0) {
            int rest = XdjaError.errorToXdja((int)pinResult);
            String errorText = CryptoDevManager.getInstance().getErrorText(pinResult);
            this.showPinDialog(errorText);
        }
        this.title = (TextView)this.findViewById(R.id.info_title);
        this.etPhone = (EditText)this.findViewById(R.id.et_phone);
        this.etSMSCode = (EditText)this.findViewById(R.id.et_sms_code);
        this.requestSMSCode = (Button)this.findViewById(R.id.request_sms_code);
        this.btn_submit = (Button)this.findViewById(R.id.btn_submit);
        this.initInfoView();
    }

    private void initInfoView() {
        if (AppConfig.getInstance().getLiveCompany() != 2) {
            this.title.setText(R.string.apply_cert);
            return;
        }
        if (this.standard == null) {
            this.standard = (LinearLayout)this.findViewById(R.id.standard);
            this.standard.setVisibility(0);
        }
        this.etName = (EditText)this.findViewById(R.id.et_name);
        this.gender = (RadioGroup)this.findViewById(R.id.gender);
        this.etId = (EditText)this.findViewById(R.id.et_id);
        this.etId.setRawInputType(2);
    }

    private void showPinDialog() {
        this.showPinDialog("");
    }

    private void showPinDialog(String errorText) {
        this.pinDialog = new BindIdentifyDialog(this.context);
        this.pinDialog.setTitle(R.string.input_PIN);
        this.pinDialog.setNegativeButtonText(R.string.cancel);
        this.pinDialog.setPositiveButtonText(R.string.confirm);
        this.pinDialog.setModel(3);
        this.pinDialog.show();
        this.pinDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                PhoneInputActivity.this.verifyPinCode(PhoneInputActivity.this.pinDialog.getPinCode());
            }

            public void doCancel() {
                PhoneInputActivity.this.pinDialog.dismiss();
            }
        });
    }

    private void verifyPinCode(String code) {
        ModuleLog.e("pinCode = " + code);
        if (!com.aircert.util.TextUtils.verifyString((Context)this.context, (String)code)) {
            return;
        }
        DeviceWrapper.getInstance();
        int pinResult = DeviceWrapper.verifyPin(this.cardType, code);
        if (pinResult == 0) {
            if (this.pinDialog.isShowing()) {
                this.pinDialog.dismiss();
            }
            if (!AppConfig.getInstance().getPin().equals(code)) {
                AppConfig.getInstance().setPin(code);
            }
        } else if (pinResult > 2000 && pinResult < 2010 || pinResult == 2026 || pinResult == 2020) {
            this.showPinDialog();
            ModuleLog.e("pinResult = " + pinResult);
            this.pinDialog.showPinTips(CryptoDevManager.getInstance().getErrorText(pinResult));
        } else {
            this.pinDialog.dismiss();
        }
    }

    protected int getTitleRes() {
        return -1;
    }

    public void submit(View view) {
        KeyboardUtils.hideKeyboard((View)this.etPhone);
        this.next();
    }

    @Override
    public void next() {
        super.next();
        KeyboardUtils.hideKeyboard((View)this.etPhone);
    }

    @Override
    public void route() {
        super.route();
        int company = AppConfig.getInstance().getLiveCompany();
        if (company == 2) {
            this.startSelfieActivity();
        } else {
            this.startLiveStartActivity();
        }
        this.isNext = true;
    }

    private void startSelfieActivity() {
        ShareperencesUtil.saveDevCardID((Context)this, this.cardNum);
        ShareperencesUtil.saveCurrentDevType((Context)this, this.cardType.getType());
        ARouter.getInstance().build(this.nextActivity()).withInt("type", 0).navigation((Context)this);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    private void startLiveStartActivity() {
        Intent intent = new Intent((Context)this, LiveStartActivity.class);
        this.startActivity(intent);
        this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
    }

    private void verifySMSCode() {
        VerifySMSCodeRequest request = new VerifySMSCodeRequest(this.etPhone.getText().toString(), this.etSMSCode.getText().toString());
        this.service.verifySMSCode(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ModuleLog.d(e);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse response) {
                String result = response.getResult();
                if (result.equals("0")) {
                    ModuleToast.show((Context)PhoneInputActivity.this, R.string.verify_success);
                    PhoneInputActivity.this.next();
                } else {
                    ModuleToast.show((Context)PhoneInputActivity.this, new VerifySMSCodeResult().getErrText(result));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }

            @Override
            public void dismissDialog() {
                PhoneInputActivity.this.dismissLoading();
            }
        });
    }

    public void onClick(View view) {
        if (view.getId() == R.id.request_sms_code) {
            this.request();
        }
    }

    private void request() {
        String phone = this.etPhone.getText().toString();
        if (TextUtils.isEmpty((CharSequence)phone)) {
            ModuleToast.show(this.context, R.string.not_null_phone_num);
            return;
        }
        this.verifyPhoneNum(phone);
    }

    private void verifyPhoneNum(final String phone) {
        VerifyPhoneRequest request = new VerifyPhoneRequest(phone);
        this.showLoading();
        this.service.verifyPhoneNum(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                PhoneInputActivity.this.showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String errCode = commonResponse.getResult();
                if (errCode.equals("0")) {
                    PhoneInputActivity.this.requestSMSCode(phone);
                } else {
                    ModuleToast.show(PhoneInputActivity.this.context, PhoneInputActivity.this.getString(new VerifyPhoneResult().getErrText(errCode)));
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }

            @Override
            public void dismissDialog() {
                PhoneInputActivity.this.dismissLoading();
            }
        });
    }

    private void requestSMSCode(String phone) {
        RequestSMSCodeRequest request = new RequestSMSCodeRequest(phone);
        this.service.requestSMSCode(request, this.cardNum, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                PhoneInputActivity.this.showRequestError();
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                PhoneInputActivity.this.countDown();
                ModuleToast.show(PhoneInputActivity.this.context, R.string.verify_code_send_success);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleToast.show(PhoneInputActivity.this.context, R.string.verify_code_send_fail);
                PhoneInputActivity.this.handleRequestSMSError(baseErrorResponse);
            }

            @Override
            public void dismissDialog() {
                PhoneInputActivity.this.dismissLoading();
            }
        });
    }

    private void countDown() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PhoneInputActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        PhoneInputActivity.this.requestSMSCode.setText((CharSequence)(PhoneInputActivity.this.count + "\u79d2"));
                        PhoneInputActivity.this.requestSMSCode.setClickable(false);
                        PhoneInputActivity.this.count--;
                        if (PhoneInputActivity.this.count < 0) {
                            PhoneInputActivity.this.count = 60;
                            PhoneInputActivity.this.requestSMSCode.setText(R.string.request_sms_code);
                            PhoneInputActivity.this.requestSMSCode.setClickable(true);
                            PhoneInputActivity.this.timer.cancel();
                        }
                    }
                });
            }
        }, 0L, 1000L);
    }

    private void handleRequestSMSError(BaseErrorResponse baseErrorResponse) {
        String message = baseErrorResponse.getMessage();
        String errCode = baseErrorResponse.getErrCode();
        if (message.equals("transcend_sms_send_times")) {
            ModuleToast.show((Context)this, R.string.verify_code_freq);
        } else if (message.equals("fail_send_message")) {
            ModuleToast.show((Context)this, R.string.verify_code_send_fail);
        }
    }

    protected boolean isOCRActivity() {
        return true;
    }

    @Override
    public boolean valid() {
        if (AppConfig.getInstance().getLiveCompany() == 2) {
            if (!ValidUtil.name(this.etName.getText().toString())) {
                ModuleToast.show(this.context, R.string.not_null_name);
                return false;
            }
            if (!ValidUtil.phone(this.etPhone.getText().toString())) {
                return false;
            }
            if (!ValidUtil.idNum(this.etId.getText().toString())) {
                ModuleToast.show(this.context, R.string.error_id_size);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void saveValue() {
        if (AppConfig.getInstance().getLiveCompany() == 2) {
            ShareperencesUtil.saveIDCardNo((Context)this, this.cardType.getType(), this.etId.getText().toString());
            ShareperencesUtil.saveSex((Context)this, this.cardType.getType(), this.gender.getCheckedRadioButtonId() == R.id.male ? 1 : 2);
            ShareperencesUtil.saveName((Context)this, this.etName.getText().toString());
        }
        ShareperencesUtil.savePhone(this.context, this.etPhone.getText().toString());
    }
}

