/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import com.aircert.BusProvider;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.util.TextUtils;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.xdja.cryptodev.CryptoDevManager;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.request.Info;
import com.xdja.safeclient.certcreation.bean.request.RevokedCertRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import okhttp3.Call;

@Route(path="/cert/reason", name="\u539f\u56e0")
public class ReasonActivity
extends BaseActivity {
    public static final int REVOKE = 2;
    public static final int RECOVERY = 1;
    private EditText reasonET;
    private Button submit;
    public CertDetailInfo certDetailInfo;
    @Autowired(name="chipBean")
    public ChipBean chipBean;
    CryptoDevType cardType;
    @Autowired(name="cardId")
    public String cardID;
    int type;
    private BindIdentifyDialog pinDialog = null;
    private TextWatcher textWatcher = new TextWatcher(){
        private CharSequence temp;
        private int selectionStart;
        private int selectionEnd;

        public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            this.temp = charSequence;
        }

        public void afterTextChanged(Editable editable) {
            this.selectionStart = ReasonActivity.this.reasonET.getSelectionStart();
            this.selectionEnd = ReasonActivity.this.reasonET.getSelectionEnd();
            if (this.temp.length() > 40) {
                ModuleToast.show((Context)ReasonActivity.this, R.string.reason_text_length);
                editable.delete(this.selectionStart - 1, this.selectionEnd);
                int tempSelection = this.selectionEnd;
                ReasonActivity.this.reasonET.setText((CharSequence)editable);
                ReasonActivity.this.reasonET.setSelection(tempSelection);
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_reason);
        ARouter.getInstance().inject((Object)this);
        this.certDetailInfo = this.chipBean.getCertBean();
        this.cardType = Util.getChipBeanType(this.chipBean);
        this.type = this.getIntent().getIntExtra("type", 0);
        if (this.type == 2) {
            // empty if block
        }
        this.reasonET = (EditText)this.findViewById(R.id.reason);
        this.reasonET.addTextChangedListener(this.textWatcher);
        this.submit = (Button)this.findViewById(R.id.submit);
        ReasonActivity context = this;
        this.submit.setOnClickListener(new View.OnClickListener((Context)context){
            final /* synthetic */ Context val$context;
            {
                this.val$context = context;
            }

            public void onClick(View v) {
                if (ReasonActivity.this.reasonET.getText().length() > 0) {
                    ReasonActivity.this.hideSoft();
                    ReasonActivity.this.revokeCert();
                } else {
                    ModuleToast.show(this.val$context, R.string.reason_input);
                }
            }
        });
    }

    private void revokeCert() {
        this.showLoading();
        RevokedCertRequest request = this.buildRequest();
        if (request == null) {
            return;
        }
        this.service.revokedCert(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
                ReasonActivity.this.dismissLoading();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                ReasonActivity.this.dismissLoading();
                ModuleToast.show((Context)ReasonActivity.this, "\u7f51\u7edc\u5f02\u5e38");
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    ReasonActivity.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                } else if (result.equals("1")) {
                    ReasonActivity.this.chipBean.setState(CertState.AGREE_REVOKE);
                } else if (result.equals("2")) {
                    ReasonActivity.this.chipBean.setState(CertState.REJECT_REVOKE);
                } else if (result.equals("5") || result.equals("6")) {
                    // empty if block
                }
                BusProvider.getMainProvider().post((Object)ReasonActivity.this.chipBean);
                OttoUtil.postRevokeResult(ReasonActivity.this.chipBean, ReasonActivity.this.reasonET.getText().toString());
                ReasonActivity.this.finish();
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                ModuleToast.show((Context)ReasonActivity.this, baseErrorResponse.getErrCode());
            }

            @Override
            public void dismissDialog() {
                ReasonActivity.this.dismissLoading();
            }
        });
    }

    private RevokedCertRequest buildRequest() {
        RevokedCertRequest revokeRequest = new RevokedCertRequest();
        Info info = new Info();
        if (this.certDetailInfo == null) {
            ModuleLog.e("sn\u4e3a\u7a7a");
            return null;
        }
        String sn = this.certDetailInfo.sn;
        info.setSn(sn);
        info.setReason(this.reasonET.getText().toString());
        info.setTime(System.currentTimeMillis());
        revokeRequest.setInfo(info);
        String sign = DeviceWrapper.getInstance().signData(this.cardType, info.toString());
        if (sign != null) {
            if (sign.startsWith("errorCode")) {
                this.showPinDialog();
                return null;
            }
            revokeRequest.setSign(sign);
        } else {
            ModuleToast.show(this.context, R.string.signFail);
        }
        return revokeRequest;
    }

    private void showPinDialog() {
        this.pinDialog = new BindIdentifyDialog(this.context);
        this.pinDialog.setTitle(R.string.input_PIN);
        this.pinDialog.setNegativeButtonText(R.string.cancel);
        this.pinDialog.setPositiveButtonText(R.string.confirm);
        this.pinDialog.setModel(3);
        this.pinDialog.show();
        this.pinDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                ReasonActivity.this.verifyPinCode(ReasonActivity.this.pinDialog.getPinCode());
            }

            public void doCancel() {
                ReasonActivity.this.pinDialog.dismiss();
            }
        });
    }

    private void verifyPinCode(String code) {
        ModuleLog.e("pinCode = " + code);
        if (!TextUtils.verifyString((Context)this.context, (String)code)) {
            return;
        }
        DeviceWrapper.getInstance();
        int pinResult = DeviceWrapper.verifyPin(this.cardType, code);
        if (pinResult == 0) {
            if (this.pinDialog.isShowing()) {
                this.pinDialog.dismiss();
            }
            if (!AppConfig.getInstance().getPin().equals(code)) {
                AppConfig.getInstance().setPin(code);
            }
        } else if (pinResult > 2000 && pinResult < 2010 || pinResult == 2026 || pinResult == 2020) {
            this.showPinDialog();
            ModuleLog.e("pinResult = " + pinResult);
            this.pinDialog.showPinTips(CryptoDevManager.getInstance().getErrorText(pinResult));
        } else {
            this.pinDialog.dismiss();
        }
    }

    private void hideSoft() {
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
    }

    protected int getTitleRes() {
        return R.string.revoke_cert;
    }
}

