/*
 * Decompiled with CFR 0.152.
 */
package ocr.fragment;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import ocr.command.NFCCommand;
import ocr.view.MyClickText;

public class NFCLoadingFragment
extends Fragment {
    public static final int STATE_NORMAL = 0;
    public static final int STATE_UNOPEN = -1;
    public static final int STATE_UNSUPPORT = -2;
    private TextView nfc_upen;
    private MyClickText clickText;
    private ImageView phoneImg;
    private ImageView cardImg;
    private BroadcastReceiver mStatusReceive = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            block3 : switch (intent.getAction()) {
                case "android.nfc.action.ADAPTER_STATE_CHANGED": {
                    int blueState = intent.getIntExtra("android.nfc.extra.ADAPTER_STATE", 0);
                    switch (blueState) {
                        case 3: {
                            NFCLoadingFragment.this.showLoading();
                            break block3;
                        }
                        case 1: {
                            NFCLoadingFragment.this.showUnopen();
                        }
                    }
                }
            }
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.nfc_loading, container, false);
        this.initView(view);
        this.initAction();
        return view;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.registerNFCReceiver();
    }

    public void onResume() {
        super.onResume();
        if (this.getActivity() != null && this.getActivity() instanceof NFCCommand) {
            int state = ((NFCCommand)this.getActivity()).getNFCState();
            if (state == 0) {
                this.showLoading();
            } else if (state == -1) {
                this.showUnopen();
            } else {
                this.showUnsopport();
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.unregisterNFCReceiver();
    }

    private void initView(View view) {
        this.phoneImg = (ImageView)view.findViewById(R.id.ivPhone);
        this.cardImg = (ImageView)view.findViewById(R.id.ivIdCard);
        this.nfc_upen = (TextView)view.findViewById(R.id.nfc_upen);
    }

    private void initAction() {
        Animator animator1 = AnimatorInflater.loadAnimator((Context)this.getActivity(), (int)R.animator.phone);
        animator1.setTarget((Object)this.phoneImg);
        animator1.start();
        Animator animator2 = AnimatorInflater.loadAnimator((Context)this.getActivity(), (int)R.animator.idcard);
        animator2.setTarget((Object)this.cardImg);
        animator2.start();
    }

    private void showUnsopport() {
        this.nfc_upen.setVisibility(0);
        this.nfc_upen.setText(R.string.nfc_unsupport);
    }

    private void showUnopen() {
        this.nfc_upen.setVisibility(0);
        SpannableString str = new SpannableString((CharSequence)this.getActivity().getResources().getString(R.string.nfc_to_setting));
        str.setSpan((Object)this.clickText, str.length() - 6, str.length() - 4, 33);
        this.nfc_upen.setText((CharSequence)str);
        this.nfc_upen.setMovementMethod(LinkMovementMethod.getInstance());
    }

    private void showLoading() {
        this.nfc_upen.setVisibility(8);
    }

    private void registerNFCReceiver() {
        IntentFilter statusFilter = new IntentFilter("android.nfc.action.ADAPTER_STATE_CHANGED");
        this.getActivity().registerReceiver(this.mStatusReceive, statusFilter);
    }

    private void unregisterNFCReceiver() {
        this.getActivity().unregisterReceiver(this.mStatusReceive);
    }
}

