/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.view;

import android.content.Context;
import android.os.Message;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.aircert.BusProvider;
import com.aircert.util.CommonUtil;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.android.arouter.launcher.ARouter;
import com.squareup.otto.Subscribe;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.adapter.RecyclerViewAdapter;
import com.xdja.safeclient.certcreation.bean.CertDetailInfo;
import com.xdja.safeclient.certcreation.bean.CertItemBean;
import com.xdja.safeclient.certcreation.bean.CertState;
import com.xdja.safeclient.certcreation.bean.ChipBean;
import com.xdja.safeclient.certcreation.bean.ChipInfo;
import com.xdja.safeclient.certcreation.bean.MobileInfo;
import com.xdja.safeclient.certcreation.bean.OkNetError;
import com.xdja.safeclient.certcreation.bean.request.CertApplyRequest;
import com.xdja.safeclient.certcreation.bean.request.CertStateRequest;
import com.xdja.safeclient.certcreation.bean.request.WriteFailInfo;
import com.xdja.safeclient.certcreation.bean.request.WriteFailRequest;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CertApplyResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.response.CompareResult;
import com.xdja.safeclient.certcreation.bean.result.AuthResult;
import com.xdja.safeclient.certcreation.bean.result.PhoneResult;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.device.DeviceUtil;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.device.PKCS10Utils;
import com.xdja.safeclient.certcreation.event.PhonePermissionResult;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.util.AnimUtil;
import com.xdja.safeclient.certcreation.util.ModuleLog;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.OttoUtil;
import com.xdja.safeclient.certcreation.util.ShareperencesUtil;
import com.xdja.safeclient.certcreation.util.Util;
import java.io.IOException;
import java.io.Serializable;
import okhttp3.Call;
import okhttp3.RequestBody;

public class CertItemView
extends RelativeLayout {
    private FrameLayout container_child;
    private ChipBean chipBean;
    private Context context;
    private static final int QUERY_CERTINFO_FROM_SERVER = 0;
    private static final int APPLY_CERT_REQUEST = 1;
    private static final int QUERY_AUTHENTIATION_RESULT = 2;
    private static final int IMPORT_CERT_FAIL = 3;
    private String cardID;
    private CryptoDevType chipBeanType;
    private RecyclerViewAdapter recyclerViewAdapter;
    private boolean isCertOK = false;
    private CertItemBean certItemBean;
    private ChipExecutorService chipExecutorService = new ChipExecutorService();
    private static final int TAG_QUERY_CERT_STATE = 0;
    private MyHandler myHandler = new MyHandler(this);
    private CertService certService = new CertService();

    public CertItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.cer_item_layout, (ViewGroup)this);
        BusProvider.register((Object)((Object)this));
    }

    public boolean isCertOK() {
        return this.isCertOK;
    }

    public void setData(Context context, RecyclerViewAdapter recyclerViewAdapter, CertItemBean certItemBean) {
        this.context = context;
        this.certItemBean = certItemBean;
        this.isCertOK = false;
        this.chipBeanType = this.certItemBean.getType();
        this.cardID = DeviceWrapper.getInstance().getCardID(this.chipBeanType);
        this.recyclerViewAdapter = recyclerViewAdapter;
        this.initView();
        if (TextUtils.isEmpty((CharSequence)this.cardID)) {
            this.showErrorResponseLayout(context.getString(R.string.card_not_exist));
            return;
        }
        RequestCache.getInstance().putType(this.cardID, this.chipBeanType.getType());
        if (Util.assetFileIsExist(context, "certDataBase.db")) {
            this.queryCertInfo();
        }
    }

    private void queryCertInfo() {
        this.showChecking();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int type = CertItemView.this.chipBeanType.getType();
                ChipBean bean = new ChipBean();
                bean.setType(type);
                CertDetailInfo info = DeviceWrapper.getInstance().readCertFromContainer(CertItemView.this.chipBeanType, AppConfig.getInstance().getContainerID());
                if (info == null) {
                    bean.setState(CertState.NO_CERT);
                } else {
                    if (bean.getState() == CertState.CERT_OUT_OF_DATE) {
                        bean.setState(CertState.CERT_OUT_OF_DATE);
                    } else {
                        bean.setState(CertState.SUCCESS);
                    }
                    bean.setCertDetailInfo(info);
                    boolean isVerify = DeviceWrapper.getInstance().verifyCertByRoot(CertItemView.this.chipBeanType, AppConfig.getInstance().getContainerID());
                    bean.setIsVerify(isVerify);
                }
                CertItemView.this.chipExecutorService.sendMessage(CertItemView.this.myHandler, 0, bean);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    public ChipBean getChipBean() {
        return this.chipBean;
    }

    private void initView() {
        TextView name = (TextView)this.findViewById(R.id.name);
        this.container_child = (FrameLayout)this.findViewById(R.id.container_child);
        if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SdCard) {
            name.setText(R.string.tf_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Chip) {
            name.setText(R.string.chip_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_SimKey) {
            name.setText(R.string.tiemo_cert);
        } else if (this.certItemBean.getType() == CryptoDevType.DEV_TYPE_Soft) {
            name.setText(R.string.soft_cert);
        }
        this.container_child.setVisibility(0);
    }

    private void applyCert() {
        String imsi = DeviceWrapper.getInstance().getIMSI();
        if (imsi == null || imsi.equals("")) {
            ModuleToast.show(this.context, R.string.get_imsi_failed);
            return;
        }
        ShareperencesUtil.saveCurrentDevType(this.context, this.chipBean.getType());
        ShareperencesUtil.saveDevCardID(this.context, this.cardID);
        if (this.recyclerViewAdapter != null) {
            this.recyclerViewAdapter.setIsRefresh(false);
        }
        ARouter.getInstance().build("/cert/phone_info").withSerializable("cardType", (Serializable)this.chipBeanType).withString("cardNum", this.cardID).navigation(this.getContext());
    }

    private void showChecking() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_loading, null, true);
        ImageView imageView = (ImageView)view.findViewById(R.id.iv_icon);
        AnimUtil.rotate(this.context, (View)imageView);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showErrorResponseLayout(String title, String message, boolean isReapply) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        ImageView imgView = (ImageView)view.findViewById(R.id.cert_item_top_two_img);
        TextView content = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        TextView fail_reason = (TextView)view.findViewById(R.id.fail_reason);
        View divider = view.findViewById(R.id.divider);
        View bottom_button_layout = view.findViewById(R.id.bottom_button_layout);
        TextView tv_apply = (TextView)view.findViewById(R.id.tv_apply);
        imgView.setImageResource(R.drawable.pic_gj_02);
        content.setText((CharSequence)title);
        fail_reason.setText((CharSequence)message);
        if (isReapply) {
            divider.setVisibility(0);
            bottom_button_layout.setVisibility(0);
            tv_apply.setText(R.string.reapply);
            bottom_button_layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.requestPhonePermission();
                }
            });
        } else {
            divider.setVisibility(8);
            bottom_button_layout.setVisibility(8);
        }
        if (message.contains(this.context.getString(R.string.server_error_short))) {
            tv_apply.setText(R.string.retry);
            tv_apply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showErrorResponseLayout(String message) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        view.findViewById(R.id.fail_reason).setVisibility(8);
        TextView button = (TextView)view.findViewById(R.id.tv_apply);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.requestPhonePermission();
            }
        });
        if (message.contains(this.context.getString(R.string.server_error_short)) || message.contains(this.context.getString(R.string.app_time_exception_user))) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        if (message.contains("\u5b89\u5168\u8bbe\u5907\u5931\u8d25")) {
            button.setText(R.string.retry);
            button.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CertItemView.this.cardID = DeviceWrapper.getInstance().getCardID(CertItemView.this.chipBeanType);
                    if (TextUtils.isEmpty((CharSequence)CertItemView.this.cardID)) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.card_not_exist));
                        return;
                    }
                    CertItemView.this.queryCertStateFromServer();
                }
            });
        }
        ImageView imgView = (ImageView)view.findViewById(R.id.cert_item_top_two_img);
        imgView.setImageResource(R.drawable.pic_gj_02);
        TextView content = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        content.setText((CharSequence)message);
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void show(String message, int click) {
    }

    private void showNoCert() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        view.findViewById(R.id.apply_cert_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertItemView.this.requestPhonePermission();
            }
        });
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    @Subscribe
    public void onPhonePermission(PhonePermissionResult phonePermissionResult) {
        if (phonePermissionResult.type == this.chipBeanType.getType()) {
            this.applyCert();
        }
    }

    private void requestPhonePermission() {
        OttoUtil.postRequestPhonePermission(this.chipBeanType.getType());
    }

    private void showOtherFailLayout(final int requestType, final String p10) {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_error, null);
        ImageView img = (ImageView)view.findViewById(R.id.cert_item_top_two_img);
        img.setImageResource(R.drawable.pic_gj_02);
        TextView content = (TextView)view.findViewById(R.id.cert_item_top_two_content);
        TextView reason = (TextView)view.findViewById(R.id.fail_reason);
        RelativeLayout reApply = (RelativeLayout)view.findViewById(R.id.bottom_button_layout);
        TextView tv_apply = (TextView)view.findViewById(R.id.tv_apply);
        int netRes = !CommonUtil.isNetworkConnected((Context)this.context) ? R.string.net_disconnected_text : R.string.net_timeout;
        int resText = -1;
        switch (requestType) {
            case 0: {
                if (this.chipBean.getCertBean() != null) {
                    this.showCertDetail(netRes, this.chipBean);
                    this.chipBean.setState(CertState.NET_ERROR);
                    view.setVisibility(8);
                    return;
                }
                resText = R.string.cert_state_query_fail;
                break;
            }
            case 1: {
                resText = R.string.register_fail_reapply;
                break;
            }
            case 2: {
                resText = R.string.authentiation_result_fail;
                break;
            }
            case 3: {
                resText = R.string.write_authentiation_fail;
            }
        }
        content.setText(netRes);
        reason.setText(resText);
        tv_apply.setText(R.string.retry);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                boolean isNetOK = CommonUtil.isNetworkConnected((Context)CertItemView.this.context);
                switch (requestType) {
                    case 0: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.queryCertStateFromServer();
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 1: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.applyCertRequest(p10);
                            ModuleLog.e("\u7533\u8bf7\u8bc1\u4e66 CertItemView showOtherFailLayout line 409");
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 2: {
                        if (isNetOK) {
                            CertItemView.this.showChecking();
                            CertItemView.this.queryAuthenticationResult();
                            break;
                        }
                        ModuleToast.show(CertItemView.this.context, R.string.net_disconnected_text);
                        break;
                    }
                    case 3: {
                        CertItemView.this.requestPhonePermission();
                    }
                }
            }
        });
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showRegisterFail() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_no_cert, null);
        TextView cert_item_top_one_content = (TextView)view.findViewById(R.id.cert_item_top_one_content);
        View reApply = view.findViewById(R.id.apply_cert_layout);
        cert_item_top_one_content.setText(R.string.register_fail_reapply);
        reApply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CertItemView.this.requestPhonePermission();
            }
        });
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showWaiteVerity() {
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.cert_item_layout_wait, null);
        view.findViewById(R.id.refresh).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CertItemView.this.showChecking();
                CertItemView.this.queryAuthenticationResult();
            }
        });
        this.container_child.removeAllViews();
        this.container_child.addView(view);
    }

    private void showCertDetail(final @StringRes int strRes, final ChipBean chipBean) {
        this.chipBean = chipBean;
        this.isCertOK = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final View view = LayoutInflater.from((Context)CertItemView.this.context).inflate(R.layout.cert_item_layout_detail, null);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        TextView tv_cert_state = (TextView)view.findViewById(R.id.tv_cert_state);
                        TextView tv_container = (TextView)view.findViewById(R.id.tv_container);
                        TextView tv_sn = (TextView)view.findViewById(R.id.tv_sn);
                        TextView tv_user = (TextView)view.findViewById(R.id.tv_user);
                        TextView tv_peroid = (TextView)view.findViewById(R.id.tv_peroid);
                        tv_container.setText((CharSequence)(CertItemView.this.context.getString(R.string.cert_container) + "      " + AppConfig.getInstance().getContainerID()));
                        tv_cert_state.setText(strRes);
                        CertDetailInfo certDetailInfo = chipBean.getCertBean();
                        String sn = CertItemView.this.context.getString(R.string.cert_sn) + "      " + certDetailInfo.sn;
                        tv_sn.setText((CharSequence)sn);
                        String owner = CertItemView.this.context.getString(R.string.cert_owner) + "      " + CertItemView.this.getCertHolder(certDetailInfo.subjectCn);
                        tv_user.setText((CharSequence)owner);
                        String peroid = CertItemView.this.context.getString(R.string.cert_period) + "  " + certDetailInfo.indate;
                        tv_peroid.setText((CharSequence)peroid);
                        CertItemView.this.container_child.removeAllViews();
                        CertItemView.this.container_child.addView(view);
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private String getCertHolder(String sn) {
        String[] split = sn.split(",");
        for (int i = 0; i < split.length; ++i) {
            String cnStr = split[i];
            if (!cnStr.contains("CN=")) continue;
            int beginIndex = 3;
            int length = cnStr.length();
            return split[i].substring(beginIndex, length);
        }
        return "";
    }

    private void queryCertStateFromServer() {
        this.showChecking();
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(0, null);
            return;
        }
        CertStateRequest certStateRequest = new CertStateRequest();
        if (this.chipBean.getCertBean() != null) {
            String sn = this.chipBean.getCertBean().sn;
            certStateRequest.setSn(sn);
        } else {
            certStateRequest.setSn("");
        }
        this.certService.certStateQuery(certStateRequest, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                String result = commonResponse.getResult();
                if (result.equals("0")) {
                    CertItemView.this.showCertDetail(R.string.revoke_ing, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.WAITING_AGREE_REVOKE);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("1")) {
                    CertItemView.this.showCertDetail(R.string.revoke_success, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.AGREE_REVOKE);
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("2")) {
                    CertItemView.this.showCertDetail(R.string.revoke_reject, CertItemView.this.chipBean);
                    CertItemView.this.chipBean.setState(CertState.REJECT_REVOKE);
                    CertItemView.this.chipBean.setReason(commonResponse.getMessage());
                    CertItemView.this.isCertOK = true;
                } else if (result.equals("3")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.cert_query_fail), CertItemView.this.context.getString(R.string.cert_not_incard), false);
                    } else {
                        CertItemView.this.isCertOK = true;
                        if (CertItemView.this.chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_out_of_date, CertItemView.this.chipBean);
                        } else {
                            CertItemView.this.chipBean.setState(CertState.SUCCESS);
                            CertItemView.this.showCertDetail(R.string.normal_state, CertItemView.this.chipBean);
                        }
                    }
                } else if (result.equals("4")) {
                    if (CertItemView.this.isChipBeanSizeIsZero()) {
                        CertItemView.this.queryAuthenticationResult();
                    } else {
                        CertItemView.this.showCertDetail(R.string.server_nocert, CertItemView.this.chipBean);
                        CertItemView.this.chipBean.setState(CertState.SERVER_NOCERT);
                    }
                } else if (result.equals("5")) {
                    CertItemView.this.showCertDetail(R.string.be_frozen, CertItemView.this.chipBean);
                } else if (result.equals("6")) {
                    CertItemView.this.showCertDetail(R.string.thaw_ing, CertItemView.this.chipBean);
                } else if (result.equals("7")) {
                    CertItemView.this.showCertDetail(R.string.thaw_reject, CertItemView.this.chipBean);
                } else if (result.equals("8")) {
                    CertItemView.this.showCertDetail(R.string.delay_ing, CertItemView.this.chipBean);
                } else if (result.equals("9")) {
                    CertItemView.this.showCertDetail(R.string.normal_state, CertItemView.this.chipBean);
                } else if (result.equals("10")) {
                    CertItemView.this.showCertDetail(R.string.delay_reject, CertItemView.this.chipBean);
                } else if (result.equals("11")) {
                    CertItemView.this.showCertDetail(R.string.update_ing, CertItemView.this.chipBean);
                } else if (result.equals("12")) {
                    CertItemView.this.chipBean.setState(CertState.AGREE_UPDATE);
                    CertItemView.this.showCertDetail(R.string.normal_state, CertItemView.this.chipBean);
                } else if (result.equals("13")) {
                    CertItemView.this.showCertDetail(R.string.update_reject, CertItemView.this.chipBean);
                } else if (result.equals("14")) {
                    CertItemView.this.chipBean.setState(CertState.CERT_OUT_OF_DATE);
                    CertItemView.this.showCertDetail(R.string.cert_out_of_date, CertItemView.this.chipBean);
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void updateCertState(ChipBean chipBean) {
        if (chipBean.getType() != this.chipBeanType.getType()) {
            return;
        }
        CertState state = chipBean.getState();
        if (state == CertState.AGREE_UPDATE) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state, chipBean);
        } else if (state == CertState.WAITING_AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_ing, chipBean);
            chipBean.setState(CertState.WAITING_AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.AGREE_REVOKE) {
            this.showCertDetail(R.string.revoke_success, chipBean);
            chipBean.setState(CertState.AGREE_REVOKE);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_PROGRESS) {
            this.showCertDetail(R.string.recovery_progress, chipBean);
            chipBean.setState(CertState.RECOVERY_PROGRESS);
            this.isCertOK = true;
        } else if (state == CertState.RECOVERY_SUCCESS) {
            this.isCertOK = true;
            chipBean.setState(CertState.SUCCESS);
            this.showCertDetail(R.string.normal_state, chipBean);
        } else {
            this.isCertOK = false;
            this.showNoCert();
        }
    }

    private void writeCert(final String cert2) {
        if (TextUtils.isEmpty((CharSequence)cert2)) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final int result = DeviceWrapper.getInstance().importCert(CertItemView.this.chipBeanType, cert2);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (result == 0) {
                            CertItemView.this.showCertDetail(CertItemView.this.chipBeanType);
                        } else {
                            CertItemView.this.writeCertToServer(cert2, "1");
                        }
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void showCertDetail(final CryptoDevType cryptoDevType) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final CertDetailInfo certDetailInfo = DeviceWrapper.getInstance().readCertFromContainer(cryptoDevType, 0);
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ChipBean chipBean = new ChipBean();
                        chipBean.setType(CertItemView.this.chipBean.getType());
                        if (chipBean.getState() == CertState.CERT_OUT_OF_DATE) {
                            chipBean.setState(CertState.CERT_OUT_OF_DATE);
                            CertItemView.this.showCertDetail(R.string.cert_out_of_date, chipBean);
                        } else {
                            chipBean.setState(CertState.SUCCESS);
                            CertItemView.this.showCertDetail(R.string.normal_state, chipBean);
                        }
                        chipBean.setCertDetailInfo(certDetailInfo);
                        chipBean.setName(CertItemView.this.getBeanName(CertItemView.this.chipBeanType));
                    }
                }, 10L);
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void writeCertToServer(final String cert2, final String status) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String sn = DeviceWrapper.getInstance().getSn(CertItemView.this.chipBeanType, cert2);
                ModuleToast.show(CertItemView.this.context, R.string.import_cert_fail);
                final WriteFailRequest request = new WriteFailRequest();
                WriteFailInfo info = new WriteFailInfo();
                info.setSn(sn);
                info.setStatus(status);
                info.setTime(System.currentTimeMillis());
                request.setInfo(info);
                final String sign = DeviceWrapper.getInstance().signData(CertItemView.this.chipBeanType, info.toString());
                CertItemView.this.myHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (sign.startsWith("errorCode")) {
                            CertItemView.this.showErrorResponseLayout(sign.substring(9));
                        } else {
                            request.setSign(sign);
                            CertItemView.this.uploadWriteCertResult(request);
                        }
                    }
                });
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void uploadWriteCertResult(RequestBody request) {
        this.certService.uploadWriteCertResult(request, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(0, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                ModuleLog.e("\u4e0a\u62a5\u5199\u5361\u5931\u8d25\u6210\u529f\uff1a ");
                CertItemView.this.showOtherFailLayout(3, "");
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private int getBeanName(CryptoDevType type) {
        switch (type) {
            case DEV_TYPE_SdCard: {
                return R.string.tf_cert;
            }
            case DEV_TYPE_Chip: {
                return R.string.chip_cert;
            }
            case DEV_TYPE_SimKey: {
                return R.string.tiemo_cert;
            }
            case DEV_TYPE_Soft: {
                return R.string.soft_cert;
            }
        }
        return R.string.chip_cert;
    }

    private boolean isChipBeanSizeIsZero() {
        return this.chipBean.getState() == CertState.NO_CERT;
    }

    private void queryAuthenticationResult() {
        int company = AppConfig.getInstance().getLiveCompany();
        if (company == 3) {
            this.showNoCert();
            return;
        }
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            this.showOtherFailLayout(2, null);
            return;
        }
        int checkResult = ShareperencesUtil.getCheckResult(this.context, this.chipBeanType.getType());
        if (checkResult != 0) {
            this.showNoCert();
            return;
        }
        String identityNum = ShareperencesUtil.getIDCardNo(this.context, this.chipBean.getType());
        this.certService.queryAuthenticationResult(identityNum, this.cardID, new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
                if (e instanceof CardNotExistException) {
                    CertItemView.this.showErrorResponseLayout("\u8bbe\u5907\u4e0d\u5b58\u5728", "\u8bf7\u91cd\u65b0\u7533\u8bf7", true);
                } else {
                    e.printStackTrace();
                }
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(2, null);
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                CertItemView.this.handleAuthResult(commonResponse);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void handleErrorResponse(String errorCode) {
        if (errorCode.equals(OkNetError.NOT_FOUND_CHECK_INFO_CODE)) {
            this.showNoCert();
        } else if (errorCode.equals(OkNetError.NOT_EXIST_INFO_CODE)) {
            if (this.isChipBeanSizeIsZero()) {
                this.queryAuthenticationResult();
            } else {
                this.chipBean.setState(CertState.SERVER_NOCERT);
                this.showCertDetail(R.string.server_nocert, this.chipBean);
            }
        } else {
            String msg = OkNetError.handleErrorCodeToMsg(this.context, errorCode);
            this.showErrorResponseLayout(msg);
        }
    }

    private void applyCertRequest(final String p10) {
        if (!CommonUtil.isNetworkConnected((Context)this.context)) {
            ModuleToast.show(this.context, R.string.net_disconnected_text);
            return;
        }
        if (p10.startsWith("errorCode")) {
            if (p10.contains("^[0-6]*$")) {
                // empty if block
            }
            this.handleErrorResponse(p10.substring(9));
            return;
        }
        if (p10.isEmpty()) {
            // empty if block
        }
        CertApplyRequest certApplyRequest = new CertApplyRequest();
        ChipInfo chipInfo = new ChipInfo();
        DeviceWrapper deviceWrapper = DeviceWrapper.getInstance();
        chipInfo.setCardType("" + Util.convertCardType(this.chipBean.getType()));
        chipInfo.setImei(deviceWrapper.getIMEI());
        String imsi = deviceWrapper.getIMSI();
        if (imsi == null || imsi.equals("")) {
            this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), this.context.getString(R.string.get_imsi_failed), true);
            return;
        }
        chipInfo.setImsi(deviceWrapper.getIMSI());
        chipInfo.setPhone(ShareperencesUtil.getPhoneNum(this.context));
        certApplyRequest.setChipInfo(chipInfo);
        MobileInfo mobileInfo = new MobileInfo();
        mobileInfo.setCommType(DeviceUtil.getInstance().getOperator() + "");
        mobileInfo.setTerminalBand(DeviceUtil.getInstance().getBrand());
        mobileInfo.setTerminalType("1");
        certApplyRequest.setMobileInfo(mobileInfo);
        int liveCompany = AppConfig.getInstance().getLiveCompany();
        if (liveCompany != 3) {
            certApplyRequest.setIdentityNo(ShareperencesUtil.getIDCardNo(this.context, this.chipBean.getType()));
        } else {
            certApplyRequest.setIdentityNo(ShareperencesUtil.getPhoneNum(this.context));
        }
        certApplyRequest.setP10(p10);
        this.certService.applyCert(certApplyRequest, this.cardID, new HttpResponseCallBack<CertApplyResponse>(){

            @Override
            public void onOtherException(Exception e) {
                e.printStackTrace();
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
                CertItemView.this.showOtherFailLayout(1, p10);
            }

            @Override
            public void onSuccessfulResponse(Call call, CertApplyResponse certApplyResponse) {
                String cert2 = certApplyResponse.getCert();
                CertItemView.this.writeCert(cert2);
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
                String errorCode = baseErrorResponse.getErrCode();
                CertItemView.this.handleErrorResponse(errorCode);
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    @Subscribe
    public void onPhoneResult(PhoneResult result) {
        if (result != null) {
            this.handlePhoneResult(result);
        }
    }

    private void handlePhoneResult(PhoneResult auth) {
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        if (this.chipBeanType == null || type == null) {
            return;
        }
        if (type.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (result.isSuccess()) {
            String ret = result.getResult();
            ShareperencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
            switch (ret) {
                case "0": {
                    break;
                }
                case "1": 
                case "2": {
                    this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), this.context.getString(R.string.phone_number_wrong), true);
                }
            }
        }
    }

    @Subscribe
    public void onAuthResult(AuthResult result) {
        if (result != null) {
            this.handleAuthResult(result);
        }
    }

    private void handleAuthResult(AuthResult auth) {
        CryptoDevType type = auth.getType();
        CompareResult result = auth.getResult();
        if (this.chipBeanType == null || type == null) {
            return;
        }
        if (type.getType() != this.chipBeanType.getType()) {
            return;
        }
        if (result.isSuccess()) {
            this.handleAuthResult(result);
        } else {
            String message = result.getMessage();
            if (TextUtils.isEmpty((CharSequence)message)) {
                this.showRegisterFail();
            } else {
                this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), OkNetError.handleErrorCodeToMsg(this.context, result.getErrCode()), true);
            }
        }
    }

    private void handleAuthResult(CommonResponse result) {
        this.showChecking();
        String ret = result.getResult();
        ShareperencesUtil.saveCheckResult(this.context, this.chipBeanType.getType(), Integer.parseInt(ret));
        switch (ret) {
            case "0": {
                this.showWaiteVerity();
                break;
            }
            case "1": {
                String message = result.getMessage();
                this.getP10ReqestBCAndApplyCert(message);
                break;
            }
            case "2": {
                String message = result.getMessage();
                if (TextUtils.isEmpty((CharSequence)message)) {
                    this.showRegisterFail();
                    break;
                }
                this.showErrorResponseLayout(this.context.getString(R.string.register_fail_reapply), message, true);
            }
        }
    }

    private void getP10ReqestBCAndApplyCert(final String dn) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                final String p10ReqestBC = PKCS10Utils.getInstance().getP10RequestBC(CertItemView.this.chipBeanType, dn, true);
                if (TextUtils.isEmpty((CharSequence)p10ReqestBC)) {
                    CertItemView.this.myHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            CertItemView.this.showErrorResponseLayout(CertItemView.this.context.getString(R.string.register_fail_reapply), CertItemView.this.context.getString(R.string.device_not_exist), true);
                        }
                    }, 10L);
                    return;
                }
                CertItemView.this.myHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CertItemView.this.applyCertRequest(p10ReqestBC);
                    }
                }, 10L);
            }
        };
        ModuleLog.e("CertItemView getP10ReqestBCAndApplyCert \u7533\u8bf7\u8bc1\u4e66");
        this.chipExecutorService.exe(runnable);
    }

    public void onDestory() {
        BusProvider.unRegister((Object)((Object)this));
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertItemView> {
        public MyHandler(CertItemView reference) {
            super((Object)reference);
        }

        protected void handleMessage(CertItemView reference, Message msg) {
            reference.chipBean = (ChipBean)msg.obj;
            if (msg.what == 0) {
                if (reference.chipBean.getState() == CertState.SUCCESS && !reference.chipBean.getIsVerify()) {
                    reference.showCertDetail(R.string.cert_not_in_system, reference.chipBean);
                } else {
                    reference.queryCertStateFromServer();
                }
            } else if (reference.chipBean.getState() == CertState.NO_CERT) {
                reference.showNoCert();
            } else {
                reference.showCertDetail(R.string.normal_state, reference.chipBean);
            }
        }
    }
}

