/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.yishu;

import android.app.Activity;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import com.xdja.safeclient.certcreation.R;
import java.util.Set;

public class DeviceListActivity
extends Activity {
    private static final String TAG = "ListDataActivity";
    private static final boolean D = true;
    public static String EXTRA_DEVICE_ADDRESS = "device_address";
    private BluetoothAdapter mBtAdapter;
    private ArrayAdapter<String> mPairedDevicesArrayAdapter;
    private ArrayAdapter<String> mNewDevicesArrayAdapter;
    private AdapterView.OnItemClickListener mDeviceClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> av, View v, int arg2, long arg3) {
            DeviceListActivity.this.mBtAdapter.cancelDiscovery();
            String info = ((TextView)v).getText().toString();
            String address = info.substring(info.length() - 17);
            Intent intent = new Intent();
            intent.putExtra(EXTRA_DEVICE_ADDRESS, address);
            DeviceListActivity.this.setResult(-1, intent);
            DeviceListActivity.this.finish();
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.bluetooth.device.action.FOUND".equals(action)) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (device.getBondState() != 12) {
                    DeviceListActivity.this.mNewDevicesArrayAdapter.add((Object)(device.getName() + "\n" + device.getAddress()));
                }
            } else if ("android.bluetooth.adapter.action.DISCOVERY_FINISHED".equals(action)) {
                DeviceListActivity.this.setProgressBarIndeterminateVisibility(false);
                DeviceListActivity.this.setTitle(R.string.select_device);
                if (DeviceListActivity.this.mNewDevicesArrayAdapter.getCount() == 0) {
                    String noDevices = DeviceListActivity.this.getResources().getText(R.string.none_found).toString();
                    DeviceListActivity.this.mNewDevicesArrayAdapter.add((Object)noDevices);
                }
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(5);
        this.setContentView(R.layout.device_list);
        this.setResult(0);
        Button scanButton = (Button)this.findViewById(R.id.button_scan);
        scanButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                DeviceListActivity.this.doDiscovery();
                v.setVisibility(8);
            }
        });
        this.mPairedDevicesArrayAdapter = new ArrayAdapter((Context)this, R.layout.device_name);
        this.mNewDevicesArrayAdapter = new ArrayAdapter((Context)this, R.layout.device_name);
        ListView pairedListView = (ListView)this.findViewById(R.id.paired_devices);
        pairedListView.setAdapter(this.mPairedDevicesArrayAdapter);
        pairedListView.setOnItemClickListener(this.mDeviceClickListener);
        ListView newDevicesListView = (ListView)this.findViewById(R.id.new_devices);
        newDevicesListView.setAdapter(this.mNewDevicesArrayAdapter);
        newDevicesListView.setOnItemClickListener(this.mDeviceClickListener);
        IntentFilter filter = new IntentFilter("android.bluetooth.device.action.FOUND");
        this.registerReceiver(this.mReceiver, filter);
        filter = new IntentFilter("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        this.registerReceiver(this.mReceiver, filter);
        this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        Set pairedDevices = this.mBtAdapter.getBondedDevices();
        if (pairedDevices.size() > 0) {
            this.findViewById(R.id.title_paired_devices).setVisibility(0);
            for (BluetoothDevice device : pairedDevices) {
                this.mPairedDevicesArrayAdapter.add((Object)(device.getName() + "\n" + device.getAddress()));
            }
        } else {
            String noDevices = this.getResources().getText(R.string.none_paired).toString();
            this.mPairedDevicesArrayAdapter.add((Object)noDevices);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mBtAdapter != null) {
            this.mBtAdapter.cancelDiscovery();
        }
        this.unregisterReceiver(this.mReceiver);
    }

    private void doDiscovery() {
        Log.d((String)TAG, (String)"doDiscovery()");
        this.setProgressBarIndeterminateVisibility(true);
        this.setTitle(R.string.scanning);
        this.findViewById(R.id.title_new_devices).setVisibility(0);
        if (this.mBtAdapter.isDiscovering()) {
            this.mBtAdapter.cancelDiscovery();
        }
        this.mBtAdapter.startDiscovery();
    }
}

