/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.Serializable;

@Route(name="\u6301\u8bc1\u62cd\u7167\u51c6\u5907", path="/cert/camera_ready")
public class CameraReadyActivity
extends BaseActivity {
    @Autowired(name="photoType")
    public int photoType;
    @Autowired(name="cardNum")
    String cardNum;
    @Autowired(name="cardType")
    CryptoDevType cardType;
    @Autowired(name="phone")
    String phone;
    @Autowired(name="containerNum")
    public int containerNum;
    TextView tv_tips1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_ready);
        this.hideBG();
        this.cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType((Context)this));
        this.cardNum = DeviceWrapper.getInstance().getCardID(this.cardType);
        this.phone = SharePreferencesUtil.getPhoneNum((Context)this);
        if (TextUtils.isEmpty((CharSequence)this.cardNum)) {
            ModuleToast.show(this.context, R.string.cert_creation_card_device_error);
            return;
        }
        Button bt_startdect = (Button)this.findViewById(R.id.start);
        bt_startdect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraReadyActivity.this.next();
            }
        });
        this.tv_tips1 = (TextView)this.findViewById(R.id.hint1);
        if (ScreenUtil.isFullScreen((Activity)this)) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(0, ScreenUtil.dip2px(this.context, 50.0f), 0, 0);
            layoutParams.addRule(14);
            this.tv_tips1.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0;
    }

    @Override
    public String nextActivity() {
        return "/cert/selfie";
    }

    @Override
    public void route() {
        super.route();
        Intent intent = new Intent(this.context, SelfieActivity.class);
        intent.putExtra("photoType", this.photoType);
        intent.putExtra("cardNum", this.cardNum);
        intent.putExtra("cardType", (Serializable)this.cardType);
        intent.putExtra("phone", this.phone);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
    }

    @XdjaPermission(permissions={"android.permission.CAMERA"})
    private void requestCamera() {
    }

    protected void onResume() {
        super.onResume();
        this.left_title_tv.setText(R.string.cert_creation_selfie_photo_ready_title);
    }

    protected void onPause() {
        super.onPause();
        this.left_title_tv.setText((CharSequence)"");
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (permissions[0].equals("android.permission.CAMERA") && grantResults[0] == 0) {
            this.next();
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_ready_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        this.finish();
    }
}

