/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.aircert.dialog.BindIdentifyDialog;
import com.aircert.dialog.SinglePermissionDialog;
import com.aircert.util.HTMLText;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.raizlabs.android.dbflow.config.FlowConfig;
import com.raizlabs.android.dbflow.config.FlowLog;
import com.raizlabs.android.dbflow.config.FlowManager;
import com.raizlabs.android.dbflow.config.cert_creationGeneratedDatabaseHolder;
import com.raizlabs.android.dbflow.sql.language.SQLite;
import com.raizlabs.android.dbflow.sql.language.property.IProperty;
import com.raizlabs.android.dbflow.structure.database.AndroidDatabase;
import com.raizlabs.android.dbflow.structure.database.DatabaseWrapper;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.ConfigStep2Activity;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.databases.ServerSettingConfig;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.EditTextUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.util.ArrayList;

@Route(path="/cert/config_step1", name="\u7b2c\u4e00\u4e2a\u914d\u7f6e\u754c\u9762")
public class ConfigStep1Activity
extends BaseActivity
implements View.OnClickListener {
    private View next;
    private EditText etProjectName;
    private Button addAddress;
    private EditText etVHSMIP1;
    private EditText etVHSMPort1;
    private Button addVHSM;
    private int navigateType;
    private EditText serverIP1;
    private EditText serverPort1;
    private LinearLayout topLayout1;
    private ImageView deleteServer2;
    private LinearLayout topLayout2;
    private EditText serverIP2;
    private EditText serverPort2;
    private RelativeLayout serverLayout2;
    private ImageView deleteServer3;
    private LinearLayout topLayout3;
    private EditText serverIP3;
    private EditText serverPort3;
    private RelativeLayout serverLayout3;
    private ImageView deleteServer4;
    private LinearLayout topLayout4;
    private EditText serverIP4;
    private EditText serverPort4;
    private RelativeLayout serverLayout4;
    private EditText vhsmIP1;
    private EditText vhsmPort1;
    private LinearLayout vhsmTopLayout1;
    private ImageView deleteVHSM2;
    private LinearLayout vhsmTopLayout2;
    private EditText vhsmIP2;
    private EditText vhsmPort2;
    private RelativeLayout vhsmLayout2;
    private ImageView deleteVHSM3;
    private LinearLayout vhsmTopLayout3;
    private EditText vhsmIP3;
    private EditText vhsmPort3;
    private RelativeLayout vhsmLayout3;
    private ImageView deleteVHSM4;
    private LinearLayout vhsmTopLayout4;
    private EditText vhsmIP4;
    private EditText vhsmPort4;
    private RelativeLayout vhsmLayout4;
    private View vhsmLayout;
    private CheckBox enableVHSM;
    private ScrollView scrollView;
    private ArrayList<ServerAddress> serverAddressesList = new ArrayList();
    private ArrayList<ServerAddress> vhsmAddressList = new ArrayList();
    private boolean show = true;
    private String[] permissions = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};

    private void initVHSMLayout() {
        this.vhsmIP1 = (EditText)this.findViewById(R.id.vhsm_ip_1);
        this.vhsmIP2 = (EditText)this.findViewById(R.id.vhsm_ip_2);
        this.vhsmIP3 = (EditText)this.findViewById(R.id.vhsm_ip_3);
        this.vhsmIP4 = (EditText)this.findViewById(R.id.vhsm_ip_4);
        this.vhsmPort1 = (EditText)this.findViewById(R.id.vhsm_port_1);
        this.vhsmPort2 = (EditText)this.findViewById(R.id.vhsm_port_2);
        this.vhsmPort3 = (EditText)this.findViewById(R.id.vhsm_port_3);
        this.vhsmPort4 = (EditText)this.findViewById(R.id.vhsm_port_4);
        this.deleteVHSM2 = (ImageView)this.findViewById(R.id.delete_vhsm_2);
        this.deleteVHSM3 = (ImageView)this.findViewById(R.id.delete_vhsm_3);
        this.deleteVHSM4 = (ImageView)this.findViewById(R.id.delete_vhsm_4);
        this.deleteVHSM2.setOnClickListener((View.OnClickListener)this);
        this.deleteVHSM3.setOnClickListener((View.OnClickListener)this);
        this.deleteVHSM4.setOnClickListener((View.OnClickListener)this);
        this.vhsmTopLayout1 = (LinearLayout)this.findViewById(R.id.vhsm_top_layout_1);
        this.vhsmTopLayout2 = (LinearLayout)this.findViewById(R.id.vhsm_top_layout_2);
        this.vhsmTopLayout3 = (LinearLayout)this.findViewById(R.id.vhsm_top_layout_3);
        this.vhsmTopLayout4 = (LinearLayout)this.findViewById(R.id.vhsm_top_layout_4);
        this.vhsmLayout2 = (RelativeLayout)this.findViewById(R.id.vhsm_layout_2);
        this.vhsmLayout3 = (RelativeLayout)this.findViewById(R.id.vhsm_layout_3);
        this.vhsmLayout4 = (RelativeLayout)this.findViewById(R.id.vhsm_layout_4);
        this.vhsmLayout = this.findViewById(R.id.vhsm_layout);
        this.enableVHSM = (CheckBox)this.findViewById(R.id.enable_vhsm);
        this.enableVHSM.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                ConfigStep1Activity.this.onSwitchOnClick(b);
            }
        });
    }

    private void initServerLayout() {
        this.serverIP1 = (EditText)this.findViewById(R.id.server_ip_1);
        this.serverPort1 = (EditText)this.findViewById(R.id.server_port_1);
        this.topLayout1 = (LinearLayout)this.findViewById(R.id.top_layout_1);
        this.serverAddressesList.add(new ServerAddress("", ""));
        this.vhsmAddressList.add(new ServerAddress("", ""));
        this.deleteServer2 = (ImageView)this.findViewById(R.id.delete_server_2);
        this.deleteServer2.setOnClickListener((View.OnClickListener)this);
        this.serverIP2 = (EditText)this.findViewById(R.id.server_ip_2);
        this.serverPort2 = (EditText)this.findViewById(R.id.server_port_2);
        this.topLayout2 = (LinearLayout)this.findViewById(R.id.top_layout_2);
        this.serverLayout2 = (RelativeLayout)this.findViewById(R.id.server_layout_2);
        this.deleteServer3 = (ImageView)this.findViewById(R.id.delete_server_3);
        this.deleteServer3.setOnClickListener((View.OnClickListener)this);
        this.serverIP3 = (EditText)this.findViewById(R.id.server_ip_3);
        this.serverPort3 = (EditText)this.findViewById(R.id.server_port_3);
        this.topLayout3 = (LinearLayout)this.findViewById(R.id.top_layout_3);
        this.serverLayout3 = (RelativeLayout)this.findViewById(R.id.server_layout_3);
        this.deleteServer4 = (ImageView)this.findViewById(R.id.delete_server_4);
        this.deleteServer4.setOnClickListener((View.OnClickListener)this);
        this.serverIP4 = (EditText)this.findViewById(R.id.server_ip_4);
        this.serverPort4 = (EditText)this.findViewById(R.id.server_port_4);
        this.serverLayout4 = (RelativeLayout)this.findViewById(R.id.server_layout_4);
        this.topLayout4 = (LinearLayout)this.findViewById(R.id.top_layout_4);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.navigateType = 0;
        super.onCreate(savedInstanceState);
        FlowManager.init((FlowConfig)new FlowConfig.Builder(this.context).addDatabaseHolder(cert_creationGeneratedDatabaseHolder.class).build());
        FlowLog.setMinimumLoggingLevel((FlowLog.Level)FlowLog.Level.V);
        DatabaseWrapper wrapper = FlowManager.getDatabase((String)"certDataBase").getHelper().getDelegate().getWritableDatabase();
        boolean isWAL = ((AndroidDatabase)wrapper).getDatabase().isWriteAheadLoggingEnabled();
        ((AndroidDatabase)wrapper).getDatabase().disableWriteAheadLogging();
        this.getWindow().setSoftInputMode(32);
        this.setContentView(R.layout.activity_config_step1);
        if (!this.checkValidPermission(this.permissions)) {
            this.showInvalidPermissionDialog();
        }
        this.initView();
        this.initViewByData();
    }

    protected int getToolbarType() {
        return this.navigateType;
    }

    private void initView() {
        this.leftBtn.setVisibility(0);
        this.scrollView = (ScrollView)this.findViewById(R.id.scroll);
        this.etProjectName = (EditText)this.findViewById(R.id.project_name);
        this.etProjectName.setFilters(EditTextUtil.getDisableEmojFilter(20));
        this.etVHSMIP1 = (EditText)this.findViewById(R.id.vhsm_ip_1);
        this.etVHSMIP1.setFilters(EditTextUtil.getDisableEmojFilter());
        this.etVHSMPort1 = (EditText)this.findViewById(R.id.vhsm_port_1);
        this.etVHSMPort1.setFilters(EditTextUtil.getDisableEmojFilter());
        this.next = this.findViewById(R.id.next);
        this.next.setOnClickListener((View.OnClickListener)this);
        this.addAddress = (Button)this.findViewById(R.id.add_address);
        this.addAddress.setOnClickListener((View.OnClickListener)this);
        this.addVHSM = (Button)this.findViewById(R.id.add_vhsm);
        this.addVHSM.setOnClickListener((View.OnClickListener)this);
        this.initServerLayout();
        this.initVHSMLayout();
    }

    private void initViewByData() {
        ServerSettingConfig serverSettingConfig = (ServerSettingConfig)SQLite.select((IProperty[])new IProperty[0]).from(ServerSettingConfig.class).querySingle();
        if (serverSettingConfig == null) {
            return;
        }
        String projectName = serverSettingConfig.getProjectName();
        if (!TextUtils.isEmpty((CharSequence)projectName)) {
            this.etProjectName.setText((CharSequence)projectName);
        }
        this.initServerAddressByData(serverSettingConfig);
        this.initVHSMAddressByData(serverSettingConfig);
    }

    private void initServerAddressByData(ServerSettingConfig serverSettingConfig) {
        int count;
        String ip = serverSettingConfig.getIp();
        String port = serverSettingConfig.getPort();
        if (TextUtils.isEmpty((CharSequence)ip)) {
            return;
        }
        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");
        this.serverAddressesList.clear();
        for (count = 0; count < ipArray.length; ++count) {
            this.serverAddressesList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }
        count = ipArray.length;
        if (count == 0) {
            return;
        }
        if (count > 3) {
            this.serverIP4.setText((CharSequence)ipArray[3]);
            this.serverPort4.setText((CharSequence)portArray[3]);
            this.serverLayout4.setVisibility(0);
        }
        if (count > 2) {
            this.serverIP3.setText((CharSequence)ipArray[2]);
            this.serverPort3.setText((CharSequence)portArray[2]);
            this.serverLayout3.setVisibility(0);
        }
        if (count > 1) {
            this.serverIP2.setText((CharSequence)ipArray[1]);
            this.serverPort2.setText((CharSequence)portArray[1]);
            this.serverLayout2.setVisibility(0);
        }
        this.serverIP1.setText((CharSequence)ipArray[0]);
        this.serverPort1.setText((CharSequence)portArray[0]);
    }

    private void initVHSMAddressByData(ServerSettingConfig serverSettingConfig) {
        int count;
        String ip = serverSettingConfig.getVhsm_ip();
        String port = serverSettingConfig.getVhsm_port();
        if (TextUtils.isEmpty((CharSequence)ip)) {
            return;
        }
        String[] ipArray = ip.split("\\|");
        String[] portArray = port.split("\\|");
        this.vhsmAddressList.clear();
        for (count = 0; count < ipArray.length; ++count) {
            this.vhsmAddressList.add(count, new ServerAddress(ipArray[count], portArray[count]));
        }
        count = ipArray.length;
        if (count == 0) {
            return;
        }
        if (count > 3) {
            this.vhsmIP4.setText((CharSequence)ipArray[3]);
            this.vhsmPort4.setText((CharSequence)portArray[3]);
            this.vhsmLayout4.setVisibility(0);
        }
        if (count > 2) {
            this.vhsmIP3.setText((CharSequence)ipArray[2]);
            this.vhsmPort3.setText((CharSequence)portArray[2]);
            this.vhsmLayout3.setVisibility(0);
        }
        if (count > 1) {
            this.vhsmIP2.setText((CharSequence)ipArray[1]);
            this.vhsmPort2.setText((CharSequence)portArray[1]);
            this.vhsmLayout2.setVisibility(0);
        }
        this.vhsmIP1.setText((CharSequence)ipArray[0]);
        this.vhsmPort1.setText((CharSequence)portArray[0]);
        if (serverSettingConfig.enableVHSM) {
            this.enableVHSM.setChecked(true);
            this.vhsmLayout.setVisibility(0);
        } else {
            this.enableVHSM.setChecked(false);
            this.vhsmLayout.setVisibility(8);
        }
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.next) {
            this.next();
        } else if (id2 == R.id.add_address) {
            this.addServerAddress();
        } else if (id2 == R.id.add_vhsm) {
            this.addVHSMAddress();
        } else if (id2 == R.id.delete_server_2) {
            this.deleteServerAddress(2);
        } else if (id2 == R.id.delete_server_3) {
            this.deleteServerAddress(3);
        } else if (id2 == R.id.delete_server_4) {
            this.deleteServerAddress(4);
        } else if (id2 == R.id.delete_vhsm_2) {
            this.deleteVHSMAddress(2);
        } else if (id2 == R.id.delete_vhsm_3) {
            this.deleteVHSMAddress(3);
        } else if (id2 == R.id.delete_vhsm_4) {
            this.deleteVHSMAddress(4);
        }
    }

    private void deleteServerAddress(int num) {
        this.saveCurrentServerAddress();
        if (this.serverAddressesList.size() == 4) {
            this.serverIP4.setText((CharSequence)"");
            this.serverPort4.setText((CharSequence)"");
            this.serverLayout4.setVisibility(8);
            this.topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (this.serverAddressesList.size() == 3) {
            this.serverIP3.setText((CharSequence)"");
            this.serverPort3.setText((CharSequence)"");
            this.serverLayout3.setVisibility(8);
            this.topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (this.serverAddressesList.size() == 2) {
            this.serverIP2.setText((CharSequence)"");
            this.serverPort2.setText((CharSequence)"");
            this.serverLayout2.setVisibility(8);
            this.topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        }
        this.serverAddressesList.remove(num - 1);
        this.refreshServerValue();
    }

    private void deleteVHSMAddress(int num) {
        this.saveCurrentVHSMAddress();
        if (this.vhsmAddressList.size() == 4) {
            this.vhsmIP4.setText((CharSequence)"");
            this.vhsmPort4.setText((CharSequence)"");
            this.vhsmLayout4.setVisibility(8);
            this.vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (this.vhsmAddressList.size() == 3) {
            this.vhsmIP3.setText((CharSequence)"");
            this.vhsmPort3.setText((CharSequence)"");
            this.vhsmLayout3.setVisibility(8);
            this.vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (this.vhsmAddressList.size() == 2) {
            this.vhsmIP2.setText((CharSequence)"");
            this.vhsmPort2.setText((CharSequence)"");
            this.vhsmLayout2.setVisibility(8);
            this.vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        }
        this.vhsmAddressList.remove(num - 1);
        this.refreshVHSMValue();
    }

    private void refreshServerValue() {
        if (this.serverLayout2.getVisibility() == 0) {
            this.serverIP2.setText((CharSequence)this.serverAddressesList.get(1).getIp());
            this.serverPort2.setText((CharSequence)this.serverAddressesList.get(1).getPort());
        }
        if (this.serverLayout3.getVisibility() == 0) {
            this.serverIP3.setText((CharSequence)this.serverAddressesList.get(2).getIp());
            this.serverPort3.setText((CharSequence)this.serverAddressesList.get(2).getPort());
        }
    }

    private void refreshVHSMValue() {
        if (this.vhsmLayout2.getVisibility() == 0) {
            this.vhsmIP2.setText((CharSequence)this.vhsmAddressList.get(1).getIp());
            this.vhsmPort2.setText((CharSequence)this.vhsmAddressList.get(1).getPort());
        }
        if (this.vhsmLayout3.getVisibility() == 0) {
            this.vhsmIP3.setText((CharSequence)this.vhsmAddressList.get(2).getIp());
            this.vhsmPort3.setText((CharSequence)this.vhsmAddressList.get(2).getPort());
        }
    }

    private void addServerAddress() {
        if (this.serverLayout4.getVisibility() == 0) {
            ModuleToast.show(this.context, R.string.cert_creation_max_server_address);
            return;
        }
        this.serverAddressesList.add(new ServerAddress("", ""));
        if (this.serverLayout2.getVisibility() == 0) {
            if (this.serverLayout3.getVisibility() == 0) {
                this.serverLayout4.setVisibility(0);
            } else {
                this.serverLayout3.setVisibility(0);
            }
        } else {
            this.serverLayout2.setVisibility(0);
        }
    }

    private void addVHSMAddress() {
        if (this.vhsmLayout4.getVisibility() == 0) {
            ModuleToast.show(this.context, R.string.cert_creation_max_server_address);
            return;
        }
        this.vhsmAddressList.add(new ServerAddress("", ""));
        if (this.vhsmLayout2.getVisibility() == 0) {
            if (this.vhsmLayout3.getVisibility() == 0) {
                this.vhsmLayout4.setVisibility(0);
            } else {
                this.vhsmLayout3.setVisibility(0);
            }
        } else {
            this.vhsmLayout2.setVisibility(0);
        }
    }

    @Override
    public boolean valid() {
        if (!this.validProjectName()) {
            return false;
        }
        if (!this.validServerAddress()) {
            return false;
        }
        return !this.enableVHSM.isChecked() || this.validVHSMAddress();
    }

    private boolean validServerAddress() {
        int position;
        this.show = true;
        this.saveCurrentServerAddress();
        boolean success = true;
        ArrayList<ValidResult> resultList = new ArrayList<ValidResult>();
        for (position = 0; position < this.serverAddressesList.size(); ++position) {
            ServerAddress address = this.serverAddressesList.get(position);
            resultList.add(new ValidResult(this.validIP(address.getIp()), this.validPort(address.getPort())));
        }
        for (position = 0; position < resultList.size(); ++position) {
            ValidResult result = (ValidResult)resultList.get(position);
            if (result.ipResult && result.portResult) {
                this.updateServerBackground(position, true);
                continue;
            }
            this.updateServerBackground(position, false);
            success = false;
        }
        return success;
    }

    private boolean validVHSMAddress() {
        int position;
        this.show = true;
        this.saveCurrentVHSMAddress();
        boolean success = true;
        ArrayList<ValidResult> resultList = new ArrayList<ValidResult>();
        for (position = 0; position < this.vhsmAddressList.size(); ++position) {
            ServerAddress address = this.vhsmAddressList.get(position);
            resultList.add(new ValidResult(this.validIP(address.getIp()), this.validPort(address.getPort())));
        }
        for (position = 0; position < resultList.size(); ++position) {
            ValidResult result = (ValidResult)resultList.get(position);
            if (result.ipResult && result.portResult) {
                this.updateVHSMBackground(position, true);
                continue;
            }
            this.updateVHSMBackground(position, false);
            success = false;
        }
        return success;
    }

    private void saveCurrentServerAddress() {
        this.serverAddressesList.set(0, new ServerAddress(this.serverIP1.getText().toString(), this.serverPort1.getText().toString()));
        if (this.serverLayout2.getVisibility() == 0) {
            this.serverAddressesList.set(1, new ServerAddress(this.serverIP2.getText().toString(), this.serverPort2.getText().toString()));
        }
        if (this.serverLayout3.getVisibility() == 0) {
            this.serverAddressesList.set(2, new ServerAddress(this.serverIP3.getText().toString(), this.serverPort3.getText().toString()));
        }
        if (this.serverLayout4.getVisibility() == 0) {
            this.serverAddressesList.set(3, new ServerAddress(this.serverIP4.getText().toString(), this.serverPort4.getText().toString()));
        }
    }

    private void saveCurrentVHSMAddress() {
        this.vhsmAddressList.set(0, new ServerAddress(this.vhsmIP1.getText().toString(), this.vhsmPort1.getText().toString()));
        if (this.vhsmLayout2.getVisibility() == 0) {
            this.vhsmAddressList.set(1, new ServerAddress(this.vhsmIP2.getText().toString(), this.vhsmPort2.getText().toString()));
        }
        if (this.vhsmLayout3.getVisibility() == 0) {
            this.vhsmAddressList.set(2, new ServerAddress(this.vhsmIP3.getText().toString(), this.vhsmPort3.getText().toString()));
        }
        if (this.vhsmLayout4.getVisibility() == 0) {
            this.vhsmAddressList.set(3, new ServerAddress(this.vhsmIP4.getText().toString(), this.vhsmPort4.getText().toString()));
        }
    }

    private void updateServerBackground(final int position, final boolean success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (position == 0) {
                    if (success) {
                        ConfigStep1Activity.this.topLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.topLayout1.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 1) {
                    if (success) {
                        ConfigStep1Activity.this.topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.topLayout2.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 2) {
                    if (success) {
                        ConfigStep1Activity.this.topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.topLayout3.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 3) {
                    if (success) {
                        ConfigStep1Activity.this.topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.topLayout4.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                }
            }
        });
    }

    private void updateVHSMBackground(final int position, final boolean success) {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (position == 0) {
                    if (success) {
                        ConfigStep1Activity.this.vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 1) {
                    if (success) {
                        ConfigStep1Activity.this.vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 2) {
                    if (success) {
                        ConfigStep1Activity.this.vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                } else if (position == 3) {
                    if (success) {
                        ConfigStep1Activity.this.vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
                    } else {
                        ConfigStep1Activity.this.vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_error);
                    }
                }
            }
        });
    }

    private boolean validProjectName() {
        String projectName = this.etProjectName.getText().toString();
        if (TextUtils.isEmpty((CharSequence)projectName)) {
            ModuleToast.show(this.context, R.string.cert_creation_project_name_hint);
            return false;
        }
        if (projectName.length() > 20) {
            ModuleToast.show(this.context, R.string.cert_creation_err_length_project_name);
            return false;
        }
        return true;
    }

    private boolean validIP(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            if (this.show) {
                ModuleToast.show(this.context, R.string.cert_creation_config_empty_server_address);
            }
            this.show = false;
            return false;
        }
        boolean success = AddressUtil.validIP(ip);
        if (!success) {
            if (this.show) {
                ModuleToast.show(this.context, R.string.cert_creation_config_error_server_address);
            }
            this.show = false;
        }
        return success;
    }

    private boolean validPort(String port) {
        if (TextUtils.isEmpty((CharSequence)port)) {
            if (this.show) {
                ModuleToast.show(this.context, R.string.cert_creation_config_please_input_server_port);
            }
            this.show = false;
            return false;
        }
        boolean success = AddressUtil.validPort(port);
        if (!success) {
            if (this.show) {
                ModuleToast.show(this.context, R.string.cert_creation_config_error_server_port);
            }
            this.show = false;
        }
        return success;
    }

    @Override
    public void saveValue() {
        super.saveValue();
        if (this.enableVHSM.isChecked()) {
            this.saveCurrentVHSMAddress();
        }
    }

    @Override
    public String nextActivity() {
        return "/cert/config_step2";
    }

    @Override
    public void route() {
        super.route();
        Intent intent = new Intent(this.context, ConfigStep2Activity.class);
        intent.putExtra("projectName", this.etProjectName.getText().toString());
        intent.putExtra("serverAddressesList", this.serverAddressesList);
        intent.putExtra("vhsmAddressList", this.vhsmAddressList);
        intent.putExtra("enableVHSM", this.enableVHSM.isChecked());
        this.startActivity(intent);
    }

    protected int getTitleRes() {
        return R.string.cert_creation_setting;
    }

    private boolean checkValidPermission(String ... permissions) {
        for (String permission2 : permissions) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0) continue;
            return false;
        }
        return true;
    }

    private void showInvalidPermissionDialog() {
        ArrayList<String> list = new ArrayList<String>();
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            list.add(this.getString(R.string.verify_permission_content_item2));
        }
        String permission2 = HTMLText.formatPermissionText((Context)this, list);
        final BindIdentifyDialog bindIdentifyDialog = new BindIdentifyDialog(this.context);
        bindIdentifyDialog.setTitle(R.string.verify_permission_title);
        bindIdentifyDialog.setMessage(permission2);
        bindIdentifyDialog.setModel(2);
        bindIdentifyDialog.setNegativeButtonText(R.string.cert_creation_cancel);
        bindIdentifyDialog.setPositiveButtonText(R.string.cert_creation_ok);
        bindIdentifyDialog.setCancelable(false);
        bindIdentifyDialog.setCanceledOnTouchOutside(false);
        bindIdentifyDialog.show();
        bindIdentifyDialog.setClickListener(new BindIdentifyDialog.ClickListenerInterface(){

            public void doConfirm() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.checkoutPermission();
            }

            public void doCancel() {
                bindIdentifyDialog.dismiss();
                ConfigStep1Activity.this.finish();
            }
        });
    }

    @XdjaPermission(permissions={"android.permission.WRITE_EXTERNAL_STORAGE"})
    private void checkoutPermission() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        ModuleLog.d((Object)"\u6743\u9650\u56de\u8c03");
        boolean isGrant = false;
        for (int grantResult : grantResults) {
            if (grantResult != 0) {
                isGrant = false;
                break;
            }
            isGrant = true;
        }
        this.onRequestPermissionsResult(isGrant);
    }

    private void onRequestPermissionsResult(final boolean isGrant) {
        this.getWindow().getDecorView().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (!isGrant) {
                    ConfigStep1Activity.this.showNoPhonePermissionDialog();
                }
            }
        }, 10L);
    }

    public void showNoPhonePermissionDialog() {
        if (this.dialog == null) {
            this.initNoPermissionDialog();
        }
        this.dialog.show();
    }

    private void initNoPermissionDialog() {
        SinglePermissionDialog dialog = new SinglePermissionDialog();
        dialog.build((Context)this, 0);
    }

    private void onSwitchOnClick(boolean enableVHSM) {
        if (enableVHSM) {
            this.vhsmLayout.setVisibility(0);
            new Handler().post(new Runnable(){

                @Override
                public void run() {
                    ConfigStep1Activity.this.scrollView.fullScroll(130);
                }
            });
        } else {
            this.vhsmLayout.setVisibility(8);
            this.vhsmIP1.setText((CharSequence)"");
            this.vhsmPort1.setText((CharSequence)"");
            this.vhsmTopLayout1.setBackgroundResource(R.drawable.item_shape_server_address_normal);
            this.vhsmIP2.setText((CharSequence)"");
            this.vhsmPort2.setText((CharSequence)"");
            this.vhsmLayout2.setVisibility(8);
            this.vhsmTopLayout2.setBackgroundResource(R.drawable.item_shape_server_address_normal);
            this.vhsmIP3.setText((CharSequence)"");
            this.vhsmPort3.setText((CharSequence)"");
            this.vhsmLayout3.setVisibility(8);
            this.vhsmTopLayout3.setBackgroundResource(R.drawable.item_shape_server_address_normal);
            this.vhsmIP4.setText((CharSequence)"");
            this.vhsmPort4.setText((CharSequence)"");
            this.vhsmLayout4.setVisibility(8);
            this.vhsmTopLayout4.setBackgroundResource(R.drawable.item_shape_server_address_normal);
            this.vhsmAddressList.clear();
            this.vhsmAddressList.add(new ServerAddress());
        }
    }

    class ValidResult {
        boolean ipResult;
        boolean portResult;

        public ValidResult(boolean ipResult, boolean portResult) {
            this.ipResult = ipResult;
            this.portResult = portResult;
        }
    }
}

