/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.bean.ServerAddress;
import com.xdja.safeclient.certcreation.util.AddressUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import java.util.HashMap;
import java.util.List;

public class ServerAddressAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private Context context;
    private List<ServerAddress> list;
    private boolean unModified = true;
    HashMap<String, ServerAddress> map;

    public ServerAddressAdapter(Context context, List<ServerAddress> list) {
        this.context = context;
        this.list = list;
        this.map = new HashMap();
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.item_server_address, null));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        ServerAddress address = this.list.get(position);
        holder.ip.setText((CharSequence)address.getIp());
        if (this.unModified) {
            holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else if (this.validIP(address.getIp()) && this.validPort(address.getPort())) {
            holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_normal);
        } else {
            holder.topLayout.setBackgroundResource(R.drawable.item_shape_server_address_error);
        }
        holder.port.setText((CharSequence)address.getPort());
        if (position == 0) {
            holder.deleteServerAddress.setVisibility(8);
        } else {
            holder.deleteServerAddress.setVisibility(0);
        }
    }

    public int getItemCount() {
        return this.list.size();
    }

    private boolean validIP(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            ModuleToast.show(this.context, R.string.cert_creation_config_empty_server_address);
            return false;
        }
        boolean success = AddressUtil.validIP(ip);
        if (!success) {
            ModuleToast.show(this.context, R.string.cert_creation_config_error_server_address);
        }
        return success;
    }

    private boolean validPort(String port) {
        if (TextUtils.isEmpty((CharSequence)port)) {
            ModuleToast.show(this.context, R.string.cert_creation_config_please_input_server_port);
            return false;
        }
        boolean success = AddressUtil.validPort(port);
        if (!success) {
            ModuleToast.show(this.context, R.string.cert_creation_config_error_server_port);
        }
        return success;
    }

    public List<ServerAddress> getAddressList() {
        return this.list;
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView deleteServerAddress;
        EditText ip;
        EditText port;
        LinearLayout topLayout;

        public ViewHolder(View itemView) {
            super(itemView);
            this.deleteServerAddress = (ImageView)itemView.findViewById(R.id.delete_server_address);
            this.ip = (EditText)itemView.findViewById(R.id.ip);
            this.port = (EditText)itemView.findViewById(R.id.port);
            this.topLayout = (LinearLayout)itemView.findViewById(R.id.top_layout);
        }
    }
}

