/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.service;

import android.os.Environment;
import android.os.Message;
import com.aircert.util.WeakReferenceHandler;
import com.alibaba.fastjson.JSON;
import com.xdja.https.module.bean.HttpsParam;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.cache.RequestCache;
import com.xdja.safeclient.certcreation.databases.CacheModel;
import com.xdja.safeclient.certcreation.exception.CardNotExistException;
import com.xdja.safeclient.certcreation.service.ChipExecutorService;
import com.xdja.safeclient.certcreation.service.HttpClientHelper;
import com.xdja.safeclient.certcreation.service.RequestCallback;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class CertRequest {
    private String url;
    private String cardNo;
    private RequestBody body;
    private RequestCallback certCallback;
    private static final int CARD_EXCEPTION = -3;
    private static final int OTHER_EXCEPTION = -2;
    private static final int IOE_EXCEPTION = -1;
    private static final int RESPONSE_OK = 0;
    private static final int SEND_HTTPSPARAM = 1;
    private MyHandler myHandler = new MyHandler(this);
    private ChipExecutorService chipExecutorService = new ChipExecutorService();

    public CertRequest(String url, String cardNo, RequestBody body, RequestCallback callback) {
        this.url = url;
        this.cardNo = cardNo;
        this.body = body;
        this.certCallback = callback;
    }

    private long logRequest(String url) {
        long time = RequestCache.getInstance().getTime();
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        CacheModel value = new CacheModel();
        value.cardNo = this.cardNo;
        value.name = url;
        value.time = time + " | " + formatter.format(time);
        value.type = RequestCache.getInstance().getType(this.cardNo);
        if (url.contains("authentication")) {
            value.selfie = ImageCache.getInstance().getSelfie();
            value.idImage = ImageCache.getInstance().getId();
            if (value.selfie == null || value.idImage == null) {
                return time;
            }
            ImageCache.copyBase64ToFile(URLDecoder.decode(value.idImage), new File(Environment.getExternalStorageDirectory() + File.separator + "yishu" + File.separator + value.name + time + ".jpg"));
        }
        value.save();
        RequestCache.getInstance().resetTime();
        return time;
    }

    private Request initRequest(String url, String cardNo, RequestBody body) {
        if (cardNo == null) {
            return null;
        }
        Request.Builder builder = new Request.Builder();
        builder.addHeader("Content-Type", "application/json").addHeader("cardNo", cardNo).addHeader("clientTime", String.valueOf(System.currentTimeMillis())).url(url);
        if (body != null) {
            MediaType mediaType = MediaType.parse((String)"application/json; charset=UTF-8");
            String jsonStr = JSON.toJSONString((Object)body);
            body = RequestBody.create((MediaType)mediaType, (String)jsonStr);
            builder.post(body);
        }
        return builder.build();
    }

    public void request() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Request request = CertRequest.this.initRequest(CertRequest.this.url, CertRequest.this.cardNo, CertRequest.this.body);
                if (request == null) {
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, -3, null);
                    return;
                }
                OkHttpClient client = HttpClientHelper.getOkHttpClient();
                Call call = client.newCall(request);
                try {
                    Response response = call.execute();
                    ResponseInner responseInner = new ResponseInner();
                    responseInner.call = call;
                    responseInner.isSuccessful = response.isSuccessful();
                    responseInner.response = response.body().string();
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, 0, responseInner);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    e.printStackTrace();
                    Failure failure = new Failure();
                    failure.call = call;
                    failure.e = e;
                    CertRequest.this.chipExecutorService.sendMessage(CertRequest.this.myHandler, -1, failure);
                }
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private void doRequest(Request request, HttpsParam httpsParam) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        this.chipExecutorService.exe(runnable);
    }

    private HttpsParam generateHttpsParam() {
        HttpsParam httpsParam = new HttpsParam();
        httpsParam.setSupportHttps(true);
        httpsParam.setServerCertAccessPwd(AppConfig.getInstance().getDefaultConfig().getBksVerifyCode().toCharArray());
        httpsParam.setServerCertInputStream(AppConfig.getInstance().getContext().getResources().openRawResource(R.raw.truststore));
        return httpsParam;
    }

    private class ResponseInner {
        Call call;
        String response;
        boolean isSuccessful;

        private ResponseInner() {
        }
    }

    private class Failure {
        Call call;
        IOException e;

        private Failure() {
        }
    }

    private static class MyHandler
    extends WeakReferenceHandler<CertRequest> {
        public MyHandler(CertRequest reference) {
            super((Object)reference);
        }

        protected void handleMessage(CertRequest reference, Message msg) {
            int what = msg.what;
            if (what == 0) {
                ResponseInner responseInner = (ResponseInner)msg.obj;
                reference.certCallback.onResponse(responseInner.call, responseInner.isSuccessful, responseInner.response);
            } else if (what == -1) {
                Failure failure = (Failure)msg.obj;
                reference.certCallback.onFailure(failure.call, failure.e);
            } else if (what == -3) {
                reference.certCallback.onException(new CardNotExistException());
            } else {
                Exception e = (Exception)msg.obj;
                reference.certCallback.onException(e);
            }
        }
    }
}

