/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.yishu;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.support.v4.app.ActivityCompat;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;

public class DynamicPermission {
    private Context mContext;
    private String[] permissions;
    private List<String> noPermissions;
    private PassPermission passPermission;
    private int requestCode;
    private String permissionForbidName = "";
    AlertDialog permissionDialog = null;

    public DynamicPermission(Context context, PassPermission passPermission) {
        this.mContext = context;
        this.passPermission = passPermission;
        this.init();
    }

    public void getPermissionStart() {
        if (Environment.getExternalStorageState().equals("mounted")) {
            this.judgePermission();
        } else {
            Toast.makeText((Context)this.mContext, (CharSequence)"\u6b64\u8bbe\u5907\u65e0sd\u5361", (int)0).show();
        }
    }

    public boolean checkPermissionPassState() {
        if (this.permissionDialog != null) {
            this.getNoPermissions();
            if (this.noPermissions.size() > 0) {
                return false;
            }
        }
        return true;
    }

    public void permissionRequestOperation(int requestCode, String[] permission2, int[] grantResults) {
        boolean permissionAllPassed = true;
        boolean permissionAskNever = false;
        switch (requestCode) {
            case 1: {
                for (int i = 0; i < grantResults.length; ++i) {
                    if (grantResults[i] != -1) continue;
                    permissionAllPassed = false;
                    if (this.isRequestAllow(permission2[i])) continue;
                    permissionAskNever = true;
                    this.permissionForbidName = permission2[i];
                }
                break;
            }
        }
        if (permissionAllPassed) {
            this.passPermission.operation();
        } else if (permissionAskNever) {
            this.showPermissionDialog(this.permissionForbidName);
        } else {
            this.judgePermission();
        }
    }

    private boolean isRequestAllow(String permission2) {
        return ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)this.mContext), (String)permission2);
    }

    private void init() {
        this.permissions = new String[]{"android.permission.READ_PHONE_STATE", "android.permission.WRITE_EXTERNAL_STORAGE"};
        this.noPermissions = new ArrayList<String>();
        this.requestCode = 1;
    }

    private void judgePermission() {
        this.getNoPermissions();
        if (this.noPermissions.isEmpty()) {
            this.passPermission.operation();
        } else {
            String[] getPermissions = this.noPermissions.toArray(new String[this.noPermissions.size()]);
            ActivityCompat.requestPermissions((Activity)((Activity)this.mContext), (String[])getPermissions, (int)this.requestCode);
        }
    }

    public void showPermissionDialog() {
        this.showPermissionDialog(this.permissionForbidName);
    }

    private void showPermissionDialog(String name) {
        if (this.permissionDialog == null) {
            this.createPermissionDialog();
        }
        this.permissionDialog.setMessage((CharSequence)("\u5df2\u7981\u7528" + this.getPermissionName(name) + "\u76f8\u5173\u6743\u9650\uff0c\u8bf7\u624b\u52a8\u6388\u4e88"));
        this.permissionDialog.show();
    }

    private void createPermissionDialog() {
        this.permissionDialog = new AlertDialog.Builder(this.mContext).setMessage((CharSequence)"\u5df2\u7981\u7528\u76f8\u5173\u6743\u9650\uff0c\u8bf7\u624b\u52a8\u6388\u4e88").setPositiveButton((CharSequence)"\u8bbe\u7f6e", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DynamicPermission.this.permissionDialog.dismiss();
                Uri packageURI = Uri.parse((String)("package:" + DynamicPermission.this.mContext.getPackageName()));
                Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", packageURI);
                DynamicPermission.this.mContext.startActivity(intent);
            }
        }).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DynamicPermission.this.permissionDialog.dismiss();
                ((Activity)DynamicPermission.this.mContext).finish();
            }
        }).setCancelable(false).create();
    }

    private String getPermissionName(String name) {
        if (name.contains("STORAGE")) {
            return "\u5b58\u50a8";
        }
        if (name.contains("PHONE")) {
            return "\u7535\u8bdd";
        }
        return "";
    }

    private void getNoPermissions() {
        this.noPermissions.clear();
        for (int i = 0; i < this.permissions.length; ++i) {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)this.permissions[i]) == 0) continue;
            this.noPermissions.add(this.permissions[i]);
        }
    }

    public static interface PassPermission {
        public void operation();
    }
}

