/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.certcreation.yishu;

import android.content.Context;
import android.support.v7.widget.AppCompatEditText;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.util.AttributeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class IpEditer
extends AppCompatEditText {
    int mMaxLenth = 15;
    int color = -16777216;
    int ipType = 0;
    public static final int IPTYPE_IPV4 = 0;
    public static final int IPTYPE_IPV6 = 1;
    TextWatcher mTextWatcher = new TextWatcher(){

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void afterTextChanged(Editable s) {
            String str;
            String editable = IpEditer.this.getText().toString();
            if (!editable.equals(str = IpEditer.this.stringFilter(editable))) {
                IpEditer.this.setText(str);
                IpEditer.this.setSelection(++IpEditer.this.changedIndex);
            }
        }
    };
    int changedIndex;
    private String regexIpv4 = "^((25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)\\.){3}(25[0-5]|2[0-4]\\d|1\\d{2}|[1-9]\\d|\\d)$";
    private String regexIpv6 = "^/^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$/$";

    public IpEditer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setInputType(3);
        this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.mMaxLenth)});
        this.addTextChangedListener(this.mTextWatcher);
    }

    public String stringFilter(String str) throws PatternSyntaxException {
        String regEx = "[/\\:#*?<>|\"\n\ta-zA-Z]";
        String tmp = null;
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(str);
        if (m.find()) {
            tmp = m.replaceAll(".");
            for (int i = 0; i < tmp.length(); ++i) {
                if (tmp.charAt(i) == str.charAt(i)) continue;
                this.changedIndex = i;
                break;
            }
        } else {
            return str;
        }
        return tmp;
    }

    public int getIpType() {
        return this.ipType;
    }

    public void setIpType(int ipType) {
        this.ipType = ipType;
    }

    public int getChangedIndex() {
        return this.changedIndex;
    }

    public String getIpText() {
        return this.getText().toString();
    }

    public boolean isIpv4Text() {
        return this.getIpText().matches(this.regexIpv4);
    }

    public void checkFormat() {
        if (this.getIpText().matches(this.regexIpv4)) {
            this.setTextColor(this.color);
        } else {
            this.setTextColor(-65536);
        }
    }

    public boolean isIpv6Text() {
        return this.getIpText().matches(this.regexIpv6);
    }

    public void setIpText(String ipText) {
        if (ipText == null || ipText.length() <= 0) {
            return;
        }
        this.setText(ipText);
    }
}

