/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.squareup.otto.Subscribe;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.cryptodev.CryptoDevType;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.activity.SelfieActivity;
import com.xdja.safeclient.certcreation.device.DeviceWrapper;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.util.CryptoDevTypeUtil;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.Serializable;

@Route(name="\u4e0a\u4f20\u8eab\u4efd\u8bc1\u7167\u7247", path="/cert/id_ready")
public class IDReadyActivity
extends BaseActivity {
    @Autowired
    public int type;
    String cardNo;
    CryptoDevType cardType;
    String phone;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_camera_id_ready);
        this.left_title_tv.invalidate();
        this.hideBG();
        this.cardType = CryptoDevTypeUtil.formatType(SharePreferencesUtil.getCurrentDevType((Context)this));
        this.cardNo = DeviceWrapper.getInstance().getCardID(this.cardType);
        this.phone = SharePreferencesUtil.getPhoneNum((Context)this);
        if (TextUtils.isEmpty((CharSequence)this.cardNo)) {
            ModuleToast.show(this.context, R.string.cert_creation_card_device_error);
            return;
        }
        Button bt_startdect = (Button)this.findViewById(R.id.start);
        bt_startdect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                IDReadyActivity.this.next();
            }
        });
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.type = this.getIntent().getIntExtra("photoType", 0);
    }

    @Override
    public boolean valid() {
        return ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") == 0;
    }

    @Override
    public String nextActivity() {
        return "/cert/selfie";
    }

    @Override
    public void route() {
        super.route();
        Intent intent = new Intent((Context)this, SelfieActivity.class);
        intent.putExtra("type", this.type);
        intent.putExtra("cardNo", this.cardNo);
        intent.putExtra("cardType", (Serializable)this.cardType);
        intent.putExtra("phone", this.phone);
        this.startActivity(intent);
    }

    @XdjaPermission(permissions={"android.permission.CAMERA"})
    private void requestCamera() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (permissions[0].equals("android.permission.CAMERA") && grantResults[0] == 0) {
            this.next();
        }
    }

    protected int getTitleRes() {
        return R.string.cert_creation_selfie_photo_title;
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        this.finish();
    }
}

