/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.cloudwalk.CloudwalkSDK;
import cn.cloudwalk.libproject.Bulider;
import cn.cloudwalk.libproject.LiveActivity;
import cn.cloudwalk.libproject.callback.NoDoubleClickListener;
import cn.cloudwalk.libproject.progressHUD.CwProgressHUD;
import cn.cloudwalk.libproject.util.LogUtils;
import com.aircert.event.LiveResult;
import com.aircert.event.YuncongAuth;
import com.aircert.util.ModuleLog;
import com.alibaba.android.arouter.facade.annotation.Autowired;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.baidu.idl.face.example.FaceLivenessExpActivity;
import com.baidu.idl.face.platform.FaceSDKManager;
import com.baidu.idl.face.platform.listener.IInitCallback;
import com.squareup.otto.Subscribe;
import com.xdja.a3rdplugin.demo.LiveCompany;
import com.xdja.aspectjmodule.annotation.XdjaPermission;
import com.xdja.safeclient.certcreation.AppConfig;
import com.xdja.safeclient.certcreation.HttpResponseCallBack;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.Selfie;
import com.xdja.safeclient.certcreation.activity.BaseActivity;
import com.xdja.safeclient.certcreation.bean.response.BaseErrorResponse;
import com.xdja.safeclient.certcreation.bean.response.CommonResponse;
import com.xdja.safeclient.certcreation.bean.result.KuangshiResult;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import com.xdja.safeclient.certcreation.config.FaceLicenseConfig;
import com.xdja.safeclient.certcreation.event.FinishActivity;
import com.xdja.safeclient.certcreation.event.SpecificActivity;
import com.xdja.safeclient.certcreation.service.CertService;
import com.xdja.safeclient.certcreation.util.Base64Util;
import com.xdja.safeclient.certcreation.util.ModuleToast;
import com.xdja.safeclient.certcreation.util.ScreenUtil;
import com.xdja.safeclient.certcreation.util.SharePreferencesUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import ocr.activity.ChooseBindWayActivity;
import okhttp3.Call;

@Route(name="\u4e91\u4ece\u4eba\u8138\u8bc6\u522b\u5f00\u59cb", path="/cert/yuncong/live")
public class LiveStartActivity
extends BaseActivity {
    public final String TAG = LogUtils.makeLogTag((String)"LiveStartActivity");
    public static final String MODULES = "modules";
    public static final String MODULES_ZIP = "modules.zip";
    private Button mBt_startdect;
    private CwProgressHUD processDialog;
    TextView tv_tips1;
    @Autowired(name="containerNum")
    public int containerNum;
    private String liveCompany;
    private Bulider builder;

    protected int getToolbarType() {
        return 0;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_live_start);
        this.tv_tips1 = (TextView)this.findViewById(R.id.hint1);
        this.liveCompany = AppConfig.getInstance().getServerSettingConfig().getLiveCompany();
        if (ScreenUtil.isFullScreen((Activity)this)) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(0, ScreenUtil.dip2px(this.context, 50.0f), 0, 0);
            layoutParams.addRule(14);
            this.tv_tips1.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.prepare();
    }

    @Override
    protected void getIntentData() {
        super.getIntentData();
        this.containerNum = this.getIntent().getIntExtra("containerNum", 0);
    }

    @Subscribe
    public void handleSpecificActivity(SpecificActivity activity) {
        if (((Object)((Object)this)).getClass().getName().equals(activity.getTag())) {
            this.finish();
        }
    }

    @Subscribe
    public void handleFinishActivity(FinishActivity activity) {
        this.finish();
    }

    @Subscribe
    public void handleLiveResult(LiveResult liveResult) {
        String img = liveResult.getImg();
        if (img != null && img.length() > 0) {
            this.gotoNext(liveResult.getImg());
        }
    }

    private void prepare() {
        this.mBt_startdect = (Button)this.findViewById(R.id.start);
        this.mBt_startdect.setOnClickListener((View.OnClickListener)new NoDoubleClickListener(){

            public void onNoDoubleClick(View v) {
                if (ContextCompat.checkSelfPermission((Context)LiveStartActivity.this, (String)"android.permission.CAMERA") != 0) {
                    LiveStartActivity.this.requestCamera();
                } else {
                    LiveStartActivity.this.start();
                }
            }
        });
    }

    @XdjaPermission(permissions={"android.permission.CAMERA"})
    private void requestCamera() {
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (permissions[0].equals("android.permission.CAMERA") && grantResults[0] == 0) {
            this.start();
        }
    }

    @Subscribe
    public void handleYuncongAuth(YuncongAuth yuncongAuth) {
        this.getYunCongLicense();
    }

    private void getYunCongLicense() {
        new CertService().getOcrAuthCode(SharePreferencesUtil.getDevCardID((Context)this), new HttpResponseCallBack<CommonResponse>(){

            @Override
            public void onOtherException(Exception e) {
            }

            @Override
            public void onIoExceptionFailure(Call call, IOException e) {
            }

            @Override
            public void onSuccessfulResponse(Call call, CommonResponse commonResponse) {
                if (commonResponse.getResult().equals("0")) {
                    String license = commonResponse.getMessage();
                    if (license != null && license.length() > 0) {
                        Bulider.licence = license;
                        SharePreferencesUtil.saveLicense((Context)LiveStartActivity.this, license);
                        ModuleToast.show((Context)LiveStartActivity.this, LiveStartActivity.this.getString(R.string.cert_creation_license_success));
                    } else {
                        ModuleToast.show((Context)LiveStartActivity.this, LiveStartActivity.this.getString(R.string.cert_creation_license_fail));
                    }
                }
            }

            @Override
            public void onFailResponse(Call call, BaseErrorResponse baseErrorResponse) {
            }

            @Override
            public void dismissDialog() {
            }
        });
    }

    private void start() {
        ModuleLog.e((Object)this.liveCompany);
        boolean isYuncong = this.liveCompany.equals("\u4e91\u4ece");
        if (isYuncong) {
            this.builder = new Bulider();
            this.checkModule();
        }
        if (isYuncong) {
            Intent intent = new Intent(this.context, LiveActivity.class);
            Bulider.startCls = LiveActivity.class;
            Bundle bundle = new Bundle();
            bundle.putString("license", SharePreferencesUtil.getLicense((Context)this));
            intent.putExtras(bundle);
            this.startActivity(intent);
            this.overridePendingTransition(R.anim.left_in, R.anim.left_out);
        } else if (this.liveCompany.equals("\u65f7\u4e16")) {
            LiveCompany.kuangshi((Context)this);
        } else if (this.liveCompany.equals("\u767e\u5ea6")) {
            this.startBaidu();
        }
    }

    private void startBaidu() {
        if (FaceSDKManager.getInstance().getInitFlag()) {
            Intent intent = new Intent(this.context, FaceLivenessExpActivity.class);
            this.startActivity(intent);
        }
        FaceSDKManager.getInstance().initialize((Context)this, FaceLicenseConfig.getLicenseKeyId(true), "idl-license.face-android", new IInitCallback(){

            public void initSuccess() {
                LiveStartActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Intent intent = new Intent(LiveStartActivity.this.context, FaceLivenessExpActivity.class);
                        LiveStartActivity.this.startActivity(intent);
                    }
                });
            }

            public void initFailure(final int errCode, final String errMsg) {
                LiveStartActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        Log.e((String)LiveStartActivity.this.TAG, (String)("\u521d\u59cb\u5316\u5931\u8d25 = " + errCode + " " + errMsg));
                        ModuleToast.show(LiveStartActivity.this.context, "\u521d\u59cb\u5316\u5931\u8d25");
                    }
                });
            }
        });
    }

    @Subscribe
    public void handleKuangshiResult(KuangshiResult result) {
        if (result.isSuccess()) {
            Intent intent = ChooseBindWayActivity.buildIntent((Context)this, this.containerNum, this.getFaceImg());
            this.startActivity(intent);
        } else {
            ModuleToast.show(this.context, R.string.cert_creation_kuangshi_fail);
        }
    }

    private String getFaceImg() {
        String path = Environment.getExternalStorageDirectory().getAbsolutePath() + "/faceapp";
        String img = Base64Util.fromFile(this.context, Uri.parse((String)(path + File.separator + "demo" + File.separator + "only.jpg")));
        ImageCache.getInstance().setSelfie(Selfie.KUANGSHI, img, false);
        return img;
    }

    private void checkModule() {
        ArrayList<Integer> liveList = new ArrayList<Integer>();
        liveList.add(1005);
        liveList.add(1000);
        liveList.add(1001);
        liveList.add(1004);
        this.builder.setLives(liveList);
        File installation = new File(this.getFilesDir(), MODULES);
        String storagePath = installation.getAbsolutePath();
        StringBuilder pFaceDetectFile = new StringBuilder(storagePath + File.separator + "faceDetector_2_4.mdl");
        StringBuilder pFaceKeyPtFile = new StringBuilder(storagePath + File.separator + "keypt_detect_model_sdm_9pts.bin");
        StringBuilder pFaceKeyPtTrackFile = new StringBuilder(storagePath + File.separator + "keypt_track_model_sdm_9pts.bin");
        StringBuilder pFaceQualityFile = new StringBuilder(storagePath + File.separator + "facequality_4_1.bin");
        StringBuilder pFaceLivenessFile = new StringBuilder(storagePath + File.separator + "liveness171120.bin");
        boolean allModulesExist = false;
        if (installation.exists() && new File(pFaceDetectFile.toString()).exists() && new File(pFaceKeyPtFile.toString()).exists() && new File(pFaceKeyPtTrackFile.toString()).exists() && new File(pFaceQualityFile.toString()).exists() && new File(pFaceLivenessFile.toString()).exists()) {
            allModulesExist = true;
        }
        if (!allModulesExist) {
            this.processDialog = CwProgressHUD.create((Context)this).setStyle(CwProgressHUD.Style.SPIN_INDETERMINATE).setLabel(this.getString(R.string.cloudwalk_copy_modules)).setCancellable(true).setAnimationSpeed(2).setDimAmount(0.5f);
            this.processDialog.show();
            this.mBt_startdect.setEnabled(false);
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            });
        } else {
            try {
                CloudwalkSDK.getInstance().setModulePath(this.getFilesDir().getAbsolutePath() + File.separator + MODULES);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)("copy module Exception:" + e.getMessage()));
            }
        }
    }

    private void gotoChooseBindWayActivity(String imgBase64) {
        ImageCache.getInstance().setSelfie(Selfie.YUNCONG, imgBase64, false);
        Intent intent = new Intent((Context)this, ChooseBindWayActivity.class);
        intent.putExtra("faceImg", imgBase64);
        intent.putExtra("containerNum", this.containerNum);
        this.startActivity(intent);
    }

    private void gotoNext(String imgBase64) {
        this.gotoChooseBindWayActivity(imgBase64);
    }

    protected int getTitleRes() {
        return R.string.live_prepare_title;
    }

    protected boolean isOCRActivity() {
        return true;
    }
}

