/*
 * Decompiled with CFR 0.152.
 */
package ocr.activity;

import android.content.Context;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.os.Bundle;
import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.view.LoadingDialog;
import ocr.activity.FragmentToolBarActivity;
import ocr.fragment.AbnormalPromptFragment;
import ocr.fragment.NFCLoadingFragment;

public abstract class NFCActivity
extends FragmentToolBarActivity {
    private LoadingDialog dialog;
    public static final int NFC_UN_SUPPORT = -2;
    public static final int NFC_OPEN = 0;
    public static final int NFC_CLOSE = -1;
    protected int currentState = -1;
    private String[] tags = new String[]{"NFCLoadingFragment", "AbnormalPromptFragment"};
    private AbnormalPromptFragment abnormalPromptFragment = null;
    public NFCLoadingFragment nfcLoadingFragment = null;

    @Override
    protected LoadingDialog buildDialog() {
        return new LoadingDialog((Context)this);
    }

    protected int getToolbarType() {
        return 0;
    }

    protected int getTitleRes() {
        return R.string.cert_creation_nfc_title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.layout_nfc);
        this.dialog = this.buildDialog();
        this.dialog.setCancelable(this.setDialogCancelable());
    }

    @Override
    protected boolean setDialogCancelable() {
        return true;
    }

    @Override
    protected void showLoading() {
        if (this.dialog != null && !this.dialog.isShowing()) {
            this.dialog.showLoading();
        }
    }

    @Override
    protected void dismissLoading() {
        if (this.dialog != null) {
            this.dialog.dismissLoading();
        }
    }

    protected void onResume() {
        super.onResume();
        this.currentState = this.setNFCState();
    }

    public void showNetworkErrFragment() {
        if (this.abnormalPromptFragment == null) {
            this.abnormalPromptFragment = new AbnormalPromptFragment();
        }
        this.showFragmentWithTag(this.abnormalPromptFragment, this.tags[1]);
    }

    public void showUnopenUFCFragment() {
        if (this.nfcLoadingFragment == null) {
            this.nfcLoadingFragment = new NFCLoadingFragment();
        }
        this.showFragmentWithTag(this.nfcLoadingFragment, this.tags[0]);
    }

    public void showUnsopportNFCFragment() {
        if (this.nfcLoadingFragment == null) {
            this.nfcLoadingFragment = new NFCLoadingFragment();
        }
        this.showFragmentWithTag(this.nfcLoadingFragment, this.tags[0]);
    }

    public void showNormalFragment() {
        if (this.nfcLoadingFragment == null) {
            this.nfcLoadingFragment = new NFCLoadingFragment();
        }
        this.showFragmentWithTag(this.nfcLoadingFragment, this.tags[0]);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    protected int setNFCState() {
        NfcManager manager = (NfcManager)this.getSystemService("nfc");
        NfcAdapter adapter = manager.getDefaultAdapter();
        if (adapter == null) {
            this.showUnsopportNFCFragment();
            return -2;
        }
        if (adapter.isEnabled()) {
            this.showNormalFragment();
            return 0;
        }
        this.showUnopenUFCFragment();
        return -1;
    }
}

