/*
 * Decompiled with CFR 0.152.
 */
package ocr.util;

import android.graphics.Bitmap;
import android.text.TextUtils;
import cn.cloudwalk.libproject.util.Base64Util;
import cn.cloudwalk.libproject.util.ImgUtil;
import com.xdja.a3rdplugin.demo.IDUtil;
import com.xdja.nfcoperate.bean.CardInfo;
import com.xdja.safeclient.certcreation.cache.ImageCache;
import ocr.bean.IDCardInfo;

public class Convert {
    public static IDCardInfo cardInfoToIdentifyInfo(CardInfo cardInfo) {
        IDCardInfo info = new IDCardInfo();
        info.setAddr(cardInfo.getAddress());
        info.setBirthDate(Convert.convertBirthday(cardInfo.getBirthday()));
        info.setIdNum(cardInfo.getCardNum());
        if (cardInfo.getGender().equals("\u7537")) {
            info.setSex(1);
        } else {
            info.setSex(2);
        }
        info.setName(cardInfo.getName());
        info.setNation(cardInfo.getNation());
        byte[] imgBData = ImgUtil.bitmapToByte((Bitmap)cardInfo.getPhoto(), (Bitmap.CompressFormat)Bitmap.CompressFormat.JPEG, (int)90);
        info.setPhoto(Base64Util.encode((byte[])imgBData));
        ImageCache.getInstance().setId("\u4fe1\u5927\u6377\u5b89", Base64Util.encode((byte[])imgBData));
        info.setIssueOffice(cardInfo.getEnrollInstitution());
        info.setValidDate(IDUtil.formatValidDate((String)(cardInfo.getValidStartDate() + cardInfo.getValidEndDate())));
        return info;
    }

    private static String convertBirthday(String dataFromNFC) {
        if (TextUtils.isEmpty((CharSequence)dataFromNFC) || dataFromNFC.length() < 8) {
            return dataFromNFC;
        }
        String BornYear = dataFromNFC.substring(0, 4);
        String BornMouth = dataFromNFC.substring(4, 6);
        String BornDate = dataFromNFC.substring(6, 8);
        return BornYear + "\u5e74" + BornMouth + "\u6708" + BornDate + "\u65e5";
    }
}

