package com.xdja.safeclient.certcreation.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;

/**
 * Created by Administrator on 2018/12/5 0005.
 */

public class ImageUtil {

    /**
     * 顺时针旋转90度
     *
     * @param bitmap
     * @return
     */
    public static Bitmap rotate90(Bitmap bitmap) {
        return rotate(bitmap, 90);
    }


    /**图片顺时针进行旋转
     * @param bitmap
     * @param orientationDegree
     * @return
     */
    public static Bitmap rotate(Bitmap bitmap, final int orientationDegree) {

        Matrix matrix = new Matrix();
        matrix.setRotate(orientationDegree, (float) bitmap.getWidth() / 2, (float) bitmap.getHeight() / 2);
        float targetX, targetY;
        if (orientationDegree == 90) {
            targetX = bitmap.getHeight();
            targetY = 0;
        } else {
            targetX = bitmap.getHeight();
            targetY = bitmap.getWidth();
        }

        final float[] values = new float[9];
        matrix.getValues(values);

        float x1 = values[Matrix.MTRANS_X];
        float y1 = values[Matrix.MTRANS_Y];

        matrix.postTranslate(targetX - x1, targetY - y1);

        Bitmap result = Bitmap.createBitmap(bitmap.getHeight(), bitmap.getWidth(), Bitmap.Config.ARGB_8888);

        Paint paint = new Paint();
        Canvas canvas = new Canvas(result);
        canvas.drawBitmap(bitmap, matrix, paint);

        return result;
    }


}
