/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xdja.safeclient.certcreation.yishu;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import com.xdja.safeclient.certcreation.R;

/**
 * This Activity appears as a dialog. It lists any paired devices and
 * devices detected in the area after discovery. When a device is chosen
 * by the user, the MAC address of the device is sent back to the parent
 * Activity in the result Intent.
 */
public class SetServerIPActivity extends Activity {
	// Debugging

	private EditText ip_deviceA;
	private EditText porttext;
	private Button button_ok;
	private String ip;
	private int port;
	private static final int SETTING_SERVER_IP = 11;
//	private static String remoteIPA = "";
//	private static String remoteIPB = "";
//	private static String remoteIPC = "";
//	private static String porttxt = "";

//	private static String DB_NAME;
//	private static final int DB_VERSION = 2;
//	private static DatabaseHelper mOpenHelper;
//	private static SQLiteDatabase db;

//	public static String DB_CREATE_TABLE_IPCONFIG = "CREATE TABLE IF NOT EXISTS [setipconfig] " +
//			"([ID] INTEGER PRIMARY KEY,[IP] VARCHAR)";
//
//	private static class DatabaseHelper extends SQLiteOpenHelper {
//		DatabaseHelper(Context context) {
//			super(context, DB_NAME, null, DB_VERSION);
//		}
//		@Override
//		public void onCreate(SQLiteDatabase db) {
//			db.execSQL(DB_CREATE_TABLE_IPCONFIG);
//		}
//		@Override
//		public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
//		}
//	}
//	public void DbCreate(SQLiteDatabase db) {
//		db.execSQL(DB_CREATE_TABLE_IPCONFIG);
//	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// Setup the window
		requestWindowFeature(Window.FEATURE_INDETERMINATE_PROGRESS);
		setContentView(R.layout.ip_set);
		ip_deviceA = (EditText) findViewById(R.id.ip_deviceA);
		porttext = (EditText) findViewById(R.id.Port);
//		DB_NAME = "/sdcard/yishu/usingservice.db";
//		mOpenHelper = new DatabaseHelper(this);
//		db = mOpenHelper.getWritableDatabase();
//		DbCreate(db);
//		String sql = "select IP from setipconfig where ID=1;";
//		Cursor cur;
//		cur = db.rawQuery(sql, null);
//		if (cur.moveToFirst()==true)
//		{
//			while (!cur.isAfterLast()) {
//				remoteIPA = cur.getString(0).trim();
//				break;
//			}
//		}
//		cur.close();
//		sql = "select IP from setipconfig where ID=2;";
//		cur = db.rawQuery(sql, null);
//		if (cur.moveToFirst()==true)
//		{
//			while (!cur.isAfterLast()) {
//				remoteIPB = cur.getString(0).trim();
//				break;
//			}
//		}
//		cur.close();
//		sql = "select IP from setipconfig where ID=3;";
//		cur = db.rawQuery(sql, null);
//		if (cur.moveToFirst()==true)
//		{
//			while (!cur.isAfterLast()) {
//				remoteIPC = cur.getString(0).trim();
//				break;
//			}
//		}
//		cur.close();
//		sql = "select IP from setipconfig where ID=5;";
//		cur = db.rawQuery(sql, null);
//		if (cur.moveToFirst()==true)
//		{
//			while (!cur.isAfterLast()) {
//				porttxt = cur.getString(0).trim();
//				break;
//			}
//		}
//		cur.close();

//		ip_deviceA.setText(remoteIPA);
//		if (porttxt.length()<2)
//		{
//			porttext.setText("9000");
//		}else
//		{
//			porttext.setText(porttxt);
//		}
		button_ok = (Button) findViewById(R.id.button_ok);
		button_ok.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				String currIP = ip_deviceA.getText().toString();
				if("".equals(currIP)){
					Toast.makeText(SetServerIPActivity.this,"IP不可为空",Toast.LENGTH_SHORT).show();
					return;
				}
				String portStr = porttext.getText().toString();
				if("".equals(portStr)){
					Toast.makeText(SetServerIPActivity.this,"端口不可为空",Toast.LENGTH_SHORT).show();
					return;
				}
				int currPort = Integer.parseInt(portStr);
				Intent result = new Intent();
				result.putExtra("ip",currIP);
				result.putExtra("port",currPort);
				setResult(SETTING_SERVER_IP,result);
//				remoteIPA=ip_deviceA.getText().toString();
//				String sql = "select IP from setipconfig where ID=1;";
//				int p=0;
//				Cursor cur;
//				cur = db.rawQuery(sql, null);
//				if (cur.moveToFirst()==true)
//				{
//					while (!cur.isAfterLast()) {
//						p++;
//						break;
//					}
//				}
//				cur.close();
//
//				if (p==0)
//				{
//					sql= "insert into setipconfig (ID,IP) values(1,'"+remoteIPA+"');";
//					db.execSQL(sql);
//				}else
//				{
//					sql="update setipconfig set IP='"+remoteIPA+"'"+" where ID=1"+";";
//					db.execSQL(sql);
//				}
//				sql = "select IP from setipconfig where ID=2;";
//				p=0;
//				cur = db.rawQuery(sql, null);
//				if (cur.moveToFirst()==true)
//				{
//					while (!cur.isAfterLast()) {
//						p++;
//						break;
//					}
//				}
//				cur.close();
//
//				if (p==0)
//				{
//					sql= "insert into setipconfig (ID,IP) values(2,'"+remoteIPB+"');";
//					db.execSQL(sql);
//				}else
//				{
//					sql="update setipconfig set IP='"+remoteIPB+"'"+" where ID=2"+";";
//					db.execSQL(sql);
//				}
//				sql = "select IP from setipconfig where ID=3;";
//				p=0;
//				cur = db.rawQuery(sql, null);
//				if (cur.moveToFirst()==true)
//				{
//					while (!cur.isAfterLast()) {
//						p++;
//						break;
//					}
//				}
//				cur.close();
//
//				if (p==0)
//				{
//					sql= "insert into setipconfig (ID,IP) values(3,'"+remoteIPC+"');";
//					db.execSQL(sql);
//				}else
//				{
//					sql="update setipconfig set IP='"+remoteIPC+"'"+" where ID=3"+";";
//					db.execSQL(sql);
//				}

//				porttxt=porttext.getText().toString();
//				sql = "select IP from setipconfig where ID=5;";
//				p=0;
//				cur = db.rawQuery(sql, null);
//				if (cur.moveToFirst()==true)
//				{
//					while (!cur.isAfterLast()) {
//						p++;
//						break;
//					}
//				}
//				cur.close();
//
//				if (p==0)
//				{
//					if (porttxt.length()<2) porttxt="9000";
//					sql= "insert into setipconfig (ID,IP) values(5,'"+porttxt+"');";
//					db.execSQL(sql);
//				}else
//				{
//					if (porttxt.length()<2) porttxt="9000";
//					sql="update setipconfig set IP='"+porttxt+"'"+" where ID=5"+";";
//					db.execSQL(sql);
//				}

				finish();
			}
		});
		Intent intent = getIntent();
		ip = intent.getStringExtra("ip");
		port = intent.getIntExtra("port",0);
		ip_deviceA.setText(ip);
		porttext.setText(port+"");
	}

	@Override
	protected void onDestroy() {
		super.onDestroy();
//		db.close();
//		mOpenHelper.close();
	}

}
