package ocr.activity;

import android.content.Context;
import android.nfc.NfcAdapter;
import android.nfc.NfcManager;
import android.os.Bundle;

import com.xdja.safeclient.certcreation.R;
import com.xdja.safeclient.certcreation.view.LoadingDialog;

import ocr.fragment.AbnormalPromptFragment;
import ocr.fragment.NFCLoadingFragment;

/**
 * NFC基类Activity，主要追求界面复用
 * Created by gyx on 2018/6/21.
 */

public abstract class NFCActivity extends FragmentToolBarActivity {

    private LoadingDialog dialog;

    protected LoadingDialog buildDialog() {
        return new LoadingDialog(this);
    }

    public static final int NFC_UN_SUPPORT = -2;

    public static final int NFC_OPEN = 0;

    public static final int NFC_CLOSE = -1;

    protected int currentState = -1;

    @Override
    protected int getToolbarType() {
        return ToolBarDef.NAVIGATE_BACK;
    }

    @Override
    protected int getTitleRes() {
        return R.string.cert_creation_nfc_title;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.layout_nfc);
        dialog = buildDialog();
        dialog.setCancelable(setDialogCancelable());
    }

    protected boolean setDialogCancelable() {
        return true;
    }

    /**
     * 将网络请求的Loading统一封装展示
     */
    protected void showLoading() {
        if (dialog != null) {
            if (!dialog.isShowing()) {
                dialog.showLoading();
            }
        }
    }

    /**
     * 请求返回结果后取消Loading
     */
    protected void dismissLoading() {
        if (dialog != null) {
            dialog.dismissLoading();
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        currentState = setNFCState();
    }

    private String[] tags = {"NFCLoadingFragment", "AbnormalPromptFragment"};
    private AbnormalPromptFragment abnormalPromptFragment = null;

    /**
     * 网络异常界面
     */
    public void showNetworkErrFragment() {
        if (abnormalPromptFragment == null) {
            abnormalPromptFragment = new AbnormalPromptFragment();
        }
        showFragmentWithTag(abnormalPromptFragment, tags[1]);
    }

    /**
     * 未开启NFC
     */
    public void showUnopenUFCFragment() {
        if (nfcLoadingFragment == null) {
            nfcLoadingFragment = new NFCLoadingFragment();
        }
        showFragmentWithTag(nfcLoadingFragment, tags[0]);
    }

    /**
     * 不支持NFC
     */
    public void showUnsopportNFCFragment() {
        if (nfcLoadingFragment == null) {
            nfcLoadingFragment = new NFCLoadingFragment();
        }
        showFragmentWithTag(nfcLoadingFragment, tags[0]);
    }


    public NFCLoadingFragment nfcLoadingFragment = null;

    /**
     * NFC已开启
     */
    public void showNormalFragment() {
        if (nfcLoadingFragment == null) {
            nfcLoadingFragment = new NFCLoadingFragment();
        }
        showFragmentWithTag(nfcLoadingFragment, tags[0]);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
    }

    protected int setNFCState() {

        NfcManager manager = (NfcManager) getSystemService(Context.NFC_SERVICE);
        NfcAdapter adapter = manager.getDefaultAdapter();

        if (adapter == null) {
            showUnsopportNFCFragment();
            return NFC_UN_SUPPORT;
        }

        if (adapter.isEnabled()) {
            showNormalFragment();
            return NFC_OPEN;
        } else {
            showUnopenUFCFragment();
            return NFC_CLOSE;
        }

    }

}
